/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.models.gitlab;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AccessLevel implements Enumerator
{
    INVALID(-1, "Invalid", "Invalid"),
    NONE(0, "None", "None"),
    MINIMAL_ACCESS(5, "MinimalAccess", "MinimalAccess"),
    GUEST(10, "Guest", "Guest"),
    REPORTER(20, "Reporter", "Reporter"),
    DEVELOPER(30, "Developer", "Developer"),
    MAINTAINER(40, "Maintainer", "Maintainer"),
    OWNER(50, "Owner", "Owner"),
    ADMIN(60, "Admin", "Admin");

    public static final int INVALID_VALUE = -1;
    public static final int NONE_VALUE = 0;
    public static final int MINIMAL_ACCESS_VALUE = 5;
    public static final int GUEST_VALUE = 10;
    public static final int REPORTER_VALUE = 20;
    public static final int DEVELOPER_VALUE = 30;
    public static final int MAINTAINER_VALUE = 40;
    public static final int OWNER_VALUE = 50;
    public static final int ADMIN_VALUE = 60;
    private static final AccessLevel[] VALUES_ARRAY;
    public static final List<AccessLevel> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static AccessLevel get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            AccessLevel result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static AccessLevel getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            AccessLevel result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static AccessLevel get(int value) {
        switch (value) {
            case -1: {
                return INVALID;
            }
            case 0: {
                return NONE;
            }
            case 5: {
                return MINIMAL_ACCESS;
            }
            case 10: {
                return GUEST;
            }
            case 20: {
                return REPORTER;
            }
            case 30: {
                return DEVELOPER;
            }
            case 40: {
                return MAINTAINER;
            }
            case 50: {
                return OWNER;
            }
            case 60: {
                return ADMIN;
            }
        }
        return null;
    }

    private AccessLevel(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new AccessLevel[]{INVALID, NONE, MINIMAL_ACCESS, GUEST, REPORTER, DEVELOPER, MAINTAINER, OWNER, ADMIN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

