/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.model.app.gen.maven;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.URI;
import org.nasdanika.common.Context;
import org.nasdanika.common.NasdanikaException;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.common.Util;
import org.nasdanika.html.model.app.gen.SemanticSiteGenerator;
import org.nasdanika.html.model.app.gen.maven.AbstractSemanticGeneratorMojo;

@Mojo(name="generate-semantic-site", defaultPhase=LifecyclePhase.SITE)
public class SemanticSiteGeneratorMojo
extends AbstractSemanticGeneratorMojo {
    @Parameter(defaultValue="target/semantic-site")
    private File outputDirectory;
    @Parameter(defaultValue="target/semantic-site-work-dir")
    private File workDirectory;
    @Parameter
    private boolean cleanWorkDir;
    @Parameter(required=true)
    private String pageTemplate;
    @Parameter
    private String siteMapDomain;
    @Parameter
    private String drawioViewer;
    @Parameter(required=false)
    private int errors;
    @Parameter
    private String rootAction;

    protected void execute(Context context, ProgressMonitor progressMonitor) {
        SemanticSiteGenerator semanticSiteGenerator = this.createSemanticSiteGenerator(context, progressMonitor);
        File baseDir = this.project.getBasedir();
        URI baseDirURI = URI.createFileURI((String)baseDir.getAbsolutePath()).appendSegment("");
        URI semanticModelURI = URI.createURI((String)this.model).resolve(baseDirURI);
        URI pageTemplateURI = URI.createURI((String)this.pageTemplate).resolve(baseDirURI);
        URI rootActionURI = Util.isBlank((String)this.rootAction) ? null : URI.createURI((String)this.rootAction).resolve(baseDirURI);
        try {
            Map errors = semanticSiteGenerator.generate(semanticModelURI, rootActionURI, pageTemplateURI, this.siteMapDomain, this.outputDirectory, this.workDirectory, this.cleanWorkDir);
            int errorCount = 0;
            for (Map.Entry ee : errors.entrySet()) {
                this.getLog().error((CharSequence)ee.getKey());
                for (String error : (Collection)ee.getValue()) {
                    ++errorCount;
                    this.getLog().error((CharSequence)("\t" + error));
                }
            }
            if (errorCount != this.errors) {
                String message = "There are " + errorCount + " site errors";
                this.getLog().error((CharSequence)message);
                throw new NasdanikaException(message);
            }
        }
        catch (IOException | DiagnosticException ex) {
            throw new NasdanikaException(ex);
        }
    }
}

