/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.model.app.gen.maven;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.nasdanika.common.Context;
import org.nasdanika.common.DiagramGenerator;
import org.nasdanika.common.DiagramGeneratorImpl;
import org.nasdanika.common.NasdanikaException;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.common.Util;
import org.nasdanika.drawio.Document;
import org.nasdanika.html.emf.EObjectActionResolver;
import org.nasdanika.html.emf.RepresentationProcessor;
import org.nasdanika.html.model.app.Action;
import org.nasdanika.html.model.app.Link;
import org.nasdanika.html.model.app.gen.SemanticSiteGenerator;
import org.nasdanika.html.model.app.gen.SiteGeneratorContributor;
import org.nasdanika.maven.AbstractCommandMojo;
import org.nasdanika.ncore.util.SemanticInfo;
import org.nasdanika.ncore.util.SemanticRegistry;

public abstract class AbstractSemanticGeneratorMojo
extends AbstractCommandMojo {
    @Parameter
    private List<DiagramGenerator> diagramGenerators;
    @Parameter
    private String drawioViewer;
    @Parameter(required=true)
    protected String model;
    @Parameter(required=false)
    protected boolean parallel;
    @Parameter
    private List<SiteGeneratorContributor> contributors;
    @Parameter
    private List<String> semanticInfos;

    protected List<SiteGeneratorContributor> getContributors() {
        return this.contributors == null ? Collections.emptyList() : this.contributors;
    }

    protected SemanticSiteGenerator createSemanticSiteGenerator(final Context context, final ProgressMonitor progressMonitor) {
        File baseDir = this.project.getBasedir();
        URI baseDirURI = URI.createFileURI((String)baseDir.getAbsolutePath()).appendSegment("");
        final SemanticRegistry semanticRegistry = new SemanticRegistry();
        if (this.semanticInfos != null) {
            for (String smLocation : this.semanticInfos) {
                URI semanticInfoURI = URI.createURI((String)smLocation).resolve(baseDirURI);
                try {
                    semanticRegistry.load(new URL(semanticInfoURI.toString()));
                }
                catch (IOException e) {
                    String message = "Could not load semantic info from " + semanticInfoURI;
                    this.getLog().error((CharSequence)message, (Throwable)e);
                    throw new NasdanikaException(message, (Throwable)e);
                }
            }
        }
        return new SemanticSiteGenerator(){
            {
                this.parallel = AbstractSemanticGeneratorMojo.this.parallel;
            }

            protected Iterable<SemanticInfo> getSemanticInfos() {
                return semanticRegistry.stream().filter(SemanticInfo.class::isInstance).map(SemanticInfo.class::cast).toList();
            }

            protected boolean isSemanticInfoLink(Link link) {
                if (link == null || Util.isBlank((String)link.getLocation())) {
                    return false;
                }
                String linkLocation = link.getLocation();
                return semanticRegistry.stream().filter(SemanticInfo.class::isInstance).map(SemanticInfo.class::cast).map(SemanticInfo::getLocation).filter(Objects::nonNull).map(Object::toString).filter(linkLocation::equals).findFirst().isPresent();
            }

            protected Context createContext(ProgressMonitor progressMonitor2) {
                Object diagramGenerator = Util.isBlank((String)AbstractSemanticGeneratorMojo.this.drawioViewer) ? DiagramGenerator.INSTANCE : new DiagramGeneratorImpl(){

                    protected String getDrawioViewer() {
                        return AbstractSemanticGeneratorMojo.this.drawioViewer;
                    }
                };
                if (AbstractSemanticGeneratorMojo.this.diagramGenerators != null) {
                    for (DiagramGenerator dg : AbstractSemanticGeneratorMojo.this.diagramGenerators) {
                        diagramGenerator = dg.compose(diagramGenerator);
                    }
                }
                RepresentationProcessor representationProcessor = new RepresentationProcessor(){

                    public Document processDrawioRepresentation(Document document, Action action, Function<URI, EObject> semanticLinkResolver, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) {
                        for (SiteGeneratorContributor contributor : this.getContributors()) {
                            document = contributor.processDrawioRepresentation(document, action, semanticLinkResolver, context, progressMonitor);
                        }
                        return document;
                    }
                };
                return context.compose(Context.singleton(DiagramGenerator.class, (Object)diagramGenerator)).compose(Context.singleton(RepresentationProcessor.class, (Object)representationProcessor)).compose(super.createContext(progressMonitor2));
            }

            protected ProgressMonitor createProgressMonitor() {
                return progressMonitor;
            }

            protected Collection<SiteGeneratorContributor> getContributors() {
                ArrayList<SiteGeneratorContributor> allContributors = new ArrayList<SiteGeneratorContributor>(super.getContributors());
                allContributors.addAll(AbstractSemanticGeneratorMojo.this.getContributors());
                return allContributors;
            }
        };
    }
}

