/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.model.app.gen.maven;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.nasdanika.common.Context;
import org.nasdanika.common.DiagramGenerator;
import org.nasdanika.common.DiagramGeneratorImpl;
import org.nasdanika.common.NasdanikaException;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.common.Util;
import org.nasdanika.drawio.Document;
import org.nasdanika.html.emf.EObjectActionResolver;
import org.nasdanika.html.emf.RepresentationProcessor;
import org.nasdanika.html.model.app.Action;
import org.nasdanika.html.model.app.Link;
import org.nasdanika.html.model.app.gen.ActionSiteGenerator;
import org.nasdanika.html.model.app.gen.SiteGeneratorContributor;
import org.nasdanika.maven.AbstractCommandMojo;
import org.nasdanika.ncore.util.SemanticInfo;
import org.nasdanika.ncore.util.SemanticRegistry;

@Mojo(name="generate-action-site", defaultPhase=LifecyclePhase.SITE)
public class ActionSiteGeneratorMojo
extends AbstractCommandMojo {
    @Parameter(defaultValue="target/action-site")
    private File outputDirectory;
    @Parameter(defaultValue="target/action-site-work-dir")
    private File workDirectory;
    @Parameter
    private boolean cleanWorkDir;
    @Parameter(required=true)
    private String action;
    @Parameter(required=true)
    private String pageTemplate;
    @Parameter
    private String siteMapDomain;
    @Parameter
    private String drawioViewer;
    @Parameter(required=false)
    private int errors;
    @Parameter
    private List<DiagramGenerator> diagramGenerators;
    @Parameter
    private List<SiteGeneratorContributor> contributors;
    @Parameter
    private List<String> semanticInfos;
    @Parameter(required=false)
    protected boolean parallel;

    protected void execute(Context context, ProgressMonitor progressMonitor) {
        ActionSiteGenerator actionSiteGenerator = this.createActionSiteGenerator(context, progressMonitor);
        File baseDir = this.project.getBasedir();
        URI baseDirURI = URI.createFileURI((String)baseDir.getAbsolutePath()).appendSegment("");
        URI actionURI = URI.createURI((String)this.action).resolve(baseDirURI);
        URI pageTemplateURI = URI.createURI((String)this.pageTemplate).resolve(baseDirURI);
        try {
            Map errors = actionSiteGenerator.generate(actionURI, pageTemplateURI, this.siteMapDomain, this.outputDirectory, this.workDirectory, this.cleanWorkDir);
            int errorCount = 0;
            for (Map.Entry ee : errors.entrySet()) {
                this.getLog().error((CharSequence)ee.getKey());
                for (String error : (Collection)ee.getValue()) {
                    ++errorCount;
                    this.getLog().error((CharSequence)("\t" + error));
                }
            }
            if (errorCount != this.errors) {
                String message = "There are " + errorCount + " site errors";
                this.getLog().error((CharSequence)message);
                throw new NasdanikaException(message);
            }
        }
        catch (IOException | DiagnosticException ex) {
            throw new NasdanikaException(ex);
        }
    }

    protected ActionSiteGenerator createActionSiteGenerator(final Context context, final ProgressMonitor progressMonitor) {
        File baseDir = this.project.getBasedir();
        URI baseDirURI = URI.createFileURI((String)baseDir.getAbsolutePath()).appendSegment("");
        final SemanticRegistry semanticRegistry = new SemanticRegistry();
        if (this.semanticInfos != null) {
            for (String smLocation : this.semanticInfos) {
                URI semanticInfoURI = URI.createURI((String)smLocation).resolve(baseDirURI);
                try {
                    semanticRegistry.load(new URL(semanticInfoURI.toString()));
                }
                catch (IOException e) {
                    String message = "Could not load semantic info from " + semanticInfoURI;
                    this.getLog().error((CharSequence)message, (Throwable)e);
                    throw new NasdanikaException(message, (Throwable)e);
                }
            }
        }
        return new ActionSiteGenerator(){
            {
                this.parallel = ActionSiteGeneratorMojo.this.parallel;
            }

            protected Iterable<SemanticInfo> getSemanticInfos() {
                return semanticRegistry.stream().filter(SemanticInfo.class::isInstance).map(SemanticInfo.class::cast).toList();
            }

            protected boolean isSemanticInfoLink(Link link) {
                if (link == null || Util.isBlank((String)link.getLocation())) {
                    return false;
                }
                String linkLocation = link.getLocation();
                return semanticRegistry.stream().filter(SemanticInfo.class::isInstance).map(SemanticInfo.class::cast).map(SemanticInfo::getLocation).filter(Objects::nonNull).map(Object::toString).filter(linkLocation::equals).findFirst().isPresent();
            }

            protected Context createContext(ProgressMonitor progressMonitor2) {
                Object diagramGenerator = Util.isBlank((String)ActionSiteGeneratorMojo.this.drawioViewer) ? DiagramGenerator.INSTANCE : new DiagramGeneratorImpl(){

                    protected String getDrawioViewer() {
                        return ActionSiteGeneratorMojo.this.drawioViewer;
                    }
                };
                if (ActionSiteGeneratorMojo.this.diagramGenerators != null) {
                    for (DiagramGenerator dg : ActionSiteGeneratorMojo.this.diagramGenerators) {
                        diagramGenerator = dg.compose(diagramGenerator);
                    }
                }
                RepresentationProcessor representationProcessor = new RepresentationProcessor(){

                    public Document processDrawioRepresentation(Document document, Action action, Function<URI, EObject> semanticLinkResolver, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) {
                        for (SiteGeneratorContributor contributor : this.getContributors()) {
                            document = contributor.processDrawioRepresentation(document, action, semanticLinkResolver, context, progressMonitor);
                        }
                        return document;
                    }
                };
                return context.compose(Context.singleton(DiagramGenerator.class, (Object)diagramGenerator)).compose(Context.singleton(RepresentationProcessor.class, (Object)representationProcessor)).compose(super.createContext(progressMonitor2));
            }

            protected ProgressMonitor createProgressMonitor() {
                return progressMonitor;
            }

            protected Collection<SiteGeneratorContributor> getContributors() {
                ArrayList<SiteGeneratorContributor> allContributors = new ArrayList<SiteGeneratorContributor>(super.getContributors());
                if (ActionSiteGeneratorMojo.this.contributors != null) {
                    allContributors.addAll(ActionSiteGeneratorMojo.this.contributors);
                }
                return allContributors;
            }
        };
    }
}

