/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.model.app.gen.maven;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.nasdanika.common.Context;
import org.nasdanika.common.DiagramGenerator;
import org.nasdanika.common.DiagramGeneratorImpl;
import org.nasdanika.common.NasdanikaException;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.common.Util;
import org.nasdanika.html.model.app.Action;
import org.nasdanika.html.model.app.Label;
import org.nasdanika.html.model.app.Link;
import org.nasdanika.html.model.app.gen.ActionSiteGenerator;
import org.nasdanika.html.model.app.gen.SemanticMapResourceFactory;
import org.nasdanika.maven.AbstractCommandMojo;
import org.nasdanika.ncore.ModelElement;

@Mojo(name="generate-action-site", defaultPhase=LifecyclePhase.SITE)
public class ActionSiteGeneratorMojo
extends AbstractCommandMojo {
    @Parameter(defaultValue="target/action-site")
    private File outputDirectory;
    @Parameter(defaultValue="target/action-site-work-dir")
    private File workDirectory;
    @Parameter
    private boolean cleanWorkDir;
    @Parameter(required=true)
    private String action;
    @Parameter(required=true)
    private String pageTemplate;
    @Parameter
    private String siteMapDomain;
    @Parameter
    private String drawioViewer;
    @Parameter(required=false)
    private int errors;
    @Parameter
    private List<DiagramGenerator> diagramGenerators;
    @Parameter
    private List<String> semanticMaps;

    protected void execute(final Context context, final ProgressMonitor progressMonitor) {
        ActionSiteGenerator actionSiteGenerator = new ActionSiteGenerator(){
            Map<ModelElement, Label> semanticMap = new LinkedHashMap<ModelElement, Label>();

            protected ResourceSet createResourceSet(Context context2, ProgressMonitor progressMonitor2) {
                ResourceSet resourceSet = super.createResourceSet(context2, progressMonitor2);
                if (ActionSiteGeneratorMojo.this.semanticMaps != null && !ActionSiteGeneratorMojo.this.semanticMaps.isEmpty()) {
                    SemanticMapResourceFactory smrf = new SemanticMapResourceFactory(){

                        protected void onLoad(Map<ModelElement, Label> resourceSemanticMap, Resource resource) {
                            super.onLoad(resourceSemanticMap, resource);
                            semanticMap.putAll(resourceSemanticMap);
                        }
                    };
                    resourceSet.getResourceFactoryRegistry().getProtocolToFactoryMap().put("semantic-map", smrf);
                    File baseDir = ActionSiteGeneratorMojo.this.project.getBasedir();
                    URI baseDirURI = URI.createFileURI((String)baseDir.getAbsolutePath()).appendSegment("");
                    for (String smLocation : ActionSiteGeneratorMojo.this.semanticMaps) {
                        URI semanticMapURI = URI.createURI((String)smLocation).resolve(baseDirURI);
                        try {
                            URI sMapURI = URI.createURI((String)("semantic-map:" + URLEncoder.encode(semanticMapURI.toString(), StandardCharsets.UTF_8.name())));
                            resourceSet.getResource(sMapURI, true);
                        }
                        catch (UnsupportedEncodingException e) {
                            ActionSiteGeneratorMojo.this.getLog().error((CharSequence)("Error loading semantic map " + smLocation), (Throwable)e);
                            throw new NasdanikaException((Throwable)e);
                        }
                    }
                }
                return resourceSet;
            }

            protected void buildRegistry(Action action, Map<EObject, Label> registry) {
                registry.putAll(this.semanticMap);
                super.buildRegistry(action, registry);
            }

            protected boolean isSemanticMapLink(Link link) {
                return this.semanticMap.values().contains(link);
            }

            protected Context createContext(ProgressMonitor progressMonitor2) {
                Object diagramGenerator = Util.isBlank((String)ActionSiteGeneratorMojo.this.drawioViewer) ? DiagramGenerator.INSTANCE : new DiagramGeneratorImpl(){

                    protected String getDrawioViewer() {
                        return ActionSiteGeneratorMojo.this.drawioViewer;
                    }
                };
                if (ActionSiteGeneratorMojo.this.diagramGenerators != null) {
                    for (DiagramGenerator dg : ActionSiteGeneratorMojo.this.diagramGenerators) {
                        diagramGenerator = dg.compose(diagramGenerator);
                    }
                }
                return context.compose(Context.singleton(DiagramGenerator.class, (Object)diagramGenerator)).compose(super.createContext(progressMonitor2));
            }

            protected ProgressMonitor createProgressMonitor() {
                return progressMonitor;
            }
        };
        File baseDir = this.project.getBasedir();
        URI baseDirURI = URI.createFileURI((String)baseDir.getAbsolutePath()).appendSegment("");
        URI actionURI = URI.createURI((String)this.action).resolve(baseDirURI);
        URI pageTemplateURI = URI.createURI((String)this.pageTemplate).resolve(baseDirURI);
        try {
            Map errors = actionSiteGenerator.generate(actionURI, pageTemplateURI, this.siteMapDomain, this.outputDirectory, this.workDirectory, this.cleanWorkDir);
            int errorCount = 0;
            for (Map.Entry ee : errors.entrySet()) {
                this.getLog().error((CharSequence)ee.getKey());
                for (String error : (Collection)ee.getValue()) {
                    ++errorCount;
                    this.getLog().error((CharSequence)("\t" + error));
                }
            }
            if (errorCount != this.errors) {
                String message = "There are " + errorCount + " site errors";
                this.getLog().error((CharSequence)message);
                throw new NasdanikaException(message);
            }
        }
        catch (IOException | DiagnosticException ex) {
            throw new NasdanikaException(ex);
        }
    }
}

