/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.model.app.gen.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.URI;
import org.nasdanika.common.Context;
import org.nasdanika.common.DiagramGenerator;
import org.nasdanika.common.DiagramGeneratorImpl;
import org.nasdanika.common.NasdanikaException;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.common.Status;
import org.nasdanika.common.Util;
import org.nasdanika.html.model.app.gen.ActionSiteGenerator;
import org.nasdanika.html.model.app.gen.maven.LogProgressMonitor;

@Mojo(name="generate-action-site", defaultPhase=LifecyclePhase.SITE)
public class ActionSiteGeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="target/action-site")
    private File outputDirectory;
    @Parameter(defaultValue="target/action-site-work-dir")
    private File workDirectory;
    @Parameter
    private boolean cleanWorkDir;
    @Parameter(required=true)
    private String action;
    @Parameter(required=true)
    private String pageTemplate;
    @Parameter
    private String siteMapDomain;
    @Parameter
    private String drawioViewer;
    @Parameter(required=false)
    private int errors;
    @Parameter
    private File progressOutput;
    @Parameter
    private List<DiagramGenerator> diagramGenerators;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;

    public void execute() throws MojoExecutionException {
        ActionSiteGenerator actionSiteGenerator = new ActionSiteGenerator(){

            protected Context createContext(ProgressMonitor progressMonitor) {
                Object diagramGenerator = Util.isBlank((String)ActionSiteGeneratorMojo.this.drawioViewer) ? DiagramGenerator.INSTANCE : new DiagramGeneratorImpl(){

                    protected String getDrawioViewer() {
                        return ActionSiteGeneratorMojo.this.drawioViewer;
                    }
                };
                if (ActionSiteGeneratorMojo.this.diagramGenerators != null) {
                    for (DiagramGenerator dg : ActionSiteGeneratorMojo.this.diagramGenerators) {
                        diagramGenerator = dg.compose(diagramGenerator);
                    }
                }
                return Context.singleton(DiagramGenerator.class, (Object)diagramGenerator).compose(super.createContext(progressMonitor));
            }

            protected ProgressMonitor createProgressMonitor() {
                if (ActionSiteGeneratorMojo.this.progressOutput == null) {
                    return new LogProgressMonitor(ActionSiteGeneratorMojo.this.getLog(), 0, 2);
                }
                try {
                    return new PrintStreamProgressMonitor(new PrintStream(ActionSiteGeneratorMojo.this.progressOutput), 0, 2, true);
                }
                catch (FileNotFoundException e) {
                    throw new NasdanikaException((Throwable)e);
                }
            }
        };
        File baseDir = this.project.getBasedir();
        URI baseDirURI = URI.createFileURI((String)baseDir.getAbsolutePath()).appendSegment("");
        URI actionURI = URI.createURI((String)this.action).resolve(baseDirURI);
        URI pageTemplateURI = URI.createURI((String)this.pageTemplate).resolve(baseDirURI);
        try {
            Map errors = actionSiteGenerator.generate(actionURI, pageTemplateURI, this.siteMapDomain, this.outputDirectory, this.workDirectory, this.cleanWorkDir);
            int errorCount = 0;
            for (Map.Entry ee : errors.entrySet()) {
                this.getLog().error((CharSequence)ee.getKey());
                for (String error : (Collection)ee.getValue()) {
                    ++errorCount;
                    this.getLog().error((CharSequence)("\t" + error));
                }
            }
            if (errorCount != this.errors) {
                throw new MojoExecutionException("There are " + errorCount + " site errors");
            }
        }
        catch (IOException | DiagnosticException ex) {
            throw new MojoExecutionException(ex);
        }
    }

    public class PrintStreamProgressMonitor
    implements ProgressMonitor {
        private PrintStream out;
        private boolean closeStream;
        private String indent;
        protected int indentIncrement = 2;
        private boolean cancelled;

        public PrintStreamProgressMonitor(PrintStream out, int indent, int indentIncrement, boolean closeStream) {
            this.out = out;
            StringBuilder indentBuilder = new StringBuilder();
            for (int i = 0; i < indent; ++i) {
                indentBuilder.append(' ');
            }
            this.indent = indentBuilder.toString();
            this.closeStream = closeStream;
        }

        public PrintStreamProgressMonitor() {
            this(System.out, 0, 2, false);
        }

        public void close() {
            if (this.closeStream) {
                this.out.close();
            }
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public ProgressMonitor split(String taskName, double size, Object ... data) {
            if (this.isCancelled()) {
                throw new CancellationException();
            }
            this.out.println(this.indent + "  " + taskName + " (" + size + ")");
            if (data != null) {
                for (Object d : data) {
                    this.out.println(this.formatDetail(d, this.indent + "    "));
                }
            }
            return new PrintStreamProgressMonitor(this.out, this.indent.length() + this.indentIncrement, this.indentIncrement, false){

                @Override
                public boolean isCancelled() {
                    return PrintStreamProgressMonitor.this.isCancelled();
                }
            };
        }

        protected String formatDetail(Object detail, String indent) {
            return indent + detail;
        }

        public void worked(Status status, double work, String progressMessage, Object ... data) {
            this.out.print(this.indent + "  [" + status + " " + work + "] " + progressMessage);
            if (data.length > 0) {
                this.out.print(": " + Arrays.deepToString(data));
            }
            this.out.println();
            if (status == Status.CANCEL) {
                this.cancelled = true;
            }
        }

        public ProgressMonitor setWorkRemaining(double size) {
            return this;
        }
    }
}

