/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.model.app.gen.maven;

import java.util.Arrays;
import java.util.concurrent.CancellationException;
import org.apache.maven.plugin.logging.Log;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.common.Status;

public class LogProgressMonitor
implements ProgressMonitor {
    private Log log;
    private String indent;
    protected int indentIncrement = 2;
    private boolean cancelled;

    public LogProgressMonitor(Log log, int indent, int indentIncrement) {
        this.log = log;
        StringBuilder indentBuilder = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            indentBuilder.append(' ');
        }
        this.indent = indentBuilder.toString();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public ProgressMonitor split(String taskName, double size, Object ... data) {
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        this.log.info((CharSequence)(this.indent + "  " + taskName + " (" + size + ")"));
        if (data != null) {
            for (Object d : data) {
                this.log.info((CharSequence)this.formatDetail(d, this.indent + "    "));
            }
        }
        return new LogProgressMonitor(this.log, this.indent.length() + this.indentIncrement, this.indentIncrement){

            @Override
            public boolean isCancelled() {
                return LogProgressMonitor.this.isCancelled();
            }
        };
    }

    protected String formatDetail(Object detail, String indent) {
        return indent + detail;
    }

    public void worked(Status status, double work, String progressMessage, Object ... data) {
        switch (status) {
            case ERROR: 
            case FAIL: {
                this.log.error((CharSequence)(this.indent + "  [" + status + " " + work + "] " + progressMessage));
                if (data.length <= 0) break;
                this.log.error((CharSequence)(": " + Arrays.deepToString(data)));
                break;
            }
            case WARNING: {
                this.log.warn((CharSequence)(this.indent + "  [" + status + " " + work + "] " + progressMessage));
                if (data.length <= 0) break;
                this.log.warn((CharSequence)(": " + Arrays.deepToString(data)));
                break;
            }
            default: {
                this.log.info((CharSequence)(this.indent + "  [" + status + " " + work + "] " + progressMessage));
                if (data.length > 0) {
                    this.log.info((CharSequence)(": " + Arrays.deepToString(data)));
                }
                if (status != Status.CANCEL) break;
                this.cancelled = true;
            }
        }
    }

    public ProgressMonitor setWorkRemaining(double size) {
        return this;
    }

    public void close() {
    }
}

