/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.model.html.util;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.nasdanika.html.model.html.HtmlElement;
import org.nasdanika.html.model.html.HtmlPackage;
import org.nasdanika.html.model.html.Page;
import org.nasdanika.html.model.html.Script;
import org.nasdanika.html.model.html.ScriptReference;
import org.nasdanika.html.model.html.Stylesheet;
import org.nasdanika.html.model.html.StylesheetReference;
import org.nasdanika.html.model.html.Tag;

public class HtmlValidator
extends EObjectValidator {
    public static final HtmlValidator INSTANCE = new HtmlValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.nasdanika.html.model.html";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;

    protected EPackage getEPackage() {
        return HtmlPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateHtmlElement((HtmlElement)value, diagnostics, context);
            }
            case 1: {
                return this.validateTag((Tag)value, diagnostics, context);
            }
            case 2: {
                return this.validatePage((Page)value, diagnostics, context);
            }
            case 3: {
                return this.validateStylesheet((Stylesheet)value, diagnostics, context);
            }
            case 4: {
                return this.validateStylesheetReference((StylesheetReference)value, diagnostics, context);
            }
            case 5: {
                return this.validateScript((Script)value, diagnostics, context);
            }
            case 6: {
                return this.validateScriptReference((ScriptReference)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateHtmlElement(HtmlElement htmlElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)htmlElement, diagnostics, context);
    }

    public boolean validateTag(Tag tag, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)tag, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)tag, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)tag, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)tag, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)tag, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)tag, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)tag, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)tag, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)tag, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTag_attributes(tag, diagnostics, context);
        }
        return result;
    }

    public boolean validateTag_attributes(Tag tag, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validatePage(Page page, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)page, diagnostics, context);
    }

    public boolean validateStylesheet(Stylesheet stylesheet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)stylesheet, diagnostics, context);
    }

    public boolean validateStylesheetReference(StylesheetReference stylesheetReference, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)stylesheetReference, diagnostics, context);
    }

    public boolean validateScript(Script script, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)script, diagnostics, context);
    }

    public boolean validateScriptReference(ScriptReference scriptReference, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)scriptReference, diagnostics, context);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

