/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.model.html.gen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.nasdanika.common.BiSupplier;
import org.nasdanika.common.CollectionCompoundConsumerFactory;
import org.nasdanika.common.Context;
import org.nasdanika.common.Function;
import org.nasdanika.common.ListCompoundSupplierFactory;
import org.nasdanika.common.MutableContext;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.common.Supplier;
import org.nasdanika.common.SupplierFactory;
import org.nasdanika.emf.EObjectAdaptable;
import org.nasdanika.html.HTMLFactory;
import org.nasdanika.html.HTMLPage;
import org.nasdanika.html.model.html.Page;

public class PageSupplierFactoryAdapter
extends AdapterImpl
implements SupplierFactory<HTMLPage> {
    public static final String PAGE_BODY_PROPERTY = "page/body";
    public static final String PAGE_HEAD_PROPERTY = "page/head";

    public PageSupplierFactoryAdapter(Page page) {
        this.setTarget((Notifier)page);
    }

    public boolean isAdapterForType(Object type) {
        return type == SupplierFactory.class;
    }

    protected Function<BiSupplier<List<Object>, List<Object>>, HTMLPage> createPageFunction(final Context context) {
        return new Function<BiSupplier<List<Object>, List<Object>>, HTMLPage>(){

            public double size() {
                return 1.0;
            }

            public String name() {
                return "HTML Page";
            }

            public HTMLPage execute(BiSupplier<List<Object>, List<Object>> headAndBody, ProgressMonitor progressMonitor) throws Exception {
                HTMLFactory htmlFactory = (HTMLFactory)context.get(HTMLFactory.class, (Object)HTMLFactory.INSTANCE);
                Page semanticElement = (Page)PageSupplierFactoryAdapter.this.getTarget();
                String pageName = context.interpolateToString(semanticElement.getName());
                HTMLPage ret = htmlFactory.page();
                ret.title((Object)pageName);
                ret.lang((Object)semanticElement.getLanguage());
                for (String styleseet : semanticElement.getStylesheets()) {
                    ret.stylesheet((Object)styleseet);
                }
                for (String script : semanticElement.getScripts()) {
                    ret.script((Object)script);
                }
                for (Object he : (List)headAndBody.getFirst()) {
                    ret.head(new Object[]{he});
                }
                for (Object he : (List)context.get(PageSupplierFactoryAdapter.PAGE_HEAD_PROPERTY, List.class)) {
                    ret.head(new Object[]{he});
                }
                for (Object be : (List)context.get(PageSupplierFactoryAdapter.PAGE_BODY_PROPERTY, List.class)) {
                    ret.body(new Object[]{be});
                }
                for (Object be : (List)headAndBody.getSecond()) {
                    ret.body(new Object[]{be});
                }
                return ret;
            }
        };
    }

    public Supplier<HTMLPage> create(Context context) throws Exception {
        Page page = (Page)this.getTarget();
        MutableContext mc = context.fork();
        mc.put(PAGE_HEAD_PROPERTY, new ArrayList());
        mc.put(PAGE_BODY_PROPERTY, new ArrayList());
        ListCompoundSupplierFactory headFactory = new ListCompoundSupplierFactory("Head", (Collection)EObjectAdaptable.adaptToSupplierFactoryNonNull((Collection)page.getHead(), Object.class));
        ListCompoundSupplierFactory bodyFactory = new ListCompoundSupplierFactory("Body", (Collection)EObjectAdaptable.adaptToSupplierFactoryNonNull((Collection)page.getBody(), Object.class));
        CollectionCompoundConsumerFactory buildFactory = new CollectionCompoundConsumerFactory("Builders", (Collection)EObjectAdaptable.adaptToConsumerFactoryNonNull((Collection)page.getBuilders(), HTMLPage.class));
        return (Supplier)headFactory.then(bodyFactory.asFunctionFactory()).then(this::createPageFunction).then(buildFactory.asFunctionFactory()).create((Object)mc);
    }
}

