/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.flow;

import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.nasdanika.common.Consumer;
import org.nasdanika.common.Context;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.flow.Activity;
import org.nasdanika.flow.FlowPackage;
import org.nasdanika.flow.ServiceProvider;
import org.nasdanika.html.emf.EObjectActionResolver;
import org.nasdanika.html.flow.PackageElementActionBuilder;
import org.nasdanika.html.model.app.Action;
import org.nasdanika.html.model.app.AppFactory;
import org.nasdanika.ncore.util.NamedElementComparator;

public class ServiceProviderActionBuilder<T extends ServiceProvider<?>>
extends PackageElementActionBuilder<T> {
    public ServiceProviderActionBuilder(T value, Context context) {
        super(value, context);
    }

    @Override
    protected Action buildAction(Action action, BiConsumer<EObject, Action> registry, java.util.function.Consumer<Consumer<EObjectActionResolver.Context>> resolveConsumer, ProgressMonitor progressMonitor) throws Exception {
        action = super.buildAction(action, registry, resolveConsumer, progressMonitor);
        List services = ((ServiceProvider)this.getTarget()).getServices().values().stream().sorted(NamedElementComparator.INSTANCE).collect(Collectors.toList());
        if (!services.isEmpty()) {
            Action group = AppFactory.eINSTANCE.createAction();
            group.setText("Services");
            group.setTooltip("Shared activities or journeys which can be used on their own or be referenced from other journeys.");
            group.setUuid(action.getUuid() + "-services");
            EList anonymous = action.getAnonymous();
            for (Activity service : ((ServiceProvider)this.getTarget()).getServices().values().stream().sorted(NamedElementComparator.INSTANCE).collect(Collectors.toList())) {
                anonymous.add((Object)this.createChildAction((EObject)service, registry, resolveConsumer, progressMonitor));
            }
            action.getSections().add((Object)group);
        }
        return action;
    }

    @Override
    protected void resolve(Action action, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
        super.resolve(action, context, progressMonitor);
        List services = ((ServiceProvider)this.getTarget()).getServices().values().stream().sorted(NamedElementComparator.INSTANCE).collect(Collectors.toList());
        if (!services.isEmpty()) {
            String servicesGroupUUID = action.getUuid() + "-services";
            Optional<Action> servicesActionOptional = action.getSections().stream().filter(a -> servicesGroupUUID.equals(a.getUuid())).findFirst();
            Action servicesAction = servicesActionOptional.get();
            servicesAction.getContent().add((Object)this.renderList(services, false, null, action, (ETypedElement)FlowPackage.Literals.SERVICE_PROVIDER__SERVICES, context, progressMonitor));
        }
    }
}

