/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.flow;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.nasdanika.common.Context;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.common.Util;
import org.nasdanika.diagram.Diagram;
import org.nasdanika.flow.Call;
import org.nasdanika.flow.Flow;
import org.nasdanika.flow.FlowElement;
import org.nasdanika.flow.FlowPackage;
import org.nasdanika.flow.PseudoState;
import org.nasdanika.flow.Transition;
import org.nasdanika.flow.util.FlowStateDiagramGenerator;
import org.nasdanika.html.emf.EObjectActionResolver;
import org.nasdanika.html.flow.ActivityActionBuilder;
import org.nasdanika.html.model.app.Action;
import org.nasdanika.html.model.app.AppFactory;
import org.nasdanika.html.model.app.Label;
import org.nasdanika.html.model.app.NavigationPanel;
import org.nasdanika.html.model.app.NavigationPanelStyle;
import org.nasdanika.ncore.Marker;
import org.nasdanika.ncore.util.NamedElementComparator;

public class FlowActionBuilder
extends ActivityActionBuilder<Flow> {
    public FlowActionBuilder(Flow value, Context context) {
        super(value, context);
    }

    @Override
    protected Action buildAction(Action action, BiConsumer<EObject, Action> registry, Consumer<org.nasdanika.common.Consumer<EObjectActionResolver.Context>> resolveConsumer, ProgressMonitor progressMonitor) throws Exception {
        action = super.buildAction(action, registry, resolveConsumer, progressMonitor);
        EList children = action.getChildren();
        Predicate<FlowElement> isPseudoState = PseudoState.class::isInstance;
        for (FlowElement element : ((Flow)this.getTarget()).getElements().values().stream().filter(isPseudoState.negate()).sorted(FlowActionBuilder::compareFlowElements).collect(Collectors.toList())) {
            children.add((Object)this.createChildAction((EObject)element, registry, resolveConsumer, progressMonitor));
        }
        EList anonymous = action.getAnonymous();
        for (FlowElement element : ((Flow)this.getTarget()).getElements().values().stream().filter(isPseudoState).collect(Collectors.toList())) {
            anonymous.add((Object)this.createChildAction((EObject)element, registry, resolveConsumer, progressMonitor));
        }
        return action;
    }

    public static int compareFlowElements(FlowElement<?> a, FlowElement<?> b) {
        if (a == b) {
            return 0;
        }
        String asg = a.getSortGroup();
        String bsg = b.getSortGroup();
        if (Util.isBlank((String)asg)) {
            if (!Util.isBlank((String)bsg)) {
                return -1;
            }
        } else {
            if (Util.isBlank((String)bsg)) {
                return 1;
            }
            int cmp = asg.compareTo(bsg);
            if (cmp != 0) {
                return cmp;
            }
        }
        int abDistance = FlowActionBuilder.distance(a, b, new HashSet());
        int baDistance = FlowActionBuilder.distance(b, a, new HashSet());
        if (abDistance != -1 && baDistance == -1) {
            return -1;
        }
        if (baDistance != -1 && abDistance == -1) {
            return 1;
        }
        if (abDistance != -1 && baDistance != -1) {
            return abDistance - baDistance;
        }
        Map<FlowElement<?>, Integer> aSources = FlowActionBuilder.sources(a, new HashSet());
        int da = 0;
        int db = 0;
        FlowElement<?> cs = null;
        for (Map.Entry<FlowElement<?>, Integer> bse : FlowActionBuilder.sources(b, new HashSet()).entrySet()) {
            for (Map.Entry<FlowElement<?>, Integer> ase : aSources.entrySet()) {
                if (ase.getKey() != bse.getKey()) continue;
                int sd = ase.getValue() + bse.getValue();
                if (cs != null && sd >= da + db) continue;
                da = ase.getValue();
                db = bse.getValue();
                cs = ase.getKey();
            }
        }
        if (cs != null && da != db) {
            return da - db;
        }
        for (Marker am : a.getMarkers()) {
            for (Marker bm : b.getMarkers()) {
                if (am == null || bm == null || Util.isBlank((String)am.getLocation()) || !am.getLocation().equals(bm.getLocation())) continue;
                int lineDiff = am.getLine() - bm.getLine();
                if (lineDiff != 0) {
                    return lineDiff;
                }
                int colDiff = am.getColumn() - bm.getColumn();
                if (colDiff == 0) continue;
                return colDiff;
            }
        }
        return NamedElementComparator.INSTANCE.compare(a, b);
    }

    private static Map<FlowElement<?>, Integer> sources(FlowElement<?> target, Set<FlowElement<?>> traversed) {
        HashMap ret = new HashMap();
        if (traversed.add(target)) {
            Integer existingDistance;
            FlowElement source;
            for (Transition input : target.getInputs()) {
                source = (FlowElement)input.eContainer().eContainer();
                ret.put(source, 1);
                for (Map.Entry<FlowElement<?>, Integer> se : FlowActionBuilder.sources(source, traversed).entrySet()) {
                    existingDistance = (Integer)ret.get(se.getKey());
                    if (existingDistance == null) {
                        ret.put(se.getKey(), se.getValue() + 1);
                        continue;
                    }
                    if (se.getValue() >= existingDistance) continue;
                    ret.put(se.getKey(), se.getValue());
                }
            }
            for (Call invocation : target.getInvocations()) {
                source = (FlowElement)invocation.eContainer().eContainer();
                ret.put(source, 1);
                for (Map.Entry<FlowElement<?>, Integer> se : FlowActionBuilder.sources(source, traversed).entrySet()) {
                    existingDistance = (Integer)ret.get(se.getKey());
                    if (existingDistance == null) {
                        ret.put(se.getKey(), se.getValue() + 1);
                        continue;
                    }
                    if (se.getValue() >= existingDistance) continue;
                    ret.put(se.getKey(), se.getValue());
                }
            }
        }
        return ret;
    }

    private static int distance(FlowElement<?> source, FlowElement<?> target, Set<FlowElement<?>> traversed) {
        if (source == target) {
            return 0;
        }
        int distance = -1;
        if (traversed.add(source)) {
            int targetDistance;
            for (Transition output : source.getOutputs().values()) {
                targetDistance = FlowActionBuilder.distance(output.getTarget(), target, traversed);
                if (targetDistance == -1) continue;
                if (distance == -1) {
                    distance = targetDistance + 1;
                    continue;
                }
                distance = Math.min(distance, targetDistance + 1);
            }
            for (Call call : source.getCalls().values()) {
                targetDistance = FlowActionBuilder.distance(call.getTarget(), target, traversed);
                if (targetDistance == -1) continue;
                if (distance == -1) {
                    distance = targetDistance + 1;
                    continue;
                }
                distance = Math.min(distance, targetDistance + 1);
            }
        }
        return distance;
    }

    @Override
    protected void populateRepresentation(Diagram representation, FlowStateDiagramGenerator flowStateDiagramGenerator) {
        if (((Flow)this.getTarget()).isPartition()) {
            super.populateRepresentation(representation, flowStateDiagramGenerator);
        } else {
            flowStateDiagramGenerator.generateDiagram((Flow)this.getTarget(), representation, null);
        }
    }

    @Override
    protected void resolve(Action action, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
        super.resolve(action, context, progressMonitor);
        if (((Flow)this.getTarget()).eContainmentFeature() == FlowPackage.Literals.ACTIVITY_ENTRY__VALUE && ((Flow)this.getTarget()).eContainer().eContainmentFeature() == FlowPackage.Literals.SERVICE_PROVIDER__SERVICES) {
            NavigationPanel leftNavigation = action.getLeftNavigation();
            if (leftNavigation == null) {
                leftNavigation = AppFactory.eINSTANCE.createNavigationPanel();
                action.setLeftNavigation(leftNavigation);
                int subChildren = ((Flow)this.getTarget()).getElements().values().stream().filter(Flow.class::isInstance).map(Flow.class::cast).map(Flow::getElements).mapToInt(Collection::size).sum();
                leftNavigation.setStyle(subChildren == 0 ? NavigationPanelStyle.AUTO : (FlowActionBuilder.flowElements((Flow)this.getTarget()) > 25 ? NavigationPanelStyle.SEARCHABLE_TREE : NavigationPanelStyle.TREE));
            }
            Predicate<FlowElement> isPseudoState = PseudoState.class::isInstance;
            for (FlowElement element : ((Flow)this.getTarget()).getElements().values().stream().filter(isPseudoState.negate()).sorted(FlowActionBuilder::compareFlowElements).collect(Collectors.toList())) {
                leftNavigation.getItems().add((Object)this.createItem(action, context, progressMonitor, element));
            }
        }
    }

    private static int flowElements(Flow flow) {
        return flow.getElements().stream().mapToInt(e -> e instanceof Flow ? FlowActionBuilder.flowElements((Flow)e) + 1 : 1).sum();
    }

    private EObject createItem(Action action, EObjectActionResolver.Context context, ProgressMonitor progressMonitor, FlowElement<?> element) throws Exception {
        EObject item = this.renderValue(action, (ETypedElement)FlowPackage.Literals.FLOW__ELEMENTS, element, context, progressMonitor);
        if (element instanceof Flow && item instanceof Label) {
            Predicate<FlowElement> isPseudoState = PseudoState.class::isInstance;
            for (FlowElement child : ((Flow)element).getElements().values().stream().filter(isPseudoState.negate()).sorted(FlowActionBuilder::compareFlowElements).collect(Collectors.toList())) {
                ((Label)item).getChildren().add((Object)this.createItem(action, context, progressMonitor, child));
            }
        }
        return item;
    }
}

