/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.flow;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.nasdanika.common.Context;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.flow.Activity;
import org.nasdanika.flow.Artifact;
import org.nasdanika.flow.Package;
import org.nasdanika.flow.Participant;
import org.nasdanika.flow.Resource;
import org.nasdanika.html.emf.EObjectActionResolver;
import org.nasdanika.html.flow.PackageElementActionProvider;
import org.nasdanika.html.model.app.Action;
import org.nasdanika.html.model.app.AppFactory;
import org.nasdanika.ncore.util.NamedElementComparator;

public class PackageActionProvider
extends PackageElementActionProvider<Package> {
    public PackageActionProvider(Package value, Context context) {
        super(value, context);
    }

    @Override
    protected Action createAction(BiConsumer<EObject, Action> registry, Consumer<org.nasdanika.common.Consumer<EObjectActionResolver.Context>> resolveConsumer, ProgressMonitor progressMonitor) throws Exception {
        Action action = super.createAction(registry, resolveConsumer, progressMonitor);
        EList children = action.getChildren();
        children.addAll(this.createSubPackageActions(registry, resolveConsumer, progressMonitor));
        children.addAll(this.createActivityActions(registry, resolveConsumer, progressMonitor));
        children.addAll(this.createParticipantActions(registry, resolveConsumer, progressMonitor));
        children.addAll(this.createResourceActions(registry, resolveConsumer, progressMonitor));
        children.addAll(this.createArtifactActions(registry, resolveConsumer, progressMonitor));
        return action;
    }

    protected List<Action> createSubPackageActions(BiConsumer<EObject, Action> registry, Consumer<org.nasdanika.common.Consumer<EObjectActionResolver.Context>> resolveConsumer, ProgressMonitor progressMonitor) throws Exception {
        List subPackages = ((Package)this.getTarget()).getSubPackages().values().stream().sorted(NamedElementComparator.INSTANCE).collect(Collectors.toList());
        if (subPackages.isEmpty()) {
            return Collections.emptyList();
        }
        Action group = AppFactory.eINSTANCE.createAction();
        group.setText("Sub-packages");
        EList children = group.getChildren();
        for (Package sp : subPackages) {
            children.add((Object)this.createChildAction((EObject)sp, registry, resolveConsumer, progressMonitor));
        }
        return Collections.singletonList(group);
    }

    protected List<Action> createActivityActions(BiConsumer<EObject, Action> registry, Consumer<org.nasdanika.common.Consumer<EObjectActionResolver.Context>> resolveConsumer, ProgressMonitor progressMonitor) throws Exception {
        Collection activities = ((Package)this.getTarget()).getActivities().values().stream().sorted(NamedElementComparator.INSTANCE).collect(Collectors.toList());
        if (activities.isEmpty()) {
            return Collections.emptyList();
        }
        Action group = AppFactory.eINSTANCE.createAction();
        group.setText("Activities");
        EList children = group.getChildren();
        for (Activity activity : activities) {
            children.add((Object)this.createChildAction((EObject)activity, registry, resolveConsumer, progressMonitor));
        }
        return Collections.singletonList(group);
    }

    protected List<Action> createParticipantActions(BiConsumer<EObject, Action> registry, Consumer<org.nasdanika.common.Consumer<EObjectActionResolver.Context>> resolveConsumer, ProgressMonitor progressMonitor) throws Exception {
        Collection participants = ((Package)this.getTarget()).getParticipants().values().stream().sorted(NamedElementComparator.INSTANCE).collect(Collectors.toList());
        if (participants.isEmpty()) {
            return Collections.emptyList();
        }
        Action group = AppFactory.eINSTANCE.createAction();
        group.setText("Participants");
        EList children = group.getChildren();
        for (Participant participant : participants) {
            children.add((Object)this.createChildAction((EObject)participant, registry, resolveConsumer, progressMonitor));
        }
        return Collections.singletonList(group);
    }

    protected List<Action> createResourceActions(BiConsumer<EObject, Action> registry, Consumer<org.nasdanika.common.Consumer<EObjectActionResolver.Context>> resolveConsumer, ProgressMonitor progressMonitor) throws Exception {
        Collection resources = ((Package)this.getTarget()).getResources().values().stream().sorted(NamedElementComparator.INSTANCE).collect(Collectors.toList());
        if (resources.isEmpty()) {
            return Collections.emptyList();
        }
        Action group = AppFactory.eINSTANCE.createAction();
        group.setText("Resources");
        EList children = group.getChildren();
        for (Resource resource : resources) {
            children.add((Object)this.createChildAction((EObject)resource, registry, resolveConsumer, progressMonitor));
        }
        return Collections.singletonList(group);
    }

    protected List<Action> createArtifactActions(BiConsumer<EObject, Action> registry, Consumer<org.nasdanika.common.Consumer<EObjectActionResolver.Context>> resolveConsumer, ProgressMonitor progressMonitor) throws Exception {
        Collection artifacts = ((Package)this.getTarget()).getArtifacts().values().stream().sorted(NamedElementComparator.INSTANCE).collect(Collectors.toList());
        if (artifacts.isEmpty()) {
            return Collections.emptyList();
        }
        Action group = AppFactory.eINSTANCE.createAction();
        group.setText("Artifacts");
        EList children = group.getChildren();
        for (Artifact artifact : artifacts) {
            children.add((Object)this.createChildAction((EObject)artifact, registry, resolveConsumer, progressMonitor));
        }
        return Collections.singletonList(group);
    }
}

