/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.flow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.ETypedElement;
import org.nasdanika.common.Context;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.common.Util;
import org.nasdanika.diagram.Diagram;
import org.nasdanika.diagram.DiagramElement;
import org.nasdanika.flow.Artifact;
import org.nasdanika.flow.FlowPackage;
import org.nasdanika.flow.Relationship;
import org.nasdanika.flow.Transition;
import org.nasdanika.flow.util.ArtifactComponentDiagramGenerator;
import org.nasdanika.html.emf.ColumnBuilder;
import org.nasdanika.html.emf.EObjectActionProvider;
import org.nasdanika.html.emf.EObjectActionResolver;
import org.nasdanika.html.flow.ParticipantResponsibilityActionProvider;
import org.nasdanika.html.model.app.Action;
import org.nasdanika.html.model.app.AppFactory;
import org.nasdanika.html.model.app.SectionStyle;
import org.nasdanika.html.model.bootstrap.Table;
import org.nasdanika.html.model.bootstrap.TableCell;
import org.nasdanika.ncore.NcorePackage;
import org.nasdanika.ncore.util.NamedElementComparator;

public class ArtifactActionProvider
extends ParticipantResponsibilityActionProvider<Artifact> {
    public ArtifactActionProvider(Artifact value, Context context) {
        super(value, context);
    }

    @Override
    protected Action createAction(BiConsumer<EObject, Action> registry, Consumer<org.nasdanika.common.Consumer<EObjectActionResolver.Context>> resolveConsumer, ProgressMonitor progressMonitor) throws Exception {
        Action action = super.createAction(registry, resolveConsumer, progressMonitor);
        EList children = action.getChildren();
        for (Artifact element : ((Artifact)this.getTarget()).getChildren().values().stream().sorted(NamedElementComparator.INSTANCE).collect(Collectors.toList())) {
            children.add((Object)this.createChildAction((EObject)element, registry, resolveConsumer, progressMonitor));
        }
        return action;
    }

    @Override
    protected List<ETypedElement> getProperties() {
        List<ETypedElement> properties = super.getProperties();
        properties.add((ETypedElement)FlowPackage.Literals.ARTIFACT__INPUT_FOR);
        properties.add((ETypedElement)FlowPackage.Literals.ARTIFACT__OUTPUT_FOR);
        properties.add((ETypedElement)FlowPackage.Literals.ARTIFACT__REPOSITORIES);
        properties.add((ETypedElement)FlowPackage.Literals.ARTIFACT__USED_BY);
        properties.add((ETypedElement)FlowPackage.Literals.ARTIFACT__TEMPLATES);
        properties.add((ETypedElement)FlowPackage.Literals.ARTIFACT__INSTANCES);
        return properties;
    }

    @Override
    protected void resolve(Action action, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
        super.resolve(action, context, progressMonitor);
        EList sections = action.getSections();
        Artifact semanticElement = (Artifact)this.getTarget();
        if (!semanticElement.getPayloadFor().isEmpty()) {
            sections.add((Object)this.createEReferenceAction(action, FlowPackage.Literals.ARTIFACT__PAYLOAD_FOR, context, progressMonitor));
        }
        if (!semanticElement.getResponseFor().isEmpty()) {
            sections.add((Object)this.createEReferenceAction(action, FlowPackage.Literals.ARTIFACT__RESPONSE_FOR, context, progressMonitor));
        }
        EList inboundRelationships = semanticElement.getInboundRelationships();
        EMap outboundRelationships = semanticElement.getOutboundRelationships();
        if (!inboundRelationships.isEmpty() || !outboundRelationships.isEmpty()) {
            Action rAction = AppFactory.eINSTANCE.createAction();
            rAction.setSectionStyle(SectionStyle.HEADER);
            rAction.setText("Relationships");
            sections.add((Object)rAction);
            EList rSections = rAction.getSections();
            if (!inboundRelationships.isEmpty()) {
                rSections.add((Object)this.createInboundRelationshipsAction(action, context, progressMonitor));
            }
            if (!outboundRelationships.isEmpty()) {
                rSections.add((Object)this.createOutboundRelationshipsAction(action, context, progressMonitor));
            }
        }
    }

    private Action createEReferenceAction(Action action, EReference eReference, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
        ArrayList<Object> columnBuilders = new ArrayList<Object>();
        columnBuilders.add(new ColumnBuilder<EObject>(){

            public void buildHeader(TableCell header, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                header.getContent().add((Object)EObjectActionProvider.createText((String)"Source"));
            }

            public void buildCell(EObject rowElement, TableCell cell, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                cell.getContent().add((Object)ArtifactActionProvider.this.renderValue(base, typedElement, rowElement.eContainer().eContainer(), context, progressMonitor));
            }
        });
        columnBuilders.add(new ColumnBuilder<EObject>(){

            public void buildHeader(TableCell header, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                header.getContent().add((Object)EObjectActionProvider.createText((String)"Key"));
            }

            public void buildCell(EObject rowElement, TableCell cell, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                EObject renderedValue = ArtifactActionProvider.this.renderValue(base, typedElement, ((Map.Entry)rowElement.eContainer()).getKey(), context, progressMonitor);
                if (renderedValue != null) {
                    cell.getContent().add((Object)renderedValue);
                }
            }
        });
        columnBuilders.add(new ColumnBuilder<EObject>(){

            public void buildHeader(TableCell header, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                header.getContent().add((Object)EObjectActionProvider.createText((String)"Target"));
            }

            public void buildCell(EObject rowElement, TableCell cell, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                EObject renderedValue = ArtifactActionProvider.this.renderValue(base, typedElement, ((Transition)rowElement).getTarget(), context, progressMonitor);
                if (renderedValue != null) {
                    cell.getContent().add((Object)renderedValue);
                }
            }
        });
        columnBuilders.add(new ColumnBuilder<EObject>(){

            public void buildHeader(TableCell header, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                header.getContent().add((Object)EObjectActionProvider.createText((String)"Name"));
            }

            public void buildCell(EObject rowElement, TableCell cell, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                EObject renderedValue = ArtifactActionProvider.this.renderValue(base, typedElement, ((Transition)rowElement).getName(), context, progressMonitor);
                if (renderedValue != null) {
                    cell.getContent().add((Object)renderedValue);
                }
            }
        });
        columnBuilders.add(new ColumnBuilder<EObject>(){

            public void buildHeader(TableCell header, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                header.getContent().add((Object)EObjectActionProvider.createText((String)"Documentation"));
            }

            public void buildCell(EObject rowElement, TableCell cell, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                EObject renderedValue = ArtifactActionProvider.this.renderValue(base, typedElement, ((Transition)rowElement).getDocumentation(), context, progressMonitor);
                if (renderedValue != null) {
                    cell.getContent().add((Object)renderedValue);
                }
            }
        });
        return this.createTableAction((ETypedElement)eReference, columnBuilders, action, context, progressMonitor);
    }

    @Override
    protected void populateRepresentation(Diagram representation, final Action action, final EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
        ArtifactComponentDiagramGenerator artifactComponentDiagramGenerator = new ArtifactComponentDiagramGenerator(){

            protected String getArtifactLocation(Artifact semanticElement) {
                Action elementAction = context.getAction((EObject)semanticElement);
                if (elementAction == null) {
                    return null;
                }
                URI uri = context.resolve(elementAction, action);
                return uri == null ? null : uri.toString();
            }

            protected String getArtifactTooltip(Artifact semanticElement) {
                Action elementAction = context.getAction((EObject)semanticElement);
                return elementAction == null ? null : elementAction.getDescription();
            }

            protected DiagramElement createDiagramElement(Artifact semanticElement, Map<Artifact, DiagramElement> semanticMap, Artifact contextElement, int depth) {
                DiagramElement ret = super.createDiagramElement(semanticElement, semanticMap, contextElement, depth);
                String text = ret.getText();
                int initialLineLength = 25;
                if (text != null && text.length() > initialLineLength) {
                    ret.setText(Util.wrap((String)text, (int)initialLineLength, (int)2, (String)"\\n"));
                }
                return ret;
            }
        };
        this.populateRepresentation(representation, artifactComponentDiagramGenerator);
    }

    protected void populateRepresentation(Diagram representation, ArtifactComponentDiagramGenerator artifactComponentDiagramGenerator) {
        artifactComponentDiagramGenerator.generateDiagram((Artifact)this.getTarget(), representation);
    }

    private Action createInboundRelationshipsAction(Action action, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
        ArrayList<ColumnBuilder> columnBuilders = new ArrayList<ColumnBuilder>();
        columnBuilders.add(new ColumnBuilder<EObject>(){

            public void buildHeader(TableCell header, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                header.getContent().add((Object)EObjectActionProvider.createText((String)"Source"));
            }

            public void buildCell(EObject rowElement, TableCell cell, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                cell.getContent().add((Object)ArtifactActionProvider.this.renderValue(base, typedElement, rowElement.eContainer().eContainer(), context, progressMonitor));
            }
        });
        columnBuilders.add(this.createColumnBuilder((ETypedElement)NcorePackage.Literals.NAMED_ELEMENT__NAME));
        columnBuilders.add(this.createColumnBuilder((ETypedElement)FlowPackage.Literals.PACKAGE_ELEMENT__DOCUMENTATION));
        Action ret = AppFactory.eINSTANCE.createAction();
        ret.setText("Inbound");
        Table table = ArtifactActionProvider.buildTable((Collection)((Artifact)this.getTarget()).getInboundRelationships(), columnBuilders, (Action)action, (ETypedElement)FlowPackage.Literals.ARTIFACT__INBOUND_RELATIONSHIPS, (EObjectActionResolver.Context)context, (ProgressMonitor)progressMonitor);
        ret.getContent().add((Object)table);
        return ret;
    }

    private Action createOutboundRelationshipsAction(Action action, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
        ArrayList<Object> columnBuilders = new ArrayList<Object>();
        columnBuilders.add(new ColumnBuilder<Map.Entry<String, Relationship>>(){

            public void buildHeader(TableCell header, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                header.getContent().add((Object)EObjectActionProvider.createText((String)"Key"));
            }

            public void buildCell(Map.Entry<String, Relationship> rowElement, TableCell cell, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                EObject renderedValue = ArtifactActionProvider.this.renderValue(base, typedElement, rowElement.getKey(), context, progressMonitor);
                if (renderedValue != null) {
                    cell.getContent().add((Object)renderedValue);
                }
            }
        });
        columnBuilders.add(new ColumnBuilder<Map.Entry<String, Relationship>>(){

            public void buildHeader(TableCell header, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                header.getContent().add((Object)EObjectActionProvider.createText((String)"Target"));
            }

            public void buildCell(Map.Entry<String, Relationship> rowElement, TableCell cell, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                Relationship relationship = rowElement.getValue();
                EObject renderedValue = ArtifactActionProvider.this.renderValue(base, typedElement, relationship.getTarget(), context, progressMonitor);
                if (renderedValue != null) {
                    cell.getContent().add((Object)renderedValue);
                }
            }
        });
        columnBuilders.add(new ColumnBuilder<Map.Entry<String, Relationship>>(){

            public void buildHeader(TableCell header, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                header.getContent().add((Object)EObjectActionProvider.createText((String)"Name"));
            }

            public void buildCell(Map.Entry<String, Relationship> rowElement, TableCell cell, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                Relationship value = rowElement.getValue();
                EObject renderedValue = ArtifactActionProvider.this.renderValue(base, typedElement, value.getName(), context, progressMonitor);
                if (renderedValue != null) {
                    cell.getContent().add((Object)renderedValue);
                }
            }
        });
        columnBuilders.add(new ColumnBuilder<Map.Entry<String, Relationship>>(){

            public void buildHeader(TableCell header, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                header.getContent().add((Object)EObjectActionProvider.createText((String)"Documentation"));
            }

            public void buildCell(Map.Entry<String, Relationship> rowElement, TableCell cell, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                Relationship value = rowElement.getValue();
                EObject renderedValue = ArtifactActionProvider.this.renderValue(base, typedElement, value.getDocumentation(), context, progressMonitor);
                if (renderedValue != null) {
                    cell.getContent().add((Object)renderedValue);
                }
            }
        });
        Action ret = AppFactory.eINSTANCE.createAction();
        ret.setText("Outbound");
        Table table = ArtifactActionProvider.buildTable((Collection)((Artifact)this.getTarget()).getOutboundRelationships(), columnBuilders, (Action)action, (ETypedElement)FlowPackage.Literals.ARTIFACT__OUTBOUND_RELATIONSHIPS, (EObjectActionResolver.Context)context, (ProgressMonitor)progressMonitor);
        ret.getContent().add((Object)table);
        return ret;
    }
}

