/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.flow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.nasdanika.common.Context;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.common.Util;
import org.nasdanika.diagram.Diagram;
import org.nasdanika.diagram.DiagramElement;
import org.nasdanika.flow.Call;
import org.nasdanika.flow.FlowElement;
import org.nasdanika.flow.FlowPackage;
import org.nasdanika.flow.Participant;
import org.nasdanika.flow.Transition;
import org.nasdanika.flow.util.FlowStateDiagramGenerator;
import org.nasdanika.html.emf.ColumnBuilder;
import org.nasdanika.html.emf.EObjectActionProvider;
import org.nasdanika.html.emf.EObjectActionResolver;
import org.nasdanika.html.flow.ParticipantResponsibilityActionProvider;
import org.nasdanika.html.model.app.Action;
import org.nasdanika.html.model.bootstrap.TableCell;
import org.nasdanika.ncore.NcorePackage;
import org.nasdanika.ncore.util.NamedElementComparator;

public class FlowElementActionProvider<T extends FlowElement<?>>
extends ParticipantResponsibilityActionProvider<T> {
    public FlowElementActionProvider(T value, Context context) {
        super(value, context);
    }

    @Override
    protected List<ETypedElement> getProperties() {
        List<ETypedElement> properties = super.getProperties();
        properties.add((ETypedElement)FlowPackage.Literals.FLOW_ELEMENT__INPUT_ARTIFACTS);
        properties.add((ETypedElement)FlowPackage.Literals.FLOW_ELEMENT__OUTPUT_ARTIFACTS);
        properties.add((ETypedElement)FlowPackage.Literals.FLOW_ELEMENT__PARTICIPANTS);
        properties.add((ETypedElement)FlowPackage.Literals.FLOW_ELEMENT__RESOURCES);
        return properties;
    }

    protected Object getTypedElementValue(ETypedElement typedElement) throws Exception {
        Object value = super.getTypedElementValue(typedElement);
        if (value instanceof Collection && (typedElement == FlowPackage.Literals.FLOW_ELEMENT__INPUT_ARTIFACTS || typedElement == FlowPackage.Literals.FLOW_ELEMENT__OUTPUT_ARTIFACTS || typedElement == FlowPackage.Literals.FLOW_ELEMENT__PARTICIPANTS || typedElement == FlowPackage.Literals.FLOW_ELEMENT__RESOURCES)) {
            return ((Collection)value).stream().sorted(NamedElementComparator.INSTANCE).collect(Collectors.toList());
        }
        return value;
    }

    @Override
    protected void resolve(Action action, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
        super.resolve(action, context, progressMonitor);
        EList sections = action.getSections();
        if (!((FlowElement)this.getTarget()).getInputs().isEmpty()) {
            sections.add((Object)this.createInputsAction(action, context, progressMonitor));
        }
        if (!((FlowElement)this.getTarget()).getOutputs().isEmpty()) {
            sections.add((Object)this.createOutputsAction(action, context, progressMonitor));
        }
        if (!((FlowElement)this.getTarget()).getInvocations().isEmpty()) {
            sections.add((Object)this.createInvocationsAction(action, context, progressMonitor));
        }
        if (!((FlowElement)this.getTarget()).getCalls().isEmpty()) {
            sections.add((Object)this.createCallsAction(action, context, progressMonitor));
        }
        if (!((FlowElement)this.getTarget()).getArtifactResponsibilities().isEmpty()) {
            sections.add((Object)this.createArtifactResponsibilitiesAction(action, context, progressMonitor));
        }
    }

    @Override
    protected void populateRepresentation(Diagram representation, final Action action, final EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
        FlowStateDiagramGenerator flowStateDiagramGenerator = new FlowStateDiagramGenerator(){

            protected String getFlowElementLocation(FlowElement<?> flowElement) {
                Action elementAction = context.getAction(flowElement);
                if (elementAction == null) {
                    return null;
                }
                URI uri = context.resolve(elementAction, action);
                return uri == null ? null : uri.toString();
            }

            protected String getFlowElementTooltip(FlowElement<?> flowElement) {
                Action elementAction = context.getAction(flowElement);
                return elementAction == null ? null : elementAction.getDescription();
            }

            protected String getParticipantLocation(Participant participant) {
                Action elementAction = context.getAction((EObject)participant);
                if (elementAction == null) {
                    return null;
                }
                URI uri = context.resolve(elementAction, action);
                return uri == null ? null : uri.toString();
            }

            protected String getParticipantTooltip(Participant participant) {
                Action elementAction = context.getAction((EObject)participant);
                return elementAction == null ? null : elementAction.getDescription();
            }

            protected DiagramElement createDiagramElement(FlowElement<?> flowElement, Map<FlowElement<?>, DiagramElement> semanticMap, FlowElement<?> contextElement, Predicate<FlowElement<?>> partitionPredicate, int depth) {
                DiagramElement ret = super.createDiagramElement(flowElement, semanticMap, contextElement, partitionPredicate, depth);
                String text = ret.getText();
                int initialLineLength = 25;
                if (text != null && text.length() > initialLineLength) {
                    ret.setText(Util.wrap((String)text, (int)initialLineLength, (int)2, (String)"\\n"));
                }
                return ret;
            }
        };
        this.populateRepresentation(representation, flowStateDiagramGenerator);
    }

    protected void populateRepresentation(Diagram representation, FlowStateDiagramGenerator flowStateDiagramGenerator) {
        flowStateDiagramGenerator.generateDiagram((FlowElement)this.getTarget(), representation, null);
    }

    private Action createInputsAction(Action action, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
        ArrayList<ColumnBuilder> columnBuilders = new ArrayList<ColumnBuilder>();
        columnBuilders.add(new ColumnBuilder<EObject>(){

            public void buildHeader(TableCell header, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                header.getContent().add((Object)EObjectActionProvider.createText((String)"Source"));
            }

            public void buildCell(EObject rowElement, TableCell cell, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                cell.getContent().add((Object)FlowElementActionProvider.this.renderValue(base, typedElement, rowElement.eContainer().eContainer(), context, progressMonitor));
            }
        });
        columnBuilders.add(this.createColumnBuilder((ETypedElement)NcorePackage.Literals.NAMED_ELEMENT__NAME));
        columnBuilders.add(this.createColumnBuilder((ETypedElement)FlowPackage.Literals.PACKAGE_ELEMENT__DOCUMENTATION));
        columnBuilders.add(this.createColumnBuilder((ETypedElement)FlowPackage.Literals.TRANSITION__PAYLOAD));
        return this.createTableAction((ETypedElement)FlowPackage.Literals.FLOW_ELEMENT__INPUTS, columnBuilders, action, context, progressMonitor);
    }

    private Action createOutputsAction(Action action, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
        ArrayList<Object> columnBuilders = new ArrayList<Object>();
        columnBuilders.add(new ColumnBuilder<EObject>(){

            public void buildHeader(TableCell header, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                header.getContent().add((Object)EObjectActionProvider.createText((String)"Key"));
            }

            public void buildCell(EObject rowElement, TableCell cell, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                EObject renderedValue = FlowElementActionProvider.this.renderValue(base, typedElement, ((Map.Entry)rowElement).getKey(), context, progressMonitor);
                if (renderedValue != null) {
                    cell.getContent().add((Object)renderedValue);
                }
            }
        });
        columnBuilders.add(new ColumnBuilder<EObject>(){

            public void buildHeader(TableCell header, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                header.getContent().add((Object)EObjectActionProvider.createText((String)"Target"));
            }

            public void buildCell(EObject rowElement, TableCell cell, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                Transition transition = (Transition)((Map.Entry)rowElement).getValue();
                EObject renderedValue = FlowElementActionProvider.this.renderValue(base, typedElement, transition.getTarget(), context, progressMonitor);
                if (renderedValue != null) {
                    cell.getContent().add((Object)renderedValue);
                }
            }
        });
        columnBuilders.add(new ColumnBuilder<EObject>(){

            public void buildHeader(TableCell header, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                header.getContent().add((Object)EObjectActionProvider.createText((String)"Name"));
            }

            public void buildCell(EObject rowElement, TableCell cell, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                Transition value = (Transition)((Map.Entry)rowElement).getValue();
                EObject renderedValue = FlowElementActionProvider.this.renderValue(base, typedElement, value.getName(), context, progressMonitor);
                if (renderedValue != null) {
                    cell.getContent().add((Object)renderedValue);
                }
            }
        });
        columnBuilders.add(new ColumnBuilder<EObject>(){

            public void buildHeader(TableCell header, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                header.getContent().add((Object)EObjectActionProvider.createText((String)"Documentation"));
            }

            public void buildCell(EObject rowElement, TableCell cell, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                Transition value = (Transition)((Map.Entry)rowElement).getValue();
                EObject renderedValue = FlowElementActionProvider.this.renderValue(base, typedElement, value.getDocumentation(), context, progressMonitor);
                if (renderedValue != null) {
                    cell.getContent().add((Object)renderedValue);
                }
            }
        });
        columnBuilders.add(new ColumnBuilder<EObject>(){

            public void buildHeader(TableCell header, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                header.getContent().add((Object)EObjectActionProvider.createText((String)"Payload"));
            }

            public void buildCell(EObject rowElement, TableCell cell, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                Transition value = (Transition)((Map.Entry)rowElement).getValue();
                EObject renderedValue = FlowElementActionProvider.this.renderValue(base, typedElement, value.getPayload(), context, progressMonitor);
                if (renderedValue != null) {
                    cell.getContent().add((Object)renderedValue);
                }
            }
        });
        return this.createTableAction((ETypedElement)FlowPackage.Literals.FLOW_ELEMENT__OUTPUTS, columnBuilders, action, context, progressMonitor);
    }

    private Action createInvocationsAction(Action action, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
        ArrayList<ColumnBuilder> columnBuilders = new ArrayList<ColumnBuilder>();
        columnBuilders.add(new ColumnBuilder<EObject>(){

            public void buildHeader(TableCell header, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                header.getContent().add((Object)EObjectActionProvider.createText((String)"Source"));
            }

            public void buildCell(EObject rowElement, TableCell cell, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                cell.getContent().add((Object)FlowElementActionProvider.this.renderValue(base, typedElement, rowElement.eContainer().eContainer(), context, progressMonitor));
            }
        });
        columnBuilders.add(this.createColumnBuilder((ETypedElement)NcorePackage.Literals.NAMED_ELEMENT__NAME));
        columnBuilders.add(this.createColumnBuilder((ETypedElement)FlowPackage.Literals.PACKAGE_ELEMENT__DOCUMENTATION));
        columnBuilders.add(this.createColumnBuilder((ETypedElement)FlowPackage.Literals.TRANSITION__PAYLOAD));
        columnBuilders.add(this.createColumnBuilder((ETypedElement)FlowPackage.Literals.CALL__RESPONSE));
        return this.createTableAction((ETypedElement)FlowPackage.Literals.FLOW_ELEMENT__INVOCATIONS, columnBuilders, action, context, progressMonitor);
    }

    private Action createCallsAction(Action action, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
        ArrayList<Object> columnBuilders = new ArrayList<Object>();
        columnBuilders.add(new ColumnBuilder<EObject>(){

            public void buildHeader(TableCell header, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                header.getContent().add((Object)EObjectActionProvider.createText((String)"Key"));
            }

            public void buildCell(EObject rowElement, TableCell cell, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                EObject renderedValue = FlowElementActionProvider.this.renderValue(base, typedElement, ((Map.Entry)rowElement).getKey(), context, progressMonitor);
                if (renderedValue != null) {
                    cell.getContent().add((Object)renderedValue);
                }
            }
        });
        columnBuilders.add(new ColumnBuilder<EObject>(){

            public void buildHeader(TableCell header, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                header.getContent().add((Object)EObjectActionProvider.createText((String)"Target"));
            }

            public void buildCell(EObject rowElement, TableCell cell, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                Transition transition = (Transition)((Map.Entry)rowElement).getValue();
                EObject renderedValue = FlowElementActionProvider.this.renderValue(base, typedElement, transition.getTarget(), context, progressMonitor);
                if (renderedValue != null) {
                    cell.getContent().add((Object)renderedValue);
                }
            }
        });
        columnBuilders.add(new ColumnBuilder<EObject>(){

            public void buildHeader(TableCell header, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                header.getContent().add((Object)EObjectActionProvider.createText((String)"Name"));
            }

            public void buildCell(EObject rowElement, TableCell cell, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                Transition value = (Transition)((Map.Entry)rowElement).getValue();
                EObject renderedValue = FlowElementActionProvider.this.renderValue(base, typedElement, value.getName(), context, progressMonitor);
                if (renderedValue != null) {
                    cell.getContent().add((Object)renderedValue);
                }
            }
        });
        columnBuilders.add(new ColumnBuilder<EObject>(){

            public void buildHeader(TableCell header, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                header.getContent().add((Object)EObjectActionProvider.createText((String)"Documentation"));
            }

            public void buildCell(EObject rowElement, TableCell cell, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                Transition value = (Transition)((Map.Entry)rowElement).getValue();
                EObject renderedValue = FlowElementActionProvider.this.renderValue(base, typedElement, value.getDocumentation(), context, progressMonitor);
                if (renderedValue != null) {
                    cell.getContent().add((Object)renderedValue);
                }
            }
        });
        columnBuilders.add(new ColumnBuilder<EObject>(){

            public void buildHeader(TableCell header, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                header.getContent().add((Object)EObjectActionProvider.createText((String)"Request"));
            }

            public void buildCell(EObject rowElement, TableCell cell, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                Transition value = (Transition)((Map.Entry)rowElement).getValue();
                EObject renderedValue = FlowElementActionProvider.this.renderValue(base, typedElement, value.getPayload(), context, progressMonitor);
                if (renderedValue != null) {
                    cell.getContent().add((Object)renderedValue);
                }
            }
        });
        columnBuilders.add(new ColumnBuilder<EObject>(){

            public void buildHeader(TableCell header, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                header.getContent().add((Object)EObjectActionProvider.createText((String)"Response"));
            }

            public void buildCell(EObject rowElement, TableCell cell, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
                Call value = (Call)((Map.Entry)rowElement).getValue();
                EObject renderedValue = FlowElementActionProvider.this.renderValue(base, typedElement, value.getResponse(), context, progressMonitor);
                if (renderedValue != null) {
                    cell.getContent().add((Object)renderedValue);
                }
            }
        });
        return this.createTableAction((ETypedElement)FlowPackage.Literals.FLOW_ELEMENT__CALLS, columnBuilders, action, context, progressMonitor);
    }

    private Action createArtifactResponsibilitiesAction(Action action, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
        return this.createTableAction((ETypedElement)FlowPackage.Literals.FLOW_ELEMENT__ARTIFACT_RESPONSIBILITIES, action, context, progressMonitor, new ETypedElement[]{FlowPackage.Literals.ARTIFACT_PARTICIPANT_RESPONSIBILITY__ARTIFACT, FlowPackage.Literals.PARTICIPANT_RESPONSIBILITY__RESPONSIBLE, FlowPackage.Literals.PARTICIPANT_RESPONSIBILITY__ACCOUNTABLE, FlowPackage.Literals.PARTICIPANT_RESPONSIBILITY__CONSULTED, FlowPackage.Literals.PARTICIPANT_RESPONSIBILITY__INFORMED, NcorePackage.Literals.MODEL_ELEMENT__DESCRIPTION});
    }
}

