/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.flow;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.nasdanika.common.BiSupplier;
import org.nasdanika.common.Context;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.common.Util;
import org.nasdanika.diagram.Diagram;
import org.nasdanika.diagram.gen.Generator;
import org.nasdanika.flow.FlowPackage;
import org.nasdanika.flow.PackageElement;
import org.nasdanika.html.emf.EObjectActionProvider;
import org.nasdanika.html.emf.EObjectActionResolver;
import org.nasdanika.html.model.app.Action;
import org.nasdanika.html.model.app.AppFactory;
import org.nasdanika.html.model.app.SectionStyle;
import org.nasdanika.html.model.bootstrap.BootstrapFactory;
import org.nasdanika.html.model.bootstrap.Table;
import org.nasdanika.html.model.bootstrap.TableCell;
import org.nasdanika.html.model.bootstrap.TableRow;
import org.nasdanika.html.model.bootstrap.TableSection;
import org.nasdanika.ncore.util.NamedElementComparator;
import org.nasdanika.ncore.util.NcoreUtil;

public class PackageElementActionProvider<T extends PackageElement<?>>
extends EObjectActionProvider<T> {
    protected int descriptionTabLengthThreshold = 2500;

    public PackageElementActionProvider(T value, Context context) {
        super(value, context);
    }

    protected Action createAction(BiConsumer<EObject, Action> registry, Consumer<org.nasdanika.common.Consumer<EObjectActionResolver.Context>> resolveConsumer, ProgressMonitor progressMonitor) throws Exception {
        Action ret = super.createAction(registry, resolveConsumer, progressMonitor);
        PackageElement eObj = (PackageElement)this.getTarget();
        URI uri = NcoreUtil.getUri((EObject)eObj);
        String id = uri == null ? eObj.getUuid() : uri.toString();
        String digest = Hex.encodeHexString((byte[])MessageDigest.getInstance("SHA-256").digest(id.getBytes(StandardCharsets.UTF_8)));
        ret.setId(digest);
        String description = eObj.getDescription();
        PackageElementActionProvider.addContent((Action)ret, (String)description);
        ret.setDescription(description);
        BiSupplier cPath = NcoreUtil.containmentPath((EObject)eObj);
        if (cPath == null || Util.isBlank((String)((String)cPath.getSecond()))) {
            ret.setLocation("${base-uri}index.html");
        } else {
            ret.setLocation((String)cPath.getSecond() + "/index.html");
        }
        ret.setText(eObj.getName());
        ret.setSectionStyle(SectionStyle.HEADER);
        return ret;
    }

    public String name() {
        return ((PackageElement)this.getTarget()).getName();
    }

    protected List<ETypedElement> getProperties() {
        List propertiew = super.getProperties();
        propertiew.add(FlowPackage.Literals.PACKAGE_ELEMENT__EXTENDS);
        propertiew.add(FlowPackage.Literals.PACKAGE_ELEMENT__EXTENSIONS);
        propertiew.add(FlowPackage.Literals.PACKAGE_ELEMENT__MODIFIERS);
        return propertiew;
    }

    protected Table createPropertiesTable(Action action, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
        Table propertiesTable = super.createPropertiesTable(action, context, progressMonitor);
        propertiesTable.getAttributes().put((Object)"style", (Object)PackageElementActionProvider.createText((String)"width:auto"));
        return propertiesTable;
    }

    protected void resolve(Action action, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
        super.resolve(action, context, progressMonitor);
        PackageElement semanticElement = (PackageElement)this.getTarget();
        for (Diagram representation : semanticElement.getRepresentations().values().stream().sorted(NamedElementComparator.INSTANCE).collect(Collectors.toList())) {
            Action representationAction;
            if (representation.getElements().isEmpty()) {
                this.populateRepresentation(representation, action, context, progressMonitor);
            }
            if (Util.isBlank((String)representation.getName())) {
                representationAction = action;
            } else {
                representationAction = AppFactory.eINSTANCE.createAction();
                representationAction.setText(representation.getName());
                action.getSections().add((Object)representationAction);
            }
            String rDescr = representation.getDescription();
            if (Util.isBlank((String)rDescr)) {
                PackageElementActionProvider.addContent((Action)representationAction, (String)this.createGenerator().generate(representation));
                continue;
            }
            Table table = BootstrapFactory.eINSTANCE.createTable();
            representationAction.getContent().add((Object)table);
            table.setBordered(true);
            TableSection body = BootstrapFactory.eINSTANCE.createTableSection();
            table.setBody(body);
            table.getAttributes().put((Object)"style", (Object)PackageElementActionProvider.createText((String)"width:auto"));
            TableRow diagramRow = BootstrapFactory.eINSTANCE.createTableRow();
            body.getRows().add((Object)diagramRow);
            TableCell diagramCell = BootstrapFactory.eINSTANCE.createTableCell();
            diagramRow.getCells().add((Object)diagramCell);
            diagramCell.getContent().add((Object)PackageElementActionProvider.createText((String)this.createGenerator().generate(representation)));
            TableRow descriptionRow = BootstrapFactory.eINSTANCE.createTableRow();
            body.getRows().add((Object)descriptionRow);
            TableCell descriptionCell = BootstrapFactory.eINSTANCE.createTableCell();
            descriptionRow.getCells().add((Object)descriptionCell);
            descriptionCell.getContent().add((Object)PackageElementActionProvider.createText((String)rDescr));
        }
        action.getContent().addAll(EcoreUtil.copyAll((Collection)semanticElement.getDocumentation()));
    }

    protected Generator createGenerator() {
        return new Generator();
    }

    protected void populateRepresentation(Diagram representation, Action action, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) throws Exception {
    }
}

