/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.ecore;

import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.nasdanika.common.Context;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.exec.content.ContentFactory;
import org.nasdanika.exec.content.Text;
import org.nasdanika.html.ecore.ENamedElementActionSupplier;
import org.nasdanika.html.model.app.Action;

public class EClassifierActionSupplier<T extends EClassifier>
extends ENamedElementActionSupplier<T> {
    private Function<String, String> javadocResolver;
    protected Class<?> instanceClass;
    protected Function<String, Object> ePackageResolver;

    public EClassifierActionSupplier(T value, Context context, Function<EPackage, String> ePackagePathComputer, Function<String, String> javadocResolver, Function<String, Object> ePackageResolver, Predicate<EModelElement> elementPredicate, BiFunction<ENamedElement, String, String> labelProvider) {
        super(value, context, ePackagePathComputer, elementPredicate, labelProvider);
        this.javadocResolver = javadocResolver;
        this.ePackageResolver = ePackageResolver;
        this.instanceClass = EClassifierActionSupplier.getInstanceClass(value, ePackageResolver);
    }

    @Override
    protected void header(Action action, ProgressMonitor progressMonitor) {
        if (this.instanceClass != null) {
            String instanceClassName = this.instanceClass.getName();
            if (this.javadocResolver != null) {
                instanceClassName = this.javadocResolver.apply(instanceClassName);
            }
            Text text = ContentFactory.eINSTANCE.createText();
            text.setContent("<div class='text-monospace'>" + instanceClassName + "</div>");
            action.getContent().add((Object)text);
        }
    }

    @Override
    public Action execute(EClass contextEClass, ProgressMonitor progressMonitor) {
        Action action = super.execute(contextEClass, progressMonitor);
        action.setLocation(((EClassifier)this.eObject).getName() + ".html");
        action.setId(((EClassifier)this.eObject).eClass().getName() + "-" + this.encodeEPackage(((EClassifier)this.eObject).getEPackage()) + "-" + ((EClassifier)this.eObject).getName());
        action.getUris().add((Object)(((EClassifier)this.eObject).getEPackage().getNsURI() + "#" + ((EClassifier)this.eObject).getName()));
        return action;
    }

    @Override
    protected String getDefaultLabel(ProgressMonitor progressMonitor) {
        return ((EClassifier)this.eObject).getName() + this.typeParameters((EClassifier)this.eObject);
    }

    protected Collection<EClass> getUses() {
        return this.getUses((EClassifier)this.eObject);
    }
}

