/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.ecore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.nasdanika.common.Context;
import org.nasdanika.common.DiagramGenerator;
import org.nasdanika.common.MarkdownHelper;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.common.Util;
import org.nasdanika.emf.DiagramTextGenerator;
import org.nasdanika.emf.EmfUtil;
import org.nasdanika.emf.MermaidTextGenerator;
import org.nasdanika.emf.PlantUmlTextGenerator;
import org.nasdanika.emf.persistence.EObjectLoader;
import org.nasdanika.html.Fragment;
import org.nasdanika.html.HTMLFactory;
import org.nasdanika.html.Table;
import org.nasdanika.html.Tag;
import org.nasdanika.html.TagName;
import org.nasdanika.html.bootstrap.BootstrapFactory;
import org.nasdanika.html.ecore.EClassifierActionSupplier;
import org.nasdanika.html.ecore.EModelElementActionSupplier;
import org.nasdanika.html.ecore.ETypedElementActionSupplier;
import org.nasdanika.html.model.app.Action;
import org.nasdanika.html.model.app.AppFactory;
import org.nasdanika.html.model.app.SectionStyle;
import org.nasdanika.html.model.app.gen.DynamicTableBuilder;
import org.nasdanika.ncore.util.NcoreUtil;

public class EClassActionSupplier
extends EClassifierActionSupplier<EClass> {
    private BooleanSupplier isGenerateLoadSpecification;
    private Supplier<String> diagramDialectSupplier;

    public EClassActionSupplier(EClass value, Context context, Function<EPackage, String> ePackagePathComputer, Function<String, String> javadocResolver, Function<String, Object> ePackageResolver, Predicate<EModelElement> elementPredicate, BiFunction<ENamedElement, String, String> labelProvider, BooleanSupplier isGenerateLoadSpecification, Supplier<String> diagramDialectSupplier) {
        super(value, context, ePackagePathComputer, javadocResolver, ePackageResolver, elementPredicate, labelProvider);
        this.elementPredicate = elementPredicate;
        this.isGenerateLoadSpecification = isGenerateLoadSpecification;
        this.diagramDialectSupplier = diagramDialectSupplier;
    }

    @Override
    public Action execute(EClass contextEClass, ProgressMonitor progressMonitor) {
        List sortedOperations;
        List<EReference> sortedReferences;
        Collection uses;
        Collection referrers;
        Collection eSubTypes;
        List eGenericSuperTypes;
        Action action = super.execute(contextEClass, progressMonitor);
        action.setSectionStyle(SectionStyle.HEADER);
        String diagramMode = NcoreUtil.getNasdanikaAnnotationDetail((EModelElement)((EModelElement)this.eObject), (String)"diagram", (String)"navigation");
        String diagram = this.generateDiagram(1, DiagramTextGenerator.RelationshipDirection.both, true, true, progressMonitor);
        if (!Util.isBlank((String)diagram)) {
            switch (diagramMode) {
                case "content": {
                    EClassActionSupplier.addContent(action, diagram);
                    break;
                }
                case "none": {
                    break;
                }
                case "navigation": {
                    Action diagramAction = AppFactory.eINSTANCE.createAction();
                    action.getNavigation().add((Object)diagramAction);
                    diagramAction.setText("Diagram");
                    diagramAction.setIcon("fas fa-project-diagram");
                    diagramAction.setLocation(((EClass)this.eObject).getName() + "-diagram.html");
                    EClassActionSupplier.addContent(diagramAction, diagram);
                    break;
                }
                case "anonymous": {
                    Action diagramAction = AppFactory.eINSTANCE.createAction();
                    action.getAnonymous().add((Object)diagramAction);
                    diagramAction.setText("Diagram");
                    diagramAction.setIcon("fas fa-project-diagram");
                    diagramAction.setLocation(((EClass)this.eObject).getName() + "-diagram.html");
                    EClassActionSupplier.addContent(diagramAction, diagram);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported diagram annotation value '" + diagramMode + "' on EClass " + this.eObject);
                }
            }
        }
        if (!(eGenericSuperTypes = ((EClass)this.eObject).getEGenericSuperTypes().stream().filter(gst -> this.elementPredicate.test(gst.getEClassifier())).collect(Collectors.toList())).isEmpty()) {
            HTMLFactory htmlFactory = (HTMLFactory)this.context.get(HTMLFactory.class);
            Fragment gstf = htmlFactory.fragment(new Object[]{TagName.a.create(new Object[]{TagName.h3.create(new Object[]{"Supertypes"})}).attribute("name", (Object)"supertypes")});
            Tag list = TagName.ul.create(new Object[0]);
            gstf.content(new Object[]{list});
            for (Object superType : eGenericSuperTypes) {
                Tag listItem = TagName.li.create(new Object[0]);
                list.content(new Object[]{listItem});
                this.genericType((EGenericType)superType, (EClassifier)this.eObject, listItem.getContent()::add, progressMonitor);
            }
            EClassActionSupplier.addContent(action, gstf.toString());
        }
        if (!(eSubTypes = (Collection)this.getSubTypes((EClass)this.eObject).stream().filter(this.elementPredicate).sorted(this.eNamedElementComparator).collect(Collectors.toList())).isEmpty()) {
            HTMLFactory htmlFactory = (HTMLFactory)this.context.get(HTMLFactory.class);
            Fragment gstf = htmlFactory.fragment(new Object[]{TagName.a.create(new Object[]{TagName.h3.create(new Object[]{"Subtypes"})}).attribute("name", (Object)"subtypes")});
            Tag list = TagName.ul.create(new Object[0]);
            gstf.content(new Object[]{list});
            for (Object subType : eSubTypes) {
                list.content(new Object[]{TagName.li.create(new Object[]{this.link((EClassifier)subType, (EClassifier)this.eObject)})});
            }
            EClassActionSupplier.addContent(action, gstf.toString());
        }
        if (!(referrers = (Collection)this.getReferrers().stream().filter(this.elementPredicate).sorted(this.eNamedElementComparator).collect(Collectors.toList())).isEmpty()) {
            HTMLFactory htmlFactory = (HTMLFactory)this.context.get(HTMLFactory.class);
            Fragment gstf = htmlFactory.fragment(new Object[]{TagName.a.create(new Object[]{TagName.h3.create(new Object[]{"Referrers"})}).attribute("name", (Object)"referrers")});
            Tag list = TagName.ul.create(new Object[0]);
            gstf.content(new Object[]{list});
            for (Object referrer : referrers) {
                list.content(new Object[]{TagName.li.create(new Object[]{this.link((EClassifier)referrer, (EClassifier)this.eObject)})});
            }
            EClassActionSupplier.addContent(action, gstf.toString());
        }
        if (!(uses = (Collection)this.getUses().stream().filter(this.elementPredicate).sorted(this.eNamedElementComparator).collect(Collectors.toList())).isEmpty()) {
            HTMLFactory htmlFactory = (HTMLFactory)this.context.get(HTMLFactory.class);
            Fragment gstf = htmlFactory.fragment(new Object[]{TagName.a.create(new Object[]{TagName.h3.create(new Object[]{"Uses"})}).attribute("name", (Object)"uses")});
            Tag list = TagName.ul.create(new Object[0]);
            gstf.content(new Object[]{list});
            for (EClass use : uses) {
                list.content(new Object[]{TagName.li.create(new Object[]{this.link((EClassifier)use, (EClassifier)this.eObject)})});
            }
            EClassActionSupplier.addContent(action, gstf.toString());
        }
        List<EAttribute> allAttributes = ((EClass)this.eObject).getEAllAttributes().stream().filter(this.elementPredicate).sorted(this.eNamedElementComparator).collect(Collectors.toList());
        List<EReference> allReferences = ((EClass)this.eObject).getEAllReferences().stream().filter(this.elementPredicate).sorted(this.eNamedElementComparator).collect(Collectors.toList());
        List<EOperation> allOperations = ((EClass)this.eObject).getEAllOperations().stream().filter(this.elementPredicate).sorted(this.eNamedElementComparator).collect(Collectors.toList());
        List<EGenericType> allGenericSupertypes = ((EClass)this.eObject).getEAllGenericSuperTypes().stream().filter(gst -> this.elementPredicate.test(gst.getEClassifier())).collect(Collectors.toList());
        if (allAttributes.size() + allReferences.size() + allOperations.size() + allGenericSupertypes.size() != 0) {
            Action allGroup = AppFactory.eINSTANCE.createAction();
            allGroup.setText("All");
            allGroup.setUuid(action.getUuid() + "-all");
            action.getNavigation().add((Object)allGroup);
            this.generateAllAttributes(allAttributes, allGroup, progressMonitor);
            this.generateAllReferences(allReferences, allGroup, progressMonitor);
            this.generateAllOperations(allOperations, allGroup, progressMonitor);
            this.generateAllGenericSupertypes(allGenericSupertypes, allGroup, progressMonitor);
        }
        if (this.isGenerateLoadSpecification.getAsBoolean() && Map.Entry.class != this.instanceClass) {
            this.generateLoadSpecification(action, this.eNamedElementComparator, progressMonitor);
        }
        List<EAttribute> sortedAttributes = ((EClass)this.eObject).getEAttributes().stream().filter(this.elementPredicate).sorted(this.eNamedElementComparator).collect(Collectors.toList());
        EList sections = action.getSections();
        if (!sortedAttributes.isEmpty()) {
            Action attributeSummaryCategory = AppFactory.eINSTANCE.createAction();
            attributeSummaryCategory.setText("Attribute summary");
            attributeSummaryCategory.setName("attribute-summary");
            attributeSummaryCategory.setSectionStyle(SectionStyle.HEADER);
            sections.add((Object)attributeSummaryCategory);
            attributeSummaryCategory.getContent().add((Object)this.buildDynamicAttributesTable(sortedAttributes, progressMonitor));
        }
        if (!(sortedReferences = ((EClass)this.eObject).getEReferences().stream().filter(this.elementPredicate).sorted(this.eNamedElementComparator).collect(Collectors.toList())).isEmpty()) {
            Action referenceSummaryCategory = AppFactory.eINSTANCE.createAction();
            referenceSummaryCategory.setText("Reference summary");
            referenceSummaryCategory.setName("reference-summary");
            referenceSummaryCategory.setSectionStyle(SectionStyle.HEADER);
            sections.add((Object)referenceSummaryCategory);
            referenceSummaryCategory.getContent().add((Object)this.buildDynamicReferencesTable(sortedReferences, progressMonitor));
        }
        if (!sortedAttributes.isEmpty()) {
            Action attributeDetailsCategory = AppFactory.eINSTANCE.createAction();
            attributeDetailsCategory.setText("Attribute details");
            attributeDetailsCategory.setName("attribute-details");
            attributeDetailsCategory.setSectionStyle(SectionStyle.HEADER);
            sections.add((Object)attributeDetailsCategory);
            EList attributes = attributeDetailsCategory.getSections();
            for (EStructuralFeature eStructuralFeature : sortedAttributes) {
                attributes.add((Object)((Action)this.adaptChild((EObject)eStructuralFeature).execute(null, progressMonitor)));
            }
        }
        if (!sortedReferences.isEmpty()) {
            Action referenceDetailsCategory = AppFactory.eINSTANCE.createAction();
            referenceDetailsCategory.setText("Reference details");
            referenceDetailsCategory.setName("reference-details");
            referenceDetailsCategory.setSectionStyle(SectionStyle.HEADER);
            sections.add((Object)referenceDetailsCategory);
            EList references = referenceDetailsCategory.getSections();
            for (EStructuralFeature eStructuralFeature : sortedReferences) {
                references.add((Object)((Action)this.adaptChild((EObject)eStructuralFeature).execute(null, progressMonitor)));
            }
        }
        if (!(sortedOperations = ((EClass)this.eObject).getEOperations().stream().filter(this.elementPredicate).sorted(this.eNamedElementComparator).collect(Collectors.toList())).isEmpty()) {
            Action operationsCategory = AppFactory.eINSTANCE.createAction();
            operationsCategory.setText("Operations");
            operationsCategory.setName("operations");
            operationsCategory.setSectionStyle(SectionStyle.HEADER);
            sections.add((Object)operationsCategory);
            EList operations = operationsCategory.getSections();
            for (EOperation eOp : sortedOperations) {
                operations.add((Object)((Action)this.adaptChild((EObject)eOp).execute(null, progressMonitor)));
            }
        }
        if (((EClass)this.eObject).isInterface()) {
            action.setIcon("https://www.nasdanika.org/resources/images/ecore/EInterface.gif");
        }
        return action;
    }

    private void generateAllGenericSupertypes(List<EGenericType> allGenericSupertypes, Action allGroup, ProgressMonitor progressMonitor) {
        String inheritanceDiagram;
        if (!allGenericSupertypes.isEmpty() && !Util.isBlank((String)(inheritanceDiagram = this.generateInheritanceDiagram(0, DiagramTextGenerator.RelationshipDirection.both, true, true, progressMonitor)))) {
            Action allSupertypesAction = AppFactory.eINSTANCE.createAction();
            allSupertypesAction.setText("Supertypes");
            allSupertypesAction.setLocation(((EClass)this.eObject).getName() + "-all-supertypes.html");
            allSupertypesAction.setSectionStyle(SectionStyle.HEADER);
            allGroup.getChildren().add((Object)allSupertypesAction);
            Tag list = TagName.ul.create(new Object[0]);
            for (EGenericType superType : allGenericSupertypes) {
                Tag listItem = TagName.li.create(new Object[0]);
                list.content(new Object[]{listItem});
                this.genericType(superType, (EClassifier)this.eObject, listItem.getContent()::add, progressMonitor);
            }
            EClassActionSupplier.addContent(allSupertypesAction, list.toString());
            EClassActionSupplier.addContent(allSupertypesAction, inheritanceDiagram);
        }
    }

    protected String generateInheritanceDiagram(int depth, DiagramTextGenerator.RelationshipDirection relationshipDirection, boolean appendAttributes, boolean appendOperations, ProgressMonitor monitor) {
        StringBuilder sb = new StringBuilder();
        DiagramTextGenerator gen = this.getDiagramTextGenerator(sb, appendAttributes, appendOperations);
        if (gen == null) {
            return null;
        }
        ArrayList<EClass> diagramElements = new ArrayList<EClass>();
        diagramElements.add((EClass)this.eObject);
        diagramElements.addAll((Collection<EClass>)((EClass)this.eObject).getEAllSuperTypes());
        gen.appendWithRelationships(diagramElements, relationshipDirection, depth);
        return ((DiagramGenerator)this.context.get(DiagramGenerator.class)).generateUmlDiagram(sb.toString());
    }

    private void generateAllOperations(List<EOperation> allOperations, Action allGroup, ProgressMonitor progressMonitor) {
        if (!allOperations.isEmpty()) {
            Action allOperationsAction = AppFactory.eINSTANCE.createAction();
            allOperationsAction.setText("Operations");
            allOperationsAction.setLocation(((EClass)this.eObject).getName() + "-all-operations.html");
            allOperationsAction.setSectionStyle(SectionStyle.HEADER);
            allGroup.getChildren().add((Object)allOperationsAction);
            EList operations = allOperationsAction.getSections();
            for (EOperation eOp : allOperations) {
                operations.add((Object)((Action)this.adaptChild((EObject)eOp).execute((EClass)this.eObject, progressMonitor)));
            }
        }
    }

    private void generateAllReferences(List<EReference> allReferences, Action allGroup, ProgressMonitor progressMonitor) {
        if (!allReferences.isEmpty()) {
            Action allReferencesAction = AppFactory.eINSTANCE.createAction();
            allReferencesAction.setText("References");
            allReferencesAction.setLocation(((EClass)this.eObject).getName() + "-all-references.html");
            allReferencesAction.setSectionStyle(SectionStyle.HEADER);
            allGroup.getChildren().add((Object)allReferencesAction);
            allReferencesAction.getContent().add((Object)this.buildDynamicReferencesTable(allReferences, progressMonitor));
        }
    }

    private void generateAllAttributes(List<EAttribute> allAttributes, Action allGroup, ProgressMonitor progressMonitor) {
        if (!allAttributes.isEmpty()) {
            Action allAttributesAction = AppFactory.eINSTANCE.createAction();
            allAttributesAction.setText("Attributes");
            allAttributesAction.setLocation(((EClass)this.eObject).getName() + "-all-attributes.html");
            allAttributesAction.setSectionStyle(SectionStyle.HEADER);
            allGroup.getChildren().add((Object)allAttributesAction);
            allAttributesAction.getContent().add((Object)this.buildDynamicAttributesTable(allAttributes, progressMonitor));
        }
    }

    protected org.nasdanika.html.model.html.Tag buildDynamicAttributesTable(List<EAttribute> attributes, ProgressMonitor progressMonitor) {
        DynamicTableBuilder attributesTableBuilder = new DynamicTableBuilder(new DynamicTableBuilder.ColumnBuilder[0]);
        attributesTableBuilder.addStringColumnBuilder("name", true, true, "Name", attr -> this.link((EStructuralFeature)attr, (EClassifier)this.eObject)).addStringColumnBuilder("type", true, true, "Type", attr -> {
            EGenericType genericType = attr.getEGenericType();
            if (genericType == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            this.genericType(genericType, (EClassifier)this.eObject, sb::append, progressMonitor);
            return sb.toString();
        }).addStringColumnBuilder("cardinality", true, true, "Cardinality", EModelElementActionSupplier::cardinality).addBooleanColumnBuilder("changeable", true, true, "Changeable", EStructuralFeature::isChangeable).addBooleanColumnBuilder("derived", true, true, "Derived", EStructuralFeature::isDerived).addStringColumnBuilder("declaring-class", true, true, "Declaring Class", attr -> this.link((EClassifier)attr.getEContainingClass(), (EClassifier)this.eObject)).addStringColumnBuilder("description", true, false, "Description", this::getEModelElementFirstDocSentence);
        org.nasdanika.html.model.html.Tag attributesTable = attributesTableBuilder.build(attributes, ((EClass)this.eObject).getEPackage().getNsURI().hashCode() + "-" + ((EClass)this.eObject).getName() + "-attributes", "attributes-table", progressMonitor);
        return attributesTable;
    }

    protected org.nasdanika.html.model.html.Tag buildDynamicReferencesTable(List<EReference> references, ProgressMonitor progressMonitor) {
        DynamicTableBuilder referencesTableBuilder = new DynamicTableBuilder(new DynamicTableBuilder.ColumnBuilder[0]);
        referencesTableBuilder.addStringColumnBuilder("name", true, true, "Name", ref -> this.link((EStructuralFeature)ref, (EClassifier)this.eObject)).addStringColumnBuilder("type", true, true, "Type", ref -> {
            EGenericType genericType = ref.getEGenericType();
            if (genericType == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            this.genericType(genericType, (EClassifier)this.eObject, sb::append, progressMonitor);
            return sb.toString();
        }).addStringColumnBuilder("cardinality", true, true, "Cardinality", EModelElementActionSupplier::cardinality).addBooleanColumnBuilder("changeable", true, true, "Changeable", EStructuralFeature::isChangeable).addBooleanColumnBuilder("derived", true, true, "Derived", EStructuralFeature::isDerived).addStringColumnBuilder("declaring-class", true, true, "Declaring Class", ref -> this.link((EClassifier)ref.getEContainingClass(), (EClassifier)this.eObject)).addStringColumnBuilder("opposite", true, true, "Opposite", ref -> {
            EReference opposite = NcoreUtil.getOpposite((EReference)ref);
            return opposite == null ? null : this.link((EStructuralFeature)opposite, (EClassifier)this.eObject);
        }).addStringColumnBuilder("description", true, false, "Description", this::getEModelElementFirstDocSentence);
        org.nasdanika.html.model.html.Tag referencesTable = referencesTableBuilder.build(references, ((EClass)this.eObject).getEPackage().getNsURI().hashCode() + "-" + ((EClass)this.eObject).getName() + "-references", "references-table", progressMonitor);
        return referencesTable;
    }

    private void generateLoadSpecification(Action action, Comparator<ENamedElement> namedElementComparator, ProgressMonitor progressMonitor) {
        if (!((EClass)this.eObject).isAbstract() && "true".equals(NcoreUtil.getNasdanikaAnnotationDetail((EModelElement)((EModelElement)this.eObject), (String)"loadable", (String)"true"))) {
            Action loadSpecificationAction = AppFactory.eINSTANCE.createAction();
            loadSpecificationAction.setText("Load specification");
            loadSpecificationAction.setLocation(((EClass)this.eObject).getName() + "-load-specification.html");
            action.getNavigation().add((Object)loadSpecificationAction);
            EmfUtil.EModelElementDocumentation loadDoc = EmfUtil.getLoadDocumentation((EModelElement)((EModelElement)this.eObject));
            if (loadDoc != null) {
                loadSpecificationAction.getContent().add((Object)this.interpolatedMarkdown(loadDoc.getDocumentation(), loadDoc.getLocation(), progressMonitor));
            }
            Predicate<EStructuralFeature> predicate = sf -> sf.isChangeable() && "true".equals(NcoreUtil.getNasdanikaAnnotationDetail((EModelElement)sf, (String)"loadable", (String)"true"));
            List sortedFeatures = ((EClass)this.eObject).getEAllStructuralFeatures().stream().filter(predicate.and(this.elementPredicate)).sorted(namedElementComparator).collect(Collectors.toList());
            Function<EStructuralFeature, String> keyExtractor = sf -> NcoreUtil.getNasdanikaAnnotationDetail((EModelElement)sf, (String)"load-key", (String)NcoreUtil.getFeatureKey((EClass)((EClass)this.eObject), (EStructuralFeature)sf));
            Predicate<EStructuralFeature> homogenousPredicate = sf -> "true".equals(NcoreUtil.getNasdanikaAnnotationDetail((EModelElement)sf, (String)"homogenous")) || NcoreUtil.getNasdanikaAnnotationDetail((EModelElement)sf, (String)"reference-type") != null;
            Predicate<EStructuralFeature> strictContainmentPredicate = homogenousPredicate.and(sf -> "true".equals(NcoreUtil.getNasdanikaAnnotationDetail((EModelElement)sf, (String)"strict-containment")));
            Function<EStructuralFeature, Object[]> exclusiveWithExtractor = sf -> EObjectLoader.getExclusiveWith((EClass)((EClass)this.eObject), (EStructuralFeature)sf, (BiFunction)EObjectLoader.LOAD_KEY_PROVIDER);
            DynamicTableBuilder loadSpecificationTableBuilder = new DynamicTableBuilder(new DynamicTableBuilder.ColumnBuilder[0]);
            loadSpecificationTableBuilder.addStringColumnBuilder("key", true, true, "Key", sf -> {
                String key = (String)keyExtractor.apply((EStructuralFeature)sf);
                return ((Tag)((Tag)TagName.a.create(new Object[]{key}).attribute("href", (Object)("#key-section-" + key))).attribute("style", (Object)"font-weight:bold", EObjectLoader.isDefaultFeature((EClass)((EClass)this.eObject), (EStructuralFeature)sf))).toString();
            }).addStringColumnBuilder("type", true, true, "Type", attr -> {
                EGenericType genericType = attr.getEGenericType();
                if (genericType == null) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                this.genericType(genericType, (EClassifier)this.eObject, sb::append, progressMonitor);
                return sb.toString();
            }).addStringColumnBuilder("cardinality", true, false, "Cardinality", EModelElementActionSupplier::cardinality).addBooleanColumnBuilder("homogenous", true, false, "Homogenous", homogenousPredicate).addBooleanColumnBuilder("strict-containment", true, false, "Strict Containment", strictContainmentPredicate).addStringColumnBuilder("exclusive-with", true, false, "Exclusive With", sf -> {
                Object[] exclusiveWith = (Object[])exclusiveWithExtractor.apply((EStructuralFeature)sf);
                if (exclusiveWith.length == 0) {
                    return null;
                }
                Tag ul = TagName.ul.create(new Object[0]);
                for (Object exw : exclusiveWith) {
                    ul.content(new Object[]{TagName.li.create(new Object[]{exw})});
                }
                return ul.toString();
            }).addStringColumnBuilder("description", true, false, "Description", this::getEStructuralFeatureFirstLoadDocSentence);
            org.nasdanika.html.model.html.Tag loadSpecificationTable = loadSpecificationTableBuilder.build(sortedFeatures, ((EClass)this.eObject).getEPackage().getNsURI().hashCode() + "-" + ((EClass)this.eObject).getName() + "-load-specification", "load-specification-table", progressMonitor);
            for (EStructuralFeature sf2 : sortedFeatures) {
                Object[] exclusiveWith;
                boolean isStrictContainment;
                boolean isHomogenous;
                Action featureAction = AppFactory.eINSTANCE.createAction();
                String key = keyExtractor.apply(sf2);
                featureAction.setText(key);
                String sectionAnchor = "key-section-" + key;
                featureAction.setName(sectionAnchor);
                loadSpecificationAction.getSections().add((Object)featureAction);
                org.nasdanika.html.bootstrap.Table table = ((BootstrapFactory)this.context.get(BootstrapFactory.class)).table();
                ((Table)table.toHTMLElement()).style().width((Object)"auto");
                this.genericType(sf2.getEGenericType(), (EClassifier)this.eObject, ETypedElementActionSupplier.addRow(table, "Type")::add, progressMonitor);
                boolean isDefaultFeature = EObjectLoader.isDefaultFeature((EClass)((EClass)this.eObject), (EStructuralFeature)sf2);
                if (isDefaultFeature) {
                    ETypedElementActionSupplier.addRow(table, "Default").add("true");
                }
                if (isHomogenous = homogenousPredicate.test(sf2)) {
                    ETypedElementActionSupplier.addRow(table, "Homogenous").add("true");
                }
                if (isStrictContainment = strictContainmentPredicate.test(sf2)) {
                    ETypedElementActionSupplier.addRow(table, "Strict containment").add("true");
                }
                if ((exclusiveWith = exclusiveWithExtractor.apply(sf2)).length != 0) {
                    Tag ul = TagName.ul.create(new Object[0]);
                    for (Object exw : exclusiveWith) {
                        ul.content(new Object[]{TagName.li.create(new Object[]{exw})});
                    }
                    ETypedElementActionSupplier.addRow(table, "Exclusive with").add(ul);
                }
                EClassActionSupplier.addContent(featureAction, table.toString());
                EmfUtil.EModelElementDocumentation featureLoadDoc = this.getFeatureLoadDoc(sf2);
                if (featureLoadDoc == null) continue;
                featureAction.getContent().add((Object)this.interpolatedMarkdown(this.context.interpolateToString(featureLoadDoc.getDocumentation()), featureLoadDoc.getLocation(), progressMonitor));
            }
            loadSpecificationAction.getContent().add((Object)loadSpecificationTable);
        }
    }

    protected EmfUtil.EModelElementDocumentation getFeatureLoadDoc(EStructuralFeature sf) {
        EmfUtil.EModelElementDocumentation featureLoadDoc = EmfUtil.getLoadDocumentation((EModelElement)sf);
        return featureLoadDoc == null ? EmfUtil.getDocumentation((EModelElement)sf) : featureLoadDoc;
    }

    protected String getEStructuralFeatureFirstLoadDocSentence(EStructuralFeature sf) {
        final EmfUtil.EModelElementDocumentation documentation = this.getFeatureLoadDoc(sf);
        if (documentation == null) {
            return null;
        }
        MarkdownHelper markdownHelper = new MarkdownHelper(){

            protected URI getResourceBase() {
                return documentation.getLocation();
            }

            protected DiagramGenerator getDiagramGenerator() {
                return EClassActionSupplier.this.context == null ? super.getDiagramGenerator() : (DiagramGenerator)EClassActionSupplier.this.context.get(DiagramGenerator.class, (Object)super.getDiagramGenerator());
            }
        };
        String ret = markdownHelper.firstPlainTextSentence(documentation.getDocumentation());
        return String.join((CharSequence)" ", ret.split("\\R"));
    }

    protected DiagramTextGenerator getDiagramTextGenerator(StringBuilder sb, final boolean appendAttributes, final boolean appendOperations) {
        String dialect = this.diagramDialectSupplier.get();
        if (Util.isBlank((String)dialect)) {
            return null;
        }
        switch (dialect) {
            case "uml": {
                return new PlantUmlTextGenerator(sb, this.elementPredicate, ec -> this.path((EClassifier)ec, (EClassifier)this.eObject), this::getEModelElementFirstDocSentence, this.labelProvider){

                    protected Collection<EClass> getSubTypes(EClass eClass) {
                        return EClassActionSupplier.this.getSubTypes(eClass);
                    }

                    protected Collection<EClass> getReferrers(EClass eClass) {
                        return EClassActionSupplier.this.getReferrers(eClass);
                    }

                    protected Collection<EClass> getUses(EClassifier eClassifier) {
                        return EClassActionSupplier.this.getUses(eClassifier);
                    }

                    protected boolean isAppendAttributes(EClass eClass) {
                        return appendAttributes;
                    }

                    protected boolean isAppendOperations(EClass eClass) {
                        return appendOperations;
                    }

                    protected String qualifiedName(EClassifier eClassifier) {
                        Class<?> ic = EModelElementActionSupplier.getInstanceClass(eClassifier, EClassActionSupplier.this.ePackageResolver);
                        return ic == null ? super.qualifiedName(eClassifier) : ic.getName();
                    }
                };
            }
            case "mermaid": {
                return new MermaidTextGenerator(sb, this.elementPredicate, ec -> this.path((EClassifier)ec, (EClassifier)this.eObject), this::getEModelElementFirstDocSentence){

                    protected Collection<EClass> getSubTypes(EClass eClass) {
                        return EClassActionSupplier.this.getSubTypes(eClass);
                    }

                    protected Collection<EClass> getReferrers(EClass eClass) {
                        return EClassActionSupplier.this.getReferrers(eClass);
                    }

                    protected Collection<EClass> getUses(EClassifier eClassifier) {
                        return EClassActionSupplier.this.getUses(eClassifier);
                    }

                    protected boolean isAppendAttributes(EClass eClass) {
                        return appendAttributes;
                    }

                    protected boolean isAppendOperations(EClass eClass) {
                        return appendOperations;
                    }
                };
            }
        }
        throw new UnsupportedOperationException("Unsupported dialect: " + dialect);
    }

    protected String generateDiagram(int depth, DiagramTextGenerator.RelationshipDirection relationshipDirection, boolean appendAttributes, boolean appendOperations, ProgressMonitor monitor) {
        DiagramGenerator diagramGenerator = (DiagramGenerator)this.context.get(DiagramGenerator.class);
        StringBuilder sb = new StringBuilder();
        DiagramTextGenerator gen = this.getDiagramTextGenerator(sb, appendAttributes, appendOperations);
        if (gen == null) {
            return null;
        }
        gen.appendWithRelationships(Collections.singleton((EClass)this.eObject), relationshipDirection, depth);
        return diagramGenerator.generateUmlDiagram(sb.toString());
    }

    protected Collection<EClass> getSubTypes(EClass eClass) {
        TreeIterator acit;
        Resource eResource = eClass.eResource();
        if (eResource == null) {
            EPackage ePackage = eClass.getEPackage();
            if (ePackage == null) {
                return Collections.emptySet();
            }
            acit = ePackage.eAllContents();
        } else {
            ResourceSet resourceSet = eResource.getResourceSet();
            acit = resourceSet == null ? eResource.getAllContents() : resourceSet.getAllContents();
        }
        HashSet<EClass> ret = new HashSet<EClass>();
        acit.forEachRemaining(obj -> {
            if (obj instanceof EClass && ((EClass)obj).getESuperTypes().contains((Object)eClass)) {
                ret.add((EClass)obj);
            }
        });
        return ret;
    }

    protected Collection<EClass> getReferrers() {
        return this.getReferrers((EClass)this.eObject);
    }
}

