/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.ecore;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.codec.binary.Hex;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.nasdanika.common.Context;
import org.nasdanika.common.NasdanikaException;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.html.Fragment;
import org.nasdanika.html.HTMLFactory;
import org.nasdanika.html.Tag;
import org.nasdanika.html.TagName;
import org.nasdanika.html.bootstrap.Table;
import org.nasdanika.html.ecore.ETypedElementActionSupplier;
import org.nasdanika.html.ecore.EcoreActionSupplier;
import org.nasdanika.html.model.app.Action;
import org.nasdanika.html.model.app.AppFactory;
import org.nasdanika.html.model.app.SectionStyle;

public class EOperationActionSupplier
extends ETypedElementActionSupplier<EOperation>
implements EcoreActionSupplier {
    public EOperationActionSupplier(EOperation value, Context context, Function<EPackage, String> ePackagePathComputer, Predicate<EModelElement> elementPredicate, BiFunction<ENamedElement, String, String> labelProvider) {
        super(value, context, ePackagePathComputer, elementPredicate, labelProvider);
    }

    @Override
    public Action execute(EClass contextEClass, ProgressMonitor progressMonitor) {
        try {
            Action action = super.execute(contextEClass, progressMonitor);
            action.setSectionStyle(SectionStyle.HEADER);
            EClass eContainingClass = ((EOperation)this.eObject).getEContainingClass();
            EList sections = action.getSections();
            if (!((EOperation)this.eObject).getEParameters().isEmpty()) {
                Action parametersCategory = AppFactory.eINSTANCE.createAction();
                parametersCategory.setText("Parameters");
                sections.add((Object)parametersCategory);
                EList parameters = parametersCategory.getSections();
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                for (EParameter ep : ((EOperation)this.eObject).getEParameters()) {
                    EClassifier type = ep.getEType();
                    String typeStr = type.eClass().getName() + "-" + this.encodeEPackage(type.getEPackage()) + "-" + type.getName() + ",";
                    md.update(typeStr.getBytes(StandardCharsets.UTF_8));
                    parameters.add((Object)((Action)this.adaptChild((EObject)ep).execute(contextEClass, progressMonitor)));
                }
            }
            String signature = EOperationActionSupplier.eOperationSignature((EOperation)this.eObject, this::encodeEPackage);
            StringBuilder idBuilder = new StringBuilder(this.encodeEPackage(eContainingClass.getEPackage())).append("-").append(eContainingClass.getName()).append("-").append(signature);
            action.setId(idBuilder.toString());
            action.setName(signature);
            EList eGenericExceptions = ((EOperation)this.eObject).getEGenericExceptions();
            if (!eGenericExceptions.isEmpty()) {
                HTMLFactory htmlFactory = (HTMLFactory)this.context.get(HTMLFactory.class);
                Fragment gstf = htmlFactory.fragment(new Object[]{TagName.h3.create(new Object[]{"Exceptions"})});
                Tag list = TagName.ul.create(new Object[0]);
                gstf.content(new Object[]{list});
                for (EGenericType genericException : eGenericExceptions) {
                    Tag listItem = TagName.li.create(new Object[0]);
                    list.content(new Object[]{listItem});
                    this.genericType(genericException, (EClassifier)contextEClass, listItem.getContent()::add, progressMonitor);
                }
                EOperationActionSupplier.addContent(action, gstf.toString());
            }
            return action;
        }
        catch (NoSuchAlgorithmException e) {
            throw new NasdanikaException((Throwable)e);
        }
    }

    public static String eOperationSignature(EOperation eOperation, Function<EPackage, String> ePackageEncoder) throws NoSuchAlgorithmException {
        StringBuilder signatureBuilder = new StringBuilder(eOperation.eClass().getName()).append("-").append(eOperation.getName());
        if (!eOperation.getEParameters().isEmpty()) {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            for (EParameter ep : eOperation.getEParameters()) {
                EClassifier type = ep.getEType();
                String typeStr = type.eClass().getName() + "-" + ePackageEncoder.apply(type.getEPackage()) + "-" + type.getName() + ",";
                md.update(typeStr.getBytes(StandardCharsets.UTF_8));
            }
            signatureBuilder.append("-").append(Hex.encodeHexString((byte[])md.digest()));
        }
        return signatureBuilder.toString();
    }

    @Override
    protected Table propertiesTable(EClass contextEClass, ProgressMonitor monitor) {
        Table table = super.propertiesTable(contextEClass, monitor);
        if (contextEClass != null) {
            EOperationActionSupplier.addRow(table, "Declaring class").add(this.link((EClassifier)((EOperation)this.eObject).getEContainingClass(), (EClassifier)contextEClass));
        }
        return table;
    }
}

