/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.ecore;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.nasdanika.common.Context;
import org.nasdanika.common.DiagramGenerator;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.common.Util;
import org.nasdanika.emf.DiagramTextGenerator;
import org.nasdanika.emf.MermaidTextGenerator;
import org.nasdanika.emf.PlantUmlTextGenerator;
import org.nasdanika.exec.content.ContentFactory;
import org.nasdanika.exec.content.Text;
import org.nasdanika.html.ecore.ENamedElementActionSupplier;
import org.nasdanika.html.model.app.Action;
import org.nasdanika.html.model.app.AppFactory;
import org.nasdanika.ncore.util.NcoreUtil;

public class EPackageActionSupplier
extends ENamedElementActionSupplier<EPackage> {
    private Supplier<String> diagramDialectSupplier;
    protected Function<EClassifier, String> eClassifierLinkResolver = target -> {
        String localName = target.getName() + ".html";
        if (target.getEPackage().getNsURI().equals(((EPackage)this.eObject).getNsURI())) {
            return localName;
        }
        StringBuilder pathUp = new StringBuilder();
        for (EPackage p = (EPackage)this.eObject; p != null; p = p.getESuperPackage()) {
            pathUp.append("../");
        }
        return pathUp + this.encodeEPackage(target.getEPackage()) + "/" + localName;
    };

    public EPackageActionSupplier(EPackage value, Context context, Function<EPackage, String> ePackagePathComputer, Supplier<String> diagramDialectSupplier) {
        super(value, context, ePackagePathComputer);
        this.diagramDialectSupplier = diagramDialectSupplier;
    }

    @Override
    protected void header(Action action, ProgressMonitor progressMonitor) throws Exception {
        Text text = ContentFactory.eINSTANCE.createText();
        text.setContent("<div class='text-monospace'>" + ((EPackage)this.eObject).getNsURI() + "</div>");
        action.getContent().add((Object)text);
    }

    @Override
    public Action execute(EClass contextEClass, ProgressMonitor progressMonitor) throws Exception {
        Action action = super.execute(contextEClass, progressMonitor);
        String ePackageFolder = this.ePackagePathComputer == null ? Hex.encodeHexString((byte[])((EPackage)this.eObject).getNsURI().getBytes(StandardCharsets.UTF_8)) : (String)this.ePackagePathComputer.apply((EPackage)this.eObject);
        action.setLocation(ePackageFolder + "/package-summary.html");
        action.setId(((EPackage)this.eObject).eClass().getName() + "-" + this.encodeEPackage((EPackage)this.eObject));
        String diagramMode = NcoreUtil.getNasdanikaAnnotationDetail((EModelElement)((EModelElement)this.eObject), (String)"diagram", (String)"navigation");
        String diagram = this.generateDiagram(0, DiagramTextGenerator.RelationshipDirection.both, true, true);
        if (!Util.isBlank((String)diagram)) {
            switch (diagramMode) {
                case "content": {
                    EPackageActionSupplier.addContent(action, diagram);
                    break;
                }
                case "none": {
                    break;
                }
                case "navigation": {
                    Action diagramAction = AppFactory.eINSTANCE.createAction();
                    action.getNavigation().add((Object)diagramAction);
                    diagramAction.setText("Diagram");
                    diagramAction.setIcon("fas fa-project-diagram");
                    diagramAction.setLocation("package-summary-diagram.html");
                    EPackageActionSupplier.addContent(diagramAction, diagram);
                    break;
                }
                case "anonymous": {
                    Action diagramAction = AppFactory.eINSTANCE.createAction();
                    action.getAnonymous().add((Object)diagramAction);
                    diagramAction.setText("Diagram");
                    diagramAction.setIcon("fas fa-project-diagram");
                    diagramAction.setLocation(ePackageFolder + "/package-summary-diagram.html");
                    EPackageActionSupplier.addContent(diagramAction, diagram);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported diagram annotation value '" + diagramMode + "' on EPackage " + this.eObject);
                }
            }
        }
        EList children = action.getChildren();
        for (EPackage subPackage : ((EPackage)this.eObject).getESubpackages().stream().sorted((a, b) -> a.getName().compareTo(b.getName())).collect(Collectors.toList())) {
            children.add((Object)((EObject)this.adaptChild((EObject)subPackage).execute(contextEClass, progressMonitor)));
        }
        for (EClassifier eClassifier : ((EPackage)this.eObject).getEClassifiers().stream().sorted((a, b) -> a.getName().compareTo(b.getName())).collect(Collectors.toList())) {
            children.add((Object)((EObject)this.adaptChild((EObject)eClassifier).execute(contextEClass, progressMonitor)));
        }
        return action;
    }

    protected DiagramTextGenerator getDiagramTextGenerator(StringBuilder sb, final boolean appendAttributes, final boolean appendOperations) {
        String dialect = this.diagramDialectSupplier.get();
        if (Util.isBlank((String)dialect)) {
            return null;
        }
        switch (dialect) {
            case "uml": {
                return new PlantUmlTextGenerator(sb, this.eClassifierLinkResolver, this::getEModelElementFirstDocSentence){

                    protected Collection<EClass> getSubTypes(EClass eClass) {
                        return EPackageActionSupplier.this.getSubTypes(eClass);
                    }

                    protected Collection<EClass> getReferrers(EClass eClass) {
                        return EPackageActionSupplier.this.getReferrers(eClass);
                    }

                    protected boolean isAppendAttributes(EClass eClass) {
                        return appendAttributes;
                    }

                    protected boolean isAppendOperations(EClass eClass) {
                        return appendOperations;
                    }

                    protected Collection<EClass> getUses(EClassifier eClassifier) {
                        return Collections.emptySet();
                    }
                };
            }
            case "mermaid": {
                return new MermaidTextGenerator(sb, this.eClassifierLinkResolver, this::getEModelElementFirstDocSentence){

                    protected Collection<EClass> getSubTypes(EClass eClass) {
                        return EPackageActionSupplier.this.getSubTypes(eClass);
                    }

                    protected Collection<EClass> getReferrers(EClass eClass) {
                        return EPackageActionSupplier.this.getReferrers(eClass);
                    }

                    protected boolean isAppendAttributes(EClass eClass) {
                        return appendAttributes;
                    }

                    protected boolean isAppendOperations(EClass eClass) {
                        return appendOperations;
                    }

                    protected Collection<EClass> getUses(EClassifier eClassifier) {
                        return Collections.emptySet();
                    }
                };
            }
        }
        throw new UnsupportedOperationException("Unsupported dialect: " + dialect);
    }

    protected String generateDiagram(int depth, DiagramTextGenerator.RelationshipDirection relationshipDirection, boolean appendAttributes, boolean appendOperations) throws Exception {
        StringBuilder sb = new StringBuilder();
        DiagramTextGenerator gen = this.getDiagramTextGenerator(sb, appendAttributes, appendOperations);
        if (gen == null) {
            return null;
        }
        gen.appendWithRelationships((Collection)((EPackage)this.eObject).getEClassifiers(), relationshipDirection, depth);
        return ((DiagramGenerator)this.context.get(DiagramGenerator.class)).generateUmlDiagram(sb.toString());
    }

    protected Collection<EClass> getSubTypes(EClass eClass) {
        ArrayList<EClass> ret = new ArrayList<EClass>();
        for (EClassifier ec : ((EPackage)this.eObject).getEClassifiers()) {
            if (eClass == ec || !(ec instanceof EClass) || !eClass.isSuperTypeOf((EClass)ec)) continue;
            ret.add((EClass)ec);
        }
        return ret;
    }
}

