/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.ecore;

import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.nasdanika.common.Context;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.html.Tag;
import org.nasdanika.html.TagName;
import org.nasdanika.html.ecore.EClassifierActionSupplier;
import org.nasdanika.html.model.app.Action;
import org.nasdanika.html.model.app.AppFactory;
import org.nasdanika.html.model.app.SectionStyle;

public class EEnumActionSupplier
extends EClassifierActionSupplier<EEnum> {
    public EEnumActionSupplier(EEnum value, Context context, Function<EPackage, String> ePackagePathComputer, Function<String, String> javadocResolver) {
        super(value, context, ePackagePathComputer, javadocResolver);
    }

    @Override
    public Action execute(EClass contextEClass, ProgressMonitor progressMonitor) throws Exception {
        Action action = super.execute(contextEClass, progressMonitor);
        action.setSectionStyle(SectionStyle.HEADER);
        EList sections = action.getSections();
        sections.add((Object)this.createLiteralsAction(contextEClass, progressMonitor));
        Action usesAction = this.createUsesAction(contextEClass, progressMonitor);
        if (usesAction != null) {
            sections.add((Object)usesAction);
        }
        return action;
    }

    protected Action createLiteralsAction(EClass contextEClass, ProgressMonitor progressMonitor) throws Exception {
        Action literalsAction = AppFactory.eINSTANCE.createAction();
        literalsAction.setText("Literals");
        literalsAction.setSectionStyle(SectionStyle.TABLE);
        EList literals = literalsAction.getSections();
        for (EEnumLiteral literal : ((EEnum)this.eObject).getELiterals()) {
            literals.add((Object)((Action)this.adaptChild((EObject)literal).execute(contextEClass, progressMonitor)));
        }
        return literalsAction;
    }

    protected Action createUsesAction(EClass contextEClass, ProgressMonitor progressMonitor) throws Exception {
        Collection uses = this.getUses().stream().sorted((a, b) -> a.getName().compareTo(b.getName())).collect(Collectors.toList());
        if (uses.isEmpty()) {
            return null;
        }
        Action usesAction = AppFactory.eINSTANCE.createAction();
        usesAction.setText("Uses");
        Tag list = TagName.ul.create(new Object[0]);
        for (EClass use : uses) {
            list.content(new Object[]{TagName.li.create(new Object[]{this.link((EClassifier)use, (EClassifier)contextEClass)})});
        }
        EEnumActionSupplier.addContent(usesAction, list.toString());
        return usesAction;
    }
}

