/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.ecore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.nasdanika.common.Context;
import org.nasdanika.common.DiagramGenerator;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.common.Util;
import org.nasdanika.emf.DiagramTextGenerator;
import org.nasdanika.emf.EmfUtil;
import org.nasdanika.emf.MermaidTextGenerator;
import org.nasdanika.emf.PlantUmlTextGenerator;
import org.nasdanika.emf.persistence.EObjectLoader;
import org.nasdanika.html.Fragment;
import org.nasdanika.html.HTMLFactory;
import org.nasdanika.html.Table;
import org.nasdanika.html.Tag;
import org.nasdanika.html.TagName;
import org.nasdanika.html.bootstrap.BootstrapFactory;
import org.nasdanika.html.ecore.EClassifierActionSupplier;
import org.nasdanika.html.ecore.ETypedElementActionSupplier;
import org.nasdanika.html.model.app.Action;
import org.nasdanika.html.model.app.AppFactory;
import org.nasdanika.html.model.app.SectionStyle;
import org.nasdanika.ncore.util.NcoreUtil;

public class EClassActionSupplier
extends EClassifierActionSupplier<EClass> {
    private BooleanSupplier isGenerateLoadSpecification;
    private Supplier<String> diagramDialectSupplier;

    public EClassActionSupplier(EClass value, Context context, Function<EPackage, String> ePackagePathComputer, Function<String, String> javadocResolver, BooleanSupplier isGenerateLoadSpecification, Supplier<String> diagramDialectSupplier) {
        super(value, context, ePackagePathComputer, javadocResolver);
        this.isGenerateLoadSpecification = isGenerateLoadSpecification;
        this.diagramDialectSupplier = diagramDialectSupplier;
    }

    @Override
    public Action execute(EClass contextEClass, ProgressMonitor progressMonitor) throws Exception {
        Collection uses;
        Collection referrers;
        Collection eSubTypes;
        EList eGenericSuperTypes;
        Action action = super.execute(contextEClass, progressMonitor);
        action.setSectionStyle(SectionStyle.HEADER);
        String diagramMode = NcoreUtil.getNasdanikaAnnotationDetail((EModelElement)((EModelElement)this.eObject), (String)"diagram", (String)"navigation");
        String diagram = this.generateDiagram(1, DiagramTextGenerator.RelationshipDirection.both, true, true, progressMonitor);
        if (!Util.isBlank((String)diagram)) {
            switch (diagramMode) {
                case "content": {
                    EClassActionSupplier.addContent(action, diagram);
                    break;
                }
                case "none": {
                    break;
                }
                case "navigation": {
                    Action diagramAction = AppFactory.eINSTANCE.createAction();
                    action.getNavigation().add((Object)diagramAction);
                    diagramAction.setText("Diagram");
                    diagramAction.setIcon("fas fa-project-diagram");
                    diagramAction.setLocation(((EClass)this.eObject).getName() + "-diagram.html");
                    EClassActionSupplier.addContent(diagramAction, diagram);
                    break;
                }
                case "anonymous": {
                    Action diagramAction = AppFactory.eINSTANCE.createAction();
                    action.getAnonymous().add((Object)diagramAction);
                    diagramAction.setText("Diagram");
                    diagramAction.setIcon("fas fa-project-diagram");
                    diagramAction.setLocation(((EClass)this.eObject).getName() + "-diagram.html");
                    EClassActionSupplier.addContent(diagramAction, diagram);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported diagram annotation value '" + diagramMode + "' on EClass " + this.eObject);
                }
            }
        }
        if (!(eGenericSuperTypes = ((EClass)this.eObject).getEGenericSuperTypes()).isEmpty()) {
            HTMLFactory htmlFactory = (HTMLFactory)this.context.get(HTMLFactory.class);
            Fragment gstf = htmlFactory.fragment(new Object[]{TagName.a.create(new Object[]{TagName.h3.create(new Object[]{"Supertypes"})}).attribute("name", (Object)"supertypes")});
            Tag list = TagName.ul.create(new Object[0]);
            gstf.content(new Object[]{list});
            for (Object superType : eGenericSuperTypes) {
                Tag listItem = TagName.li.create(new Object[0]);
                list.content(new Object[]{listItem});
                this.genericType((EGenericType)superType, (EClassifier)this.eObject, listItem.getContent(), progressMonitor);
            }
            EClassActionSupplier.addContent(action, gstf.toString());
        }
        if (!(eSubTypes = (Collection)this.getSubTypes((EClass)this.eObject).stream().sorted((a, b) -> a.getName().compareTo(b.getName())).collect(Collectors.toList())).isEmpty()) {
            HTMLFactory htmlFactory = (HTMLFactory)this.context.get(HTMLFactory.class);
            Fragment gstf = htmlFactory.fragment(new Object[]{TagName.a.create(new Object[]{TagName.h3.create(new Object[]{"Subtypes"})}).attribute("name", (Object)"subtypes")});
            Tag list = TagName.ul.create(new Object[0]);
            gstf.content(new Object[]{list});
            for (Object subType : eSubTypes) {
                list.content(new Object[]{TagName.li.create(new Object[]{this.link((EClassifier)subType, (EClassifier)this.eObject)})});
            }
            EClassActionSupplier.addContent(action, gstf.toString());
        }
        if (!(referrers = (Collection)this.getReferrers().stream().sorted((a, b) -> a.getName().compareTo(b.getName())).collect(Collectors.toList())).isEmpty()) {
            HTMLFactory htmlFactory = (HTMLFactory)this.context.get(HTMLFactory.class);
            Fragment gstf = htmlFactory.fragment(new Object[]{TagName.a.create(new Object[]{TagName.h3.create(new Object[]{"Referrers"})}).attribute("name", (Object)"referrers")});
            Tag list = TagName.ul.create(new Object[0]);
            gstf.content(new Object[]{list});
            for (Object referrer : referrers) {
                list.content(new Object[]{TagName.li.create(new Object[]{this.link((EClassifier)referrer, (EClassifier)this.eObject)})});
            }
            EClassActionSupplier.addContent(action, gstf.toString());
        }
        if (!(uses = (Collection)this.getUses().stream().sorted((a, b) -> a.getName().compareTo(b.getName())).collect(Collectors.toList())).isEmpty()) {
            HTMLFactory htmlFactory = (HTMLFactory)this.context.get(HTMLFactory.class);
            Fragment gstf = htmlFactory.fragment(new Object[]{TagName.a.create(new Object[]{TagName.h3.create(new Object[]{"Uses"})}).attribute("name", (Object)"uses")});
            Tag list = TagName.ul.create(new Object[0]);
            gstf.content(new Object[]{list});
            for (EClass use : uses) {
                list.content(new Object[]{TagName.li.create(new Object[]{this.link((EClassifier)use, (EClassifier)this.eObject)})});
            }
            EClassActionSupplier.addContent(action, gstf.toString());
        }
        Comparator namedElementComparator = (a, b) -> a.getName().compareTo(b.getName());
        List<EAttribute> allAttributes = ((EClass)this.eObject).getEAllAttributes().stream().sorted((a, b) -> a.getName().compareTo(b.getName())).collect(Collectors.toList());
        List<EReference> allReferences = ((EClass)this.eObject).getEAllReferences().stream().sorted((a, b) -> a.getName().compareTo(b.getName())).collect(Collectors.toList());
        List<EOperation> allOperations = ((EClass)this.eObject).getEAllOperations().stream().sorted((a, b) -> a.getName().compareTo(b.getName())).collect(Collectors.toList());
        EList allGenericSupertypes = ((EClass)this.eObject).getEAllGenericSuperTypes();
        if (allAttributes.size() + allReferences.size() + allOperations.size() + allGenericSupertypes.size() != 0) {
            Action allGroup = AppFactory.eINSTANCE.createAction();
            allGroup.setText("All");
            allGroup.setUuid(action.getUuid() + "-all");
            action.getNavigation().add((Object)allGroup);
            this.generateAllAttributes(allAttributes, allGroup, progressMonitor);
            this.generateAllReferences(allReferences, allGroup, progressMonitor);
            this.generateAllOperations(allOperations, allGroup, progressMonitor);
            this.generateAllGenericSupertypes((List<EGenericType>)allGenericSupertypes, allGroup, progressMonitor);
        }
        if (this.isGenerateLoadSpecification.getAsBoolean() && Map.Entry.class != this.instanceClass) {
            this.generateLoadSpecification(action, namedElementComparator, progressMonitor);
        }
        EList sections = action.getSections();
        if (!((EClass)this.eObject).getEAttributes().isEmpty()) {
            Action attributesCategory = AppFactory.eINSTANCE.createAction();
            attributesCategory.setText("Attributes");
            attributesCategory.setName("attributes");
            attributesCategory.setSectionStyle(SectionStyle.HEADER);
            sections.add((Object)attributesCategory);
            EList attributes = attributesCategory.getSections();
            for (EStructuralFeature sf : ((EClass)this.eObject).getEAttributes().stream().sorted((a, b) -> a.getName().compareTo(b.getName())).collect(Collectors.toList())) {
                attributes.add((Object)((Action)this.adaptChild((EObject)sf).execute(null, progressMonitor)));
            }
        }
        if (!((EClass)this.eObject).getEReferences().isEmpty()) {
            Action referencesCategory = AppFactory.eINSTANCE.createAction();
            referencesCategory.setText("References");
            referencesCategory.setName("references");
            referencesCategory.setSectionStyle(SectionStyle.HEADER);
            sections.add((Object)referencesCategory);
            EList references = referencesCategory.getSections();
            for (EStructuralFeature sf : ((EClass)this.eObject).getEReferences().stream().sorted((a, b) -> a.getName().compareTo(b.getName())).collect(Collectors.toList())) {
                references.add((Object)((Action)this.adaptChild((EObject)sf).execute(null, progressMonitor)));
            }
        }
        if (!((EClass)this.eObject).getEOperations().isEmpty()) {
            Action operationsCategory = AppFactory.eINSTANCE.createAction();
            operationsCategory.setText("Operations");
            operationsCategory.setName("operations");
            operationsCategory.setSectionStyle(SectionStyle.HEADER);
            sections.add((Object)operationsCategory);
            EList operations = operationsCategory.getSections();
            for (EOperation eOp : ((EClass)this.eObject).getEOperations().stream().sorted((a, b) -> a.getName().compareTo(b.getName())).collect(Collectors.toList())) {
                operations.add((Object)((Action)this.adaptChild((EObject)eOp).execute(null, progressMonitor)));
            }
        }
        if (((EClass)this.eObject).isInterface()) {
            action.setIcon("https://www.nasdanika.org/resources/images/ecore/EInterface.gif");
        }
        return action;
    }

    private void generateAllGenericSupertypes(List<EGenericType> allGenericSupertypes, Action allGroup, ProgressMonitor progressMonitor) throws Exception {
        String inheritanceDiagram;
        if (!allGenericSupertypes.isEmpty() && !Util.isBlank((String)(inheritanceDiagram = this.generateInheritanceDiagram(0, DiagramTextGenerator.RelationshipDirection.both, true, true, progressMonitor)))) {
            Action allSupertypesAction = AppFactory.eINSTANCE.createAction();
            allSupertypesAction.setText("Supertypes");
            allSupertypesAction.setLocation(((EClass)this.eObject).getName() + "-all-supertypes.html");
            allSupertypesAction.setSectionStyle(SectionStyle.HEADER);
            allGroup.getChildren().add((Object)allSupertypesAction);
            Tag list = TagName.ul.create(new Object[0]);
            for (EGenericType superType : allGenericSupertypes) {
                Tag listItem = TagName.li.create(new Object[0]);
                list.content(new Object[]{listItem});
                this.genericType(superType, (EClassifier)this.eObject, listItem.getContent(), progressMonitor);
            }
            EClassActionSupplier.addContent(allSupertypesAction, list.toString());
            EClassActionSupplier.addContent(allSupertypesAction, inheritanceDiagram);
        }
    }

    protected String generateInheritanceDiagram(int depth, DiagramTextGenerator.RelationshipDirection relationshipDirection, boolean appendAttributes, boolean appendOperations, ProgressMonitor monitor) throws Exception {
        StringBuilder sb = new StringBuilder();
        DiagramTextGenerator gen = this.getDiagramTextGenerator(sb, appendAttributes, appendOperations);
        if (gen == null) {
            return null;
        }
        ArrayList<EClass> diagramElements = new ArrayList<EClass>();
        diagramElements.add((EClass)this.eObject);
        diagramElements.addAll((Collection<EClass>)((EClass)this.eObject).getEAllSuperTypes());
        gen.appendWithRelationships(diagramElements, relationshipDirection, depth);
        return ((DiagramGenerator)this.context.get(DiagramGenerator.class)).generateUmlDiagram(sb.toString());
    }

    private void generateAllOperations(List<EOperation> allOperations, Action allGroup, ProgressMonitor progressMonitor) throws Exception {
        if (!allOperations.isEmpty()) {
            Action allOperationsAction = AppFactory.eINSTANCE.createAction();
            allOperationsAction.setText("Operations");
            allOperationsAction.setLocation(((EClass)this.eObject).getName() + "-all-operations.html");
            allOperationsAction.setSectionStyle(SectionStyle.HEADER);
            allGroup.getChildren().add((Object)allOperationsAction);
            EList operations = allOperationsAction.getSections();
            for (EOperation eOp : allOperations) {
                operations.add((Object)((Action)this.adaptChild((EObject)eOp).execute((EClass)this.eObject, progressMonitor)));
            }
        }
    }

    private void generateAllReferences(List<EReference> allReferences, Action allGroup, ProgressMonitor progressMonitor) throws Exception {
        if (!allReferences.isEmpty()) {
            Action allReferencesAction = AppFactory.eINSTANCE.createAction();
            allReferencesAction.setText("References");
            allReferencesAction.setLocation(((EClass)this.eObject).getName() + "-all-references.html");
            allReferencesAction.setSectionStyle(SectionStyle.HEADER);
            allGroup.getChildren().add((Object)allReferencesAction);
            EList references = allReferencesAction.getSections();
            for (EStructuralFeature eStructuralFeature : allReferences) {
                references.add((Object)((Action)this.adaptChild((EObject)eStructuralFeature).execute((EClass)this.eObject, progressMonitor)));
            }
        }
    }

    private void generateAllAttributes(List<EAttribute> allAttributes, Action allGroup, ProgressMonitor progressMonitor) throws Exception {
        if (!allAttributes.isEmpty()) {
            Action allAttributesAction = AppFactory.eINSTANCE.createAction();
            allAttributesAction.setText("Attributes");
            allAttributesAction.setLocation(((EClass)this.eObject).getName() + "-all-attributes.html");
            allAttributesAction.setSectionStyle(SectionStyle.HEADER);
            allGroup.getChildren().add((Object)allAttributesAction);
            EList attributes = allAttributesAction.getSections();
            for (EStructuralFeature eStructuralFeature : allAttributes) {
                attributes.add((Object)((Action)this.adaptChild((EObject)eStructuralFeature).execute((EClass)this.eObject, progressMonitor)));
            }
        }
    }

    private void generateLoadSpecification(Action action, Comparator<ENamedElement> namedElementComparator, ProgressMonitor progressMonitor) throws Exception {
        if (!((EClass)this.eObject).isAbstract() && "true".equals(NcoreUtil.getNasdanikaAnnotationDetail((EModelElement)((EModelElement)this.eObject), (String)"loadable", (String)"true"))) {
            Action loadSpecificationAction = AppFactory.eINSTANCE.createAction();
            loadSpecificationAction.setText("Load specification");
            loadSpecificationAction.setLocation(((EClass)this.eObject).getName() + "-load-specification.html");
            action.getNavigation().add((Object)loadSpecificationAction);
            EmfUtil.EModelElementDocumentation loadDoc = EmfUtil.getLoadDocumentation((EModelElement)((EModelElement)this.eObject));
            if (loadDoc != null) {
                loadSpecificationAction.getContent().add((Object)this.interpolatedMarkdown(loadDoc.getDocumentation(), loadDoc.getLocation(), progressMonitor));
            }
            Tag toc = TagName.ul.create(new Object[0]);
            Predicate<EStructuralFeature> predicate = sf -> sf.isChangeable() && "true".equals(NcoreUtil.getNasdanikaAnnotationDetail((EModelElement)sf, (String)"loadable", (String)"true"));
            for (EStructuralFeature sf2 : ((EClass)this.eObject).getEAllStructuralFeatures().stream().filter(predicate).sorted(namedElementComparator).collect(Collectors.toList())) {
                Object[] exclusiveWith;
                boolean isStrictContainment;
                boolean isHomogenous;
                Action featureAction = AppFactory.eINSTANCE.createAction();
                String key = NcoreUtil.getNasdanikaAnnotationDetail((EModelElement)sf2, (String)"load-key", (String)NcoreUtil.getFeatureKey((EClass)((EClass)this.eObject), (EStructuralFeature)sf2));
                featureAction.setText(key);
                String sectionAnchor = "key-section-" + key;
                featureAction.setName(sectionAnchor);
                loadSpecificationAction.getSections().add((Object)featureAction);
                org.nasdanika.html.bootstrap.Table table = ((BootstrapFactory)this.context.get(BootstrapFactory.class)).table();
                ((Table)table.toHTMLElement()).style().width((Object)"auto");
                this.genericType(sf2.getEGenericType(), (EClassifier)this.eObject, ETypedElementActionSupplier.addRow(table, "Type"), progressMonitor);
                boolean isDefaultFeature = EObjectLoader.isDefaultFeature((EClass)((EClass)this.eObject), (EStructuralFeature)sf2);
                if (isDefaultFeature) {
                    ETypedElementActionSupplier.addRow(table, "Default").add("true");
                }
                toc.accept((Object)TagName.li.create(new Object[]{((Tag)TagName.a.create(new Object[]{key}).attribute("href", (Object)("#" + sectionAnchor))).attribute("style", (Object)"font-weight:bold", isDefaultFeature)}));
                boolean bl = isHomogenous = "true".equals(NcoreUtil.getNasdanikaAnnotationDetail((EModelElement)sf2, (String)"homogenous")) || NcoreUtil.getNasdanikaAnnotationDetail((EModelElement)sf2, (String)"reference-type") != null;
                if (isHomogenous) {
                    ETypedElementActionSupplier.addRow(table, "Homogenous").add("true");
                }
                boolean bl2 = isStrictContainment = isHomogenous && "true".equals(NcoreUtil.getNasdanikaAnnotationDetail((EModelElement)sf2, (String)"strict-containment"));
                if (isStrictContainment) {
                    ETypedElementActionSupplier.addRow(table, "Strict containment").add("true");
                }
                if ((exclusiveWith = EObjectLoader.getExclusiveWith((EClass)((EClass)this.eObject), (EStructuralFeature)sf2, (BiFunction)EObjectLoader.LOAD_KEY_PROVIDER)).length != 0) {
                    Tag ul = TagName.ul.create(new Object[0]);
                    for (Object exw : exclusiveWith) {
                        ul.content(new Object[]{TagName.li.create(new Object[]{exw})});
                    }
                    ETypedElementActionSupplier.addRow(table, "Exclusive with").add(ul);
                }
                EClassActionSupplier.addContent(featureAction, table.toString());
                EmfUtil.EModelElementDocumentation featureLoadDoc = EmfUtil.getLoadDocumentation((EModelElement)sf2);
                if (featureLoadDoc == null) {
                    featureLoadDoc = EmfUtil.getDocumentation((EModelElement)sf2);
                }
                if (featureLoadDoc == null) continue;
                featureAction.getContent().add((Object)this.interpolatedMarkdown(this.context.interpolateToString(featureLoadDoc.getDocumentation()), featureLoadDoc.getLocation(), progressMonitor));
            }
            EClassActionSupplier.addContent(loadSpecificationAction, toc.toString());
        }
    }

    protected DiagramTextGenerator getDiagramTextGenerator(StringBuilder sb, final boolean appendAttributes, final boolean appendOperations) {
        String dialect = this.diagramDialectSupplier.get();
        if (Util.isBlank((String)dialect)) {
            return null;
        }
        switch (dialect) {
            case "uml": {
                return new PlantUmlTextGenerator(sb, ec -> this.path((EClassifier)ec, (EClassifier)this.eObject), this::getEModelElementFirstDocSentence){

                    protected Collection<EClass> getSubTypes(EClass eClass) {
                        return EClassActionSupplier.this.getSubTypes(eClass);
                    }

                    protected Collection<EClass> getReferrers(EClass eClass) {
                        return EClassActionSupplier.this.getReferrers(eClass);
                    }

                    protected Collection<EClass> getUses(EClassifier eClassifier) {
                        return EClassActionSupplier.this.getUses(eClassifier);
                    }

                    protected boolean isAppendAttributes(EClass eClass) {
                        return appendAttributes;
                    }

                    protected boolean isAppendOperations(EClass eClass) {
                        return appendOperations;
                    }
                };
            }
            case "mermaid": {
                return new MermaidTextGenerator(sb, ec -> this.path((EClassifier)ec, (EClassifier)this.eObject), this::getEModelElementFirstDocSentence){

                    protected Collection<EClass> getSubTypes(EClass eClass) {
                        return EClassActionSupplier.this.getSubTypes(eClass);
                    }

                    protected Collection<EClass> getReferrers(EClass eClass) {
                        return EClassActionSupplier.this.getReferrers(eClass);
                    }

                    protected Collection<EClass> getUses(EClassifier eClassifier) {
                        return EClassActionSupplier.this.getUses(eClassifier);
                    }

                    protected boolean isAppendAttributes(EClass eClass) {
                        return appendAttributes;
                    }

                    protected boolean isAppendOperations(EClass eClass) {
                        return appendOperations;
                    }
                };
            }
        }
        throw new UnsupportedOperationException("Unsupported dialect: " + dialect);
    }

    protected String generateDiagram(int depth, DiagramTextGenerator.RelationshipDirection relationshipDirection, boolean appendAttributes, boolean appendOperations, ProgressMonitor monitor) throws Exception {
        DiagramGenerator diagramGenerator = (DiagramGenerator)this.context.get(DiagramGenerator.class);
        StringBuilder sb = new StringBuilder();
        DiagramTextGenerator gen = this.getDiagramTextGenerator(sb, appendAttributes, appendOperations);
        if (gen == null) {
            return null;
        }
        gen.appendWithRelationships(Collections.singleton((EClass)this.eObject), relationshipDirection, depth);
        return diagramGenerator.generateUmlDiagram(sb.toString());
    }

    protected Collection<EClass> getSubTypes(EClass eClass) {
        TreeIterator acit;
        Resource eResource = eClass.eResource();
        if (eResource == null) {
            EPackage ePackage = eClass.getEPackage();
            if (ePackage == null) {
                return Collections.emptySet();
            }
            acit = ePackage.eAllContents();
        } else {
            ResourceSet resourceSet = eResource.getResourceSet();
            acit = resourceSet == null ? eResource.getAllContents() : resourceSet.getAllContents();
        }
        HashSet<EClass> ret = new HashSet<EClass>();
        acit.forEachRemaining(obj -> {
            if (obj instanceof EClass && ((EClass)obj).getESuperTypes().contains((Object)eClass)) {
                ret.add((EClass)obj);
            }
        });
        return ret;
    }

    protected Collection<EClass> getReferrers() {
        return this.getReferrers((EClass)this.eObject);
    }
}

