/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.ecore;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.binary.Hex;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.nasdanika.cli.CommandBase;
import org.nasdanika.cli.ProgressMonitorMixin;
import org.nasdanika.common.Context;
import org.nasdanika.common.MutableContext;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.common.Util;
import org.nasdanika.emf.EObjectAdaptable;
import org.nasdanika.html.ecore.EcoreActionSupplierAdapterFactory;
import org.nasdanika.html.ecore.GenModelResourceSet;
import org.nasdanika.html.model.app.util.ActionSupplier;
import picocli.CommandLine;

@CommandLine.Command(description={"Generates Ecore model documentation as an action model"}, name="ecore")
public class EcoreDocumentationGeneratorCommand
extends CommandBase {
    static final String JAVADOC_CONTEXT_BUILDER_MOUNT = "javadoc-context-builder-mount";
    @CommandLine.Parameters(paramLabel="URI", arity="1..*", description={"A list of gen-model URI's to generate documentation for. For each URI a YAML actions file is generated named after the root package in the model. If there are duplicate package names then argument index is added to de-dup the names. "})
    protected List<String> URIs = new ArrayList<String>();
    @CommandLine.Mixin
    private ProgressMonitorMixin progressMonitorMixin;
    @CommandLine.Option(names={"-o", "--output"}, description={"Output directory, defaults to the current directory."})
    private File outputDir;
    @CommandLine.Option(names={"-b", "--base-uri"}, description={"Base URI for resolving eclasifier references in diagram image maps. Resolved against the output directory URI. Defaults to the output directory URI."})
    private String baseUri;
    @CommandLine.Option(names={"-J", "--javadoc-context-builder-mount"}, arity="0..1", fallbackValue="javadoc/", description={"If specified model instance class names are output as tokens for expansion to links to JavaDoc. If specified without parameter option value is ${FALLBACK-VALUE}"})
    private String javaDocContextBuilderMount;
    @CommandLine.Option(names={"-n", "--name"}, description={"Use EPackage name in paths and URL's instead of encoded NS URI. Duplicate names are de-duplicated by adding -<number> suffix"})
    private boolean useEPackageNameInPath;
    protected GenModelResourceSet resourceSet;
    private Map<String, String> pathMap = new ConcurrentHashMap<String, String>();

    private String getEPackagePath(EPackage ePackage) {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            String path;
            String string = path = i == 0 ? ePackage.getName() : ePackage.getName() + "_" + i;
            if (this.pathMap.containsKey(path)) {
                if (!ePackage.getNsURI().equals(this.pathMap.get(path))) continue;
                return path;
            }
            this.pathMap.put(path, ePackage.getNsURI());
            return path;
        }
        return Hex.encodeHexString((byte[])ePackage.getNsURI().getBytes(StandardCharsets.UTF_8));
    }

    protected EcoreActionSupplierAdapterFactory createAdapterFactory() {
        if (this.outputDir == null) {
            this.outputDir = new File(".");
        }
        URI outputURI = URI.createFileURI((String)(this.outputDir.getAbsolutePath() + File.separator));
        URI baseURI = Util.isBlank((String)this.baseUri) ? outputURI : URI.createURI((String)this.baseUri).resolve(outputURI);
        MutableContext context = Context.EMPTY_CONTEXT.fork();
        context.register(URI.class, (Object)baseURI);
        context.put("base-uri", (Object)baseURI);
        if (!Util.isBlank((String)this.javaDocContextBuilderMount)) {
            context.put(JAVADOC_CONTEXT_BUILDER_MOUNT, (Object)this.javaDocContextBuilderMount);
        }
        return new EcoreActionSupplierAdapterFactory((Context)context, this.useEPackageNameInPath ? this::getEPackagePath : null, null);
    }

    public List<ActionSupplier> loadGenModel() {
        this.resourceSet = new GenModelResourceSet();
        this.resourceSet.getAdapterFactories().add((Object)this.createAdapterFactory());
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String uri : this.URIs) {
            Resource genModel = this.resourceSet.getResource(URI.createURI((String)uri), true);
            if (genModel == null) {
                throw new IllegalArgumentException("Gen model not found: " + uri);
            }
            resources.add(genModel);
        }
        ArrayList<ActionSupplier> ret = new ArrayList<ActionSupplier>();
        for (Resource resource : resources) {
            for (EObject contents : resource.getContents()) {
                if (!(contents instanceof GenModel)) continue;
                for (GenPackage genPackage : ((GenModel)contents).getGenPackages()) {
                    EPackage ecorePackage = genPackage.getEcorePackage();
                    ret.add((ActionSupplier)EObjectAdaptable.adaptTo((EObject)ecorePackage, ActionSupplier.class));
                }
            }
        }
        return ret;
    }

    public Integer call() throws Exception {
        List<ActionSupplier> suppliers = this.loadGenModel();
        HashSet names = new HashSet();
        ProgressMonitor pm = this.progressMonitorMixin.createProgressMonitor((double)suppliers.size());
        Throwable throwable = null;
        if (pm != null) {
            if (throwable != null) {
                try {
                    pm.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                pm.close();
            }
        }
        return 0;
    }
}

