/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.ecore;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.codec.binary.Hex;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.nasdanika.common.Context;
import org.nasdanika.common.DiagramGenerator;
import org.nasdanika.common.MarkdownHelper;
import org.nasdanika.common.MutableContext;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.common.PropertyComputer;
import org.nasdanika.common.Util;
import org.nasdanika.emf.EmfUtil;
import org.nasdanika.emf.persistence.MarkerFactory;
import org.nasdanika.exec.content.ContentFactory;
import org.nasdanika.exec.content.Interpolator;
import org.nasdanika.exec.content.Markdown;
import org.nasdanika.exec.content.Text;
import org.nasdanika.html.ecore.EObjectActionSupplier;
import org.nasdanika.html.model.app.Action;
import org.nasdanika.html.model.app.AppFactory;
import org.nasdanika.ncore.Marker;

public class EModelElementActionSupplier<T extends EModelElement>
extends EObjectActionSupplier<T> {
    public static final String ICONS_BASE = "https://www.nasdanika.org/resources/images/ecore/";
    protected int descriptionTabLengthThreshold = 2500;
    protected Context context;
    protected Function<EPackage, String> ePackagePathComputer;

    public EModelElementActionSupplier(T value, Context context, Function<EPackage, String> ePackagePathComputer) {
        super(value);
        this.context = context.fork();
        PropertyComputer eClassifierPropertyComputer = new PropertyComputer((EModelElement)value){
            final /* synthetic */ EModelElement val$value;
            {
                this.val$value = eModelElement;
            }

            public <P> P compute(Context context, String key, String path, Class<P> type) {
                EModelElement contextClassifier;
                for (contextClassifier = this.val$value; contextClassifier != null && !(contextClassifier instanceof EClassifier); contextClassifier = contextClassifier.eContainer()) {
                }
                if (contextClassifier == null) {
                    return null;
                }
                EClassifier targetClassifier = null;
                int atIdx = path.indexOf(64);
                if (atIdx == -1) {
                    targetClassifier = ((EClassifier)contextClassifier).getEPackage().getEClassifier(path);
                } else {
                    Resource contextResource = contextClassifier.eResource();
                    if (contextResource == null) {
                        return null;
                    }
                    ResourceSet resourceSet = contextResource.getResourceSet();
                    if (resourceSet == null) {
                        return null;
                    }
                    TreeIterator cit = resourceSet.getAllContents();
                    String targetNsUri = path.substring(atIdx + 1);
                    while (cit.hasNext()) {
                        Notifier next = (Notifier)cit.next();
                        if (!(next instanceof EPackage) || !((EPackage)next).getNsURI().equals(targetNsUri)) continue;
                        targetClassifier = ((EPackage)next).getEClassifier(path.substring(0, atIdx));
                        break;
                    }
                }
                if (targetClassifier == null) {
                    return null;
                }
                return (P)EModelElementActionSupplier.this.path(targetClassifier, (EClassifier)contextClassifier);
            }
        };
        ((MutableContext)this.context).put("classifier", (Object)eClassifierPropertyComputer);
        this.ePackagePathComputer = ePackagePathComputer;
    }

    public Action execute(EClass contextClass, ProgressMonitor progressMonitor) throws Exception {
        Action ret = AppFactory.eINSTANCE.createAction();
        ret.setIcon(ICONS_BASE + ((EModelElement)this.eObject).eClass().getName() + ".gif");
        this.header(ret, progressMonitor);
        final EmfUtil.EModelElementDocumentation documentation = EmfUtil.getDocumentation((EModelElement)((EModelElement)this.eObject));
        MarkdownHelper markdownHelper = new MarkdownHelper(){

            protected URI getResourceBase() {
                return documentation.getLocation();
            }

            protected DiagramGenerator getDiagramGenerator() {
                return EModelElementActionSupplier.this.context == null ? super.getDiagramGenerator() : (DiagramGenerator)EModelElementActionSupplier.this.context.get(DiagramGenerator.class, (Object)super.getDiagramGenerator());
            }
        };
        if (documentation != null) {
            ret.getContent().add((Object)this.interpolatedMarkdown(this.context.interpolateToString(documentation.getDocumentation()), documentation.getLocation(), progressMonitor));
            ret.setTooltip(markdownHelper.firstPlainTextSentence(documentation.getDocumentation()));
        }
        return ret;
    }

    protected void header(Action action, ProgressMonitor progressMonitor) throws Exception {
    }

    public double size() {
        return 1.0;
    }

    public String name() {
        return ((EModelElement)this.eObject).eClass().getName();
    }

    protected Markdown interpolatedMarkdown(String markdown, URI location, ProgressMonitor progressMonitor) {
        Marker marker;
        if (Util.isBlank((String)markdown)) {
            return null;
        }
        Markdown ret = ContentFactory.eINSTANCE.createMarkdown();
        Interpolator interpolator = ContentFactory.eINSTANCE.createInterpolator();
        Text text = ContentFactory.eINSTANCE.createText();
        text.setContent(markdown);
        interpolator.setSource((EObject)text);
        ret.setSource((EObject)interpolator);
        ret.setStyle(true);
        if (location != null && (marker = ret.getMarker()) == null) {
            marker = ((MarkerFactory)this.context.get(MarkerFactory.class, (Object)MarkerFactory.INSTANCE)).createMarker(location.toString(), progressMonitor);
            ret.setMarker(marker);
        }
        return ret;
    }

    protected String getEModelElementFirstDocSentence(EModelElement modelElement) {
        final EmfUtil.EModelElementDocumentation documentation = EmfUtil.getDocumentation((EModelElement)modelElement);
        if (documentation == null) {
            return null;
        }
        MarkdownHelper markdownHelper = new MarkdownHelper(){

            protected URI getResourceBase() {
                return documentation.getLocation();
            }

            protected DiagramGenerator getDiagramGenerator() {
                return EModelElementActionSupplier.this.context == null ? super.getDiagramGenerator() : (DiagramGenerator)EModelElementActionSupplier.this.context.get(DiagramGenerator.class, (Object)super.getDiagramGenerator());
            }
        };
        String ret = markdownHelper.firstPlainTextSentence(documentation.getDocumentation());
        return String.join((CharSequence)" ", ret.split("\\R"));
    }

    protected Collection<EClass> getReferrers(EClass eClass) {
        TreeIterator acit;
        Resource eResource = eClass.eResource();
        if (eResource == null) {
            EPackage ePackage = eClass.getEPackage();
            if (ePackage == null) {
                return Collections.emptySet();
            }
            acit = ePackage.eAllContents();
        } else {
            ResourceSet resourceSet = eResource.getResourceSet();
            acit = resourceSet == null ? eResource.getAllContents() : resourceSet.getAllContents();
        }
        HashSet<EClass> ret = new HashSet<EClass>();
        acit.forEachRemaining(obj -> {
            if (obj instanceof EReference && ((EReference)obj).getEReferenceType() == eClass) {
                ret.add(((EReference)obj).getEContainingClass());
            }
        });
        return ret;
    }

    protected Collection<EClass> getUses(EClassifier eClassifier) {
        TreeIterator acit;
        Resource eResource = eClassifier.eResource();
        if (eResource == null) {
            EPackage ePackage = eClassifier.getEPackage();
            if (ePackage == null) {
                return Collections.emptySet();
            }
            acit = ePackage.eAllContents();
        } else {
            ResourceSet resourceSet = eResource.getResourceSet();
            acit = resourceSet == null ? eResource.getAllContents() : resourceSet.getAllContents();
        }
        HashSet<EClass> ret = new HashSet<EClass>();
        acit.forEachRemaining(obj -> {
            if (obj instanceof EClass && EmfUtil.collectTypeDependencies((EClass)((EClass)obj)).contains(eClassifier)) {
                ret.add((EClass)obj);
            }
        });
        return ret;
    }

    protected static String cardinality(ETypedElement typedElement) {
        int upperBound;
        int lowerBound = typedElement.getLowerBound();
        String cardinality = lowerBound == (upperBound = typedElement.getUpperBound()) ? String.valueOf(lowerBound) : lowerBound + ".." + (upperBound == -1 ? "*" : String.valueOf(upperBound));
        if (typedElement instanceof EReference && ((EReference)typedElement).isContainment()) {
            cardinality = "<B>" + cardinality + "</B>";
        }
        return cardinality;
    }

    protected String computeLabel(EGenericType genericType, ProgressMonitor monitor) throws Exception {
        EObject container = genericType.eContainer();
        EClassifier rawType = genericType.getERawType();
        String rawTypeText = rawType.getName();
        if (container == null || !container.eIsSet(genericType.eContainingFeature())) {
            return rawTypeText;
        }
        StringBuilder label = new StringBuilder();
        if (genericType.getEClassifier() != null) {
            label.append(rawTypeText);
            if (!genericType.getETypeArguments().isEmpty()) {
                label.append("&lt;");
                Iterator i = genericType.getETypeArguments().iterator();
                while (i.hasNext()) {
                    EGenericType typeArgument = (EGenericType)i.next();
                    label.append(this.computeLabel(typeArgument, monitor));
                    if (!i.hasNext()) continue;
                    label.append(", ");
                }
                label.append("&gt;");
            }
        } else {
            ETypeParameter typeParameter = genericType.getETypeParameter();
            String name = typeParameter != null ? typeParameter.getName() : "?";
            label.append(name);
            if (genericType.getELowerBound() != null) {
                label.append(" super ");
                label.append(this.computeLabel(genericType.getELowerBound(), monitor));
            } else if (genericType.getEUpperBound() != null) {
                label.append(" extends ");
                label.append(this.computeLabel(genericType.getEUpperBound(), monitor));
            }
        }
        return label.toString();
    }

    protected String typeParameters(EClassifier eClassifier) {
        if (eClassifier.getETypeParameters().isEmpty()) {
            return "";
        }
        StringBuilder typeParameters = new StringBuilder();
        for (ETypeParameter typeParameter : eClassifier.getETypeParameters()) {
            if (typeParameters.length() > 0) {
                typeParameters.append(",");
            }
            typeParameters.append(this.genericName(typeParameter));
        }
        return "&lt;" + typeParameters + "&gt;";
    }

    protected String genericName(ETypeParameter typeParameter) {
        StringBuilder ret = new StringBuilder(typeParameter.getName());
        for (EGenericType bound : typeParameter.getEBounds()) {
            if (bound.getEUpperBound() != null) {
                ret.append(" extends ").append(this.genericName(bound.getEUpperBound()));
            }
            if (bound.getELowerBound() == null) continue;
            ret.append(" super ").append(this.genericName(bound.getELowerBound()));
        }
        return ret.toString();
    }

    protected String genericName(EGenericType eGenericType) {
        StringBuilder ret = new StringBuilder();
        if (eGenericType.getETypeParameter() != null) {
            ret.append(eGenericType.getETypeParameter().getName());
        } else if (eGenericType.getEClassifier() != null) {
            ret.append(eGenericType.getEClassifier().getName());
        }
        ret.append(this.genericTypeArguments(eGenericType));
        return ret.toString();
    }

    protected String genericTypeArguments(EGenericType eGenericType) {
        StringBuilder ret = new StringBuilder();
        Iterator it = eGenericType.getETypeArguments().iterator();
        if (it.hasNext()) {
            ret.append("<");
            while (it.hasNext()) {
                ret.append(this.genericName((EGenericType)it.next()));
                if (!it.hasNext()) continue;
                ret.append(",");
            }
            ret.append(">");
        }
        return ret.toString();
    }

    protected void genericType(EGenericType eGenericType, EClassifier contextClassifier, List<Object> accumulator, ProgressMonitor monitor) throws Exception {
        if (eGenericType == null) {
            accumulator.add("void");
        } else if (eGenericType.getETypeParameter() != null) {
            accumulator.add(eGenericType.getETypeParameter().getName());
        } else if (eGenericType.getEClassifier() != null) {
            accumulator.add(this.link(eGenericType.getEClassifier(), contextClassifier));
            this.genericTypeArguments(eGenericType, contextClassifier, accumulator, monitor);
        } else {
            accumulator.add(Character.valueOf('?'));
            if (eGenericType.getELowerBound() != null) {
                accumulator.add(" super ");
                this.genericType(eGenericType.getELowerBound(), contextClassifier, accumulator, monitor);
            } else if (eGenericType.getEUpperBound() != null) {
                accumulator.add(" extends ");
                this.genericType(eGenericType.getEUpperBound(), contextClassifier, accumulator, monitor);
            }
        }
    }

    protected String path(EClassifier eClassifier, EClassifier contextClassifier) {
        Resource targetResource = eClassifier.eResource();
        if (targetResource == null) {
            return null;
        }
        ResourceSet targetResourceSet = targetResource.getResourceSet();
        if (targetResourceSet != ((EModelElement)this.eObject).eResource().getResourceSet()) {
            return null;
        }
        String targetEPackagePath = this.encodeEPackage(eClassifier.getEPackage());
        if (Util.isBlank((String)targetEPackagePath)) {
            return null;
        }
        String targetPath = targetEPackagePath + "/" + eClassifier.getName() + ".html";
        String thisPath = null;
        if (contextClassifier == null) {
            if (this.eObject instanceof EClassifier) {
                contextClassifier = (EClassifier)this.eObject;
            } else if (((EModelElement)this.eObject).eContainer() instanceof EClassifier) {
                contextClassifier = (EClassifier)((EModelElement)this.eObject).eContainer();
            } else if (((EModelElement)this.eObject).eContainer() instanceof EOperation) {
                contextClassifier = (EClassifier)((EModelElement)this.eObject).eContainer().eContainer();
            }
        }
        if (contextClassifier != null) {
            thisPath = this.encodeEPackage(contextClassifier.getEPackage()) + "/" + contextClassifier.getName() + ".html";
        } else if (this.eObject instanceof EPackage) {
            thisPath = this.encodeEPackage((EPackage)this.eObject) + "/package-summary.html";
        }
        if (thisPath == null) {
            return null;
        }
        URI base = URI.createURI((String)this.context.getString("base-uri", "tmp://base/doc/"));
        URI target = URI.createURI((String)targetPath).resolve(base);
        URI source = URI.createURI((String)thisPath).resolve(base);
        URI relativeTarget = target.deresolve(source, true, true, true);
        return relativeTarget.toString();
    }

    protected String link(EClassifier eClassifier, EClassifier contextClassifier) {
        String path = this.path(eClassifier, contextClassifier);
        return Util.isBlank((String)path) ? eClassifier.getName() : "<a href=\"" + path + "\">" + eClassifier.getName() + "</a>";
    }

    protected void genericTypeArguments(EGenericType eGenericType, EClassifier contextClassifier, List<Object> accumulator, ProgressMonitor monitor) throws Exception {
        Iterator it = eGenericType.getETypeArguments().iterator();
        if (it.hasNext()) {
            accumulator.add("&lt;");
            while (it.hasNext()) {
                this.genericType((EGenericType)it.next(), contextClassifier, accumulator, monitor);
                if (!it.hasNext()) continue;
                accumulator.add(",");
            }
            accumulator.add("&gt;");
        }
    }

    public String encodeEPackage(EPackage ePackage) {
        String ret = null;
        for (EPackage p = ePackage; p != null; p = p.getESuperPackage()) {
            String segment = this.ePackagePathComputer == null ? Hex.encodeHexString((byte[])p.getNsURI().getBytes(StandardCharsets.UTF_8)) : this.ePackagePathComputer.apply(p);
            ret = ret == null ? segment : segment + "/" + ret;
        }
        return ret;
    }

    protected static void addContent(Action action, String content) {
        Text text = ContentFactory.eINSTANCE.createText();
        text.setContent(content);
        action.getContent().add((Object)text);
    }
}

