/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.ecore;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.nasdanika.common.Context;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.exec.content.ContentFactory;
import org.nasdanika.exec.content.Text;
import org.nasdanika.html.ecore.ENamedElementActionSupplier;
import org.nasdanika.html.model.app.Action;

public class EClassifierActionSupplier<T extends EClassifier>
extends ENamedElementActionSupplier<T> {
    private Function<String, String> javadocResolver;

    public EClassifierActionSupplier(T value, Context context, Function<EPackage, String> ePackagePathComputer, Function<String, String> javadocResolver) {
        super(value, context, ePackagePathComputer);
        this.javadocResolver = javadocResolver;
    }

    @Override
    protected void header(Action action, ProgressMonitor progressMonitor) throws Exception {
        EClassifier registeredClassifier;
        EPackage registeredPackage;
        Class instanceClass = ((EClassifier)this.eObject).getInstanceClass();
        if (instanceClass == null && (registeredPackage = this.getRegisteredPackage()) != null && (registeredClassifier = registeredPackage.getEClassifier(((EClassifier)this.eObject).getName())) != null) {
            instanceClass = registeredClassifier.getInstanceClass();
        }
        if (instanceClass != null) {
            String instanceClassName = instanceClass.getName();
            if (this.javadocResolver != null) {
                instanceClassName = this.javadocResolver.apply(instanceClassName);
            }
            Text text = ContentFactory.eINSTANCE.createText();
            text.setContent("<div class='text-monospace'>" + instanceClassName + "</div>");
            action.getContent().add((Object)text);
        }
    }

    @Override
    public Action execute(EClass contextEClass, ProgressMonitor progressMonitor) throws Exception {
        Action action = super.execute(contextEClass, progressMonitor);
        action.setLocation(((EClassifier)this.eObject).getName() + ".html");
        action.setId(((EClassifier)this.eObject).eClass().getName() + "-" + this.encodeEPackage(((EClassifier)this.eObject).getEPackage()) + "-" + ((EClassifier)this.eObject).getName());
        action.setText(((EClassifier)this.eObject).getName() + this.typeParameters((EClassifier)this.eObject));
        return action;
    }

    protected Collection<EClass> getUses() {
        return this.getUses((EClassifier)this.eObject);
    }

    private EPackage getRegisteredPackage() {
        String nsURI = ((EClassifier)this.eObject).getEPackage().getNsURI();
        Object value = EPackage.Registry.INSTANCE.get((Object)nsURI);
        if (value instanceof EPackage) {
            return (EPackage)value;
        }
        if (value instanceof EPackage.Descriptor) {
            return Objects.requireNonNull(((EPackage.Descriptor)value).getEPackage(), "EPackage is null for " + nsURI);
        }
        if (value instanceof EPackage) {
            return (EPackage)value;
        }
        return null;
    }
}

