/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.ecore;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.nasdanika.common.Context;
import org.nasdanika.common.DiagramGenerator;
import org.nasdanika.common.MarkdownHelper;
import org.nasdanika.common.MutableContext;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.common.PropertyComputer;
import org.nasdanika.common.Util;
import org.nasdanika.emf.EmfUtil;
import org.nasdanika.emf.persistence.MarkerFactory;
import org.nasdanika.exec.content.ContentFactory;
import org.nasdanika.exec.content.Interpolator;
import org.nasdanika.exec.content.Markdown;
import org.nasdanika.exec.content.Text;
import org.nasdanika.html.ecore.EObjectActionSupplier;
import org.nasdanika.html.model.app.Action;
import org.nasdanika.html.model.app.AppFactory;
import org.nasdanika.ncore.Marker;
import org.nasdanika.ncore.util.NcoreUtil;

public class EModelElementActionSupplier<T extends EModelElement>
extends EObjectActionSupplier<T> {
    protected BiFunction<ENamedElement, String, String> labelProvider;
    protected Comparator<ENamedElement> eNamedElementComparator = (a, b) -> this.labelProvider.apply((ENamedElement)a, a.getName()).compareTo(this.labelProvider.apply((ENamedElement)b, b.getName()));
    public static final String ICONS_BASE = "https://www.nasdanika.org/resources/images/ecore/";
    protected int descriptionTabLengthThreshold = 2500;
    protected Context context;
    protected Function<EPackage, String> ePackagePathComputer;
    protected Predicate<EModelElement> elementPredicate;

    public EModelElementActionSupplier(T value, Context context, Function<EPackage, String> ePackagePathComputer, Predicate<EModelElement> elementPredicate, BiFunction<ENamedElement, String, String> labelProvider) {
        super(value);
        this.context = context.fork();
        PropertyComputer eClassifierPropertyComputer = new PropertyComputer((EModelElement)value){
            final /* synthetic */ EModelElement val$value;
            {
                this.val$value = eModelElement;
            }

            public <P> P compute(Context context, String key, String path, Class<P> type) {
                EModelElement contextElement;
                Resource contextResource = this.val$value.eResource();
                for (contextElement = this.val$value; contextElement != null && !(contextElement instanceof EPackage); contextElement = contextElement.eContainer()) {
                }
                EClassifier targetClassifier = null;
                int atIdx = path.indexOf(64);
                if (atIdx == -1) {
                    if (contextElement == null) {
                        return null;
                    }
                    targetClassifier = ((EPackage)contextElement).getEClassifier(path);
                } else {
                    if (contextResource == null) {
                        return null;
                    }
                    ResourceSet resourceSet = contextResource.getResourceSet();
                    if (resourceSet == null) {
                        return null;
                    }
                    TreeIterator cit = resourceSet.getAllContents();
                    String targetNsUri = path.substring(atIdx + 1);
                    while (cit.hasNext()) {
                        Notifier next = (Notifier)cit.next();
                        if (!(next instanceof EPackage) || !((EPackage)next).getNsURI().equals(targetNsUri)) continue;
                        targetClassifier = ((EPackage)next).getEClassifier(path.substring(0, atIdx));
                        break;
                    }
                }
                if (targetClassifier == null) {
                    return null;
                }
                return (P)EModelElementActionSupplier.this.path(targetClassifier, this.val$value instanceof EClassifier ? (EClassifier)this.val$value : null);
            }
        };
        ((MutableContext)this.context).put("classifier", (Object)eClassifierPropertyComputer);
        this.ePackagePathComputer = ePackagePathComputer;
        this.elementPredicate = elementPredicate;
        this.labelProvider = labelProvider;
    }

    public Action execute(EClass contextClass, ProgressMonitor progressMonitor) {
        Action ret = AppFactory.eINSTANCE.createAction();
        ret.setIcon(ICONS_BASE + ((EModelElement)this.eObject).eClass().getName() + ".gif");
        this.header(ret, progressMonitor);
        final EmfUtil.EModelElementDocumentation documentation = EmfUtil.getDocumentation((EModelElement)((EModelElement)this.eObject));
        MarkdownHelper markdownHelper = new MarkdownHelper(){

            protected URI getResourceBase() {
                return documentation.getLocation();
            }

            protected DiagramGenerator getDiagramGenerator() {
                return EModelElementActionSupplier.this.context == null ? super.getDiagramGenerator() : (DiagramGenerator)EModelElementActionSupplier.this.context.get(DiagramGenerator.class, (Object)super.getDiagramGenerator());
            }
        };
        if (documentation != null) {
            ret.getContent().add((Object)this.interpolatedMarkdown(this.context.interpolateToString(documentation.getDocumentation()), documentation.getLocation(), progressMonitor));
            ret.setTooltip(markdownHelper.firstPlainTextSentence(documentation.getDocumentation()));
        }
        return ret;
    }

    protected void header(Action action, ProgressMonitor progressMonitor) {
    }

    public double size() {
        return 1.0;
    }

    public String name() {
        return ((EModelElement)this.eObject).eClass().getName();
    }

    protected Markdown interpolatedMarkdown(String markdown, URI location, ProgressMonitor progressMonitor) {
        if (Util.isBlank((String)markdown)) {
            return null;
        }
        Markdown ret = ContentFactory.eINSTANCE.createMarkdown();
        Interpolator interpolator = ContentFactory.eINSTANCE.createInterpolator();
        Text text = ContentFactory.eINSTANCE.createText();
        text.setContent(markdown);
        interpolator.setSource((EObject)text);
        ret.setSource((EObject)interpolator);
        ret.setStyle(true);
        if (location != null) {
            Marker marker = ((MarkerFactory)this.context.get(MarkerFactory.class, (Object)MarkerFactory.INSTANCE)).createMarker(location.toString(), progressMonitor);
            ret.getMarkers().add((Object)marker);
        }
        return ret;
    }

    protected String getEModelElementFirstDocSentence(EModelElement modelElement) {
        final EmfUtil.EModelElementDocumentation documentation = EmfUtil.getDocumentation((EModelElement)modelElement);
        if (documentation == null) {
            return null;
        }
        MarkdownHelper markdownHelper = new MarkdownHelper(){

            protected URI getResourceBase() {
                return documentation.getLocation();
            }

            protected DiagramGenerator getDiagramGenerator() {
                return EModelElementActionSupplier.this.context == null ? super.getDiagramGenerator() : (DiagramGenerator)EModelElementActionSupplier.this.context.get(DiagramGenerator.class, (Object)super.getDiagramGenerator());
            }
        };
        String ret = markdownHelper.firstPlainTextSentence(documentation.getDocumentation());
        return String.join((CharSequence)" ", ret.split("\\R"));
    }

    protected Collection<EClass> getReferrers(EClass eClass) {
        return this.getReferrers(eClass, true);
    }

    private Collection<EClass> getReferrers(EClass eClass, boolean includeAssociations) {
        TreeIterator acit;
        Resource eResource = eClass.eResource();
        if (eResource == null) {
            EPackage ePackage = eClass.getEPackage();
            if (ePackage == null) {
                return Collections.emptySet();
            }
            acit = ePackage.eAllContents();
        } else {
            ResourceSet resourceSet = eResource.getResourceSet();
            acit = resourceSet == null ? eResource.getAllContents() : resourceSet.getAllContents();
        }
        HashSet<EClass> ret = new HashSet<EClass>();
        acit.forEachRemaining(obj -> {
            if (obj instanceof EReference && ((EReference)obj).getEReferenceType() == eClass) {
                EClass referrer = ((EReference)obj).getEContainingClass();
                if (includeAssociations) {
                    for (EClass superReferrer : this.getReferrers(referrer, false)) {
                        for (EReference superReference : superReferrer.getEReferences()) {
                            EClass associationTarget;
                            if (superReference.getEReferenceType() != referrer || (associationTarget = NcoreUtil.getAssociationTarget((EReference)superReference)) != eClass) continue;
                            ret.add(superReferrer);
                        }
                    }
                }
                ret.add(referrer);
            }
        });
        return ret;
    }

    protected Collection<EClass> getUses(EClassifier eClassifier) {
        TreeIterator acit;
        Resource eResource = eClassifier.eResource();
        if (eResource == null) {
            EPackage ePackage = eClassifier.getEPackage();
            if (ePackage == null) {
                return Collections.emptySet();
            }
            acit = ePackage.eAllContents();
        } else {
            ResourceSet resourceSet = eResource.getResourceSet();
            acit = resourceSet == null ? eResource.getAllContents() : resourceSet.getAllContents();
        }
        HashSet<EClass> ret = new HashSet<EClass>();
        acit.forEachRemaining(obj -> {
            if (obj instanceof EClass && EmfUtil.collectTypeDependencies((EClass)((EClass)obj)).contains(eClassifier)) {
                ret.add((EClass)obj);
            }
        });
        return ret;
    }

    protected static String cardinality(ETypedElement typedElement) {
        int upperBound;
        int lowerBound = typedElement.getLowerBound();
        Object cardinality = lowerBound == (upperBound = typedElement.getUpperBound()) ? String.valueOf(lowerBound) : lowerBound + ".." + (upperBound == -1 ? "*" : String.valueOf(upperBound));
        if (typedElement instanceof EReference && ((EReference)typedElement).isContainment()) {
            cardinality = "<B>" + (String)cardinality + "</B>";
        }
        return cardinality;
    }

    protected String computeLabel(EGenericType genericType, ProgressMonitor monitor) {
        EObject container = genericType.eContainer();
        EClassifier rawType = genericType.getERawType();
        String rawTypeText = this.labelProvider.apply((ENamedElement)rawType, rawType.getName());
        if (container == null || !container.eIsSet(genericType.eContainingFeature())) {
            return rawTypeText;
        }
        StringBuilder label = new StringBuilder();
        if (genericType.getEClassifier() != null) {
            label.append(rawTypeText);
            if (!genericType.getETypeArguments().isEmpty()) {
                label.append("&lt;");
                Iterator i = genericType.getETypeArguments().iterator();
                while (i.hasNext()) {
                    EGenericType typeArgument = (EGenericType)i.next();
                    label.append(this.computeLabel(typeArgument, monitor));
                    if (!i.hasNext()) continue;
                    label.append(", ");
                }
                label.append("&gt;");
            }
        } else {
            ETypeParameter typeParameter = genericType.getETypeParameter();
            String name = typeParameter != null ? this.labelProvider.apply((ENamedElement)typeParameter, typeParameter.getName()) : "?";
            label.append(name);
            if (genericType.getELowerBound() != null) {
                label.append(" super ");
                label.append(this.computeLabel(genericType.getELowerBound(), monitor));
            } else if (genericType.getEUpperBound() != null) {
                label.append(" extends ");
                label.append(this.computeLabel(genericType.getEUpperBound(), monitor));
            }
        }
        return label.toString();
    }

    protected String typeParameters(EClassifier eClassifier) {
        if (eClassifier.getETypeParameters().isEmpty()) {
            return "";
        }
        StringBuilder typeParameters = new StringBuilder();
        for (ETypeParameter typeParameter : eClassifier.getETypeParameters()) {
            if (typeParameters.length() > 0) {
                typeParameters.append(",");
            }
            typeParameters.append(this.genericName(typeParameter));
        }
        return "&lt;" + typeParameters + "&gt;";
    }

    protected String genericName(ETypeParameter typeParameter) {
        StringBuilder ret = new StringBuilder(this.labelProvider.apply((ENamedElement)typeParameter, typeParameter.getName()));
        for (EGenericType bound : typeParameter.getEBounds()) {
            if (bound.getEUpperBound() != null) {
                ret.append(" extends ").append(this.genericName(bound.getEUpperBound()));
            }
            if (bound.getELowerBound() == null) continue;
            ret.append(" super ").append(this.genericName(bound.getELowerBound()));
        }
        return ret.toString();
    }

    protected String genericName(EGenericType eGenericType) {
        StringBuilder ret = new StringBuilder();
        ETypeParameter eTypeParameter = eGenericType.getETypeParameter();
        if (eTypeParameter != null) {
            ret.append(this.labelProvider.apply((ENamedElement)eTypeParameter, eTypeParameter.getName()));
        } else {
            EClassifier eClassifier = eGenericType.getEClassifier();
            if (eClassifier != null) {
                ret.append(this.labelProvider.apply((ENamedElement)eClassifier, eClassifier.getName()));
            }
        }
        ret.append(this.genericTypeArguments(eGenericType));
        return ret.toString();
    }

    protected String genericTypeArguments(EGenericType eGenericType) {
        StringBuilder ret = new StringBuilder();
        Iterator it = eGenericType.getETypeArguments().iterator();
        if (it.hasNext()) {
            ret.append("<");
            while (it.hasNext()) {
                ret.append(this.genericName((EGenericType)it.next()));
                if (!it.hasNext()) continue;
                ret.append(",");
            }
            ret.append(">");
        }
        return ret.toString();
    }

    protected void genericType(EGenericType eGenericType, EClassifier contextClassifier, Consumer<String> accumulator, ProgressMonitor monitor) {
        if (eGenericType == null) {
            accumulator.accept("void");
        } else {
            ETypeParameter eTypeParameter = eGenericType.getETypeParameter();
            if (eTypeParameter != null) {
                accumulator.accept(this.labelProvider.apply((ENamedElement)eTypeParameter, eTypeParameter.getName()));
            } else if (eGenericType.getEClassifier() != null) {
                accumulator.accept(this.link(eGenericType.getEClassifier(), contextClassifier));
                this.genericTypeArguments(eGenericType, contextClassifier, accumulator, monitor);
            } else {
                accumulator.accept("?");
                if (eGenericType.getELowerBound() != null) {
                    accumulator.accept(" super ");
                    this.genericType(eGenericType.getELowerBound(), contextClassifier, accumulator, monitor);
                } else if (eGenericType.getEUpperBound() != null) {
                    accumulator.accept(" extends ");
                    this.genericType(eGenericType.getEUpperBound(), contextClassifier, accumulator, monitor);
                }
            }
        }
    }

    protected String path(EClassifier eClassifier, EClassifier contextClassifier) {
        if (!this.elementPredicate.test((EModelElement)eClassifier)) {
            return null;
        }
        Resource targetResource = eClassifier.eResource();
        if (targetResource == null) {
            return null;
        }
        ResourceSet targetResourceSet = targetResource.getResourceSet();
        if (targetResourceSet != ((EModelElement)this.eObject).eResource().getResourceSet()) {
            return null;
        }
        String targetEPackagePath = this.encodeEPackage(eClassifier.getEPackage());
        if (Util.isBlank((String)targetEPackagePath)) {
            return null;
        }
        String targetPath = targetEPackagePath + "/" + eClassifier.getName() + ".html";
        String thisPath = null;
        if (contextClassifier == null) {
            if (this.eObject instanceof EClassifier) {
                contextClassifier = (EClassifier)this.eObject;
            } else if (((EModelElement)this.eObject).eContainer() instanceof EClassifier) {
                contextClassifier = (EClassifier)((EModelElement)this.eObject).eContainer();
            } else if (((EModelElement)this.eObject).eContainer() instanceof EOperation) {
                contextClassifier = (EClassifier)((EModelElement)this.eObject).eContainer().eContainer();
            }
        }
        if (contextClassifier != null) {
            thisPath = this.encodeEPackage(contextClassifier.getEPackage()) + "/" + contextClassifier.getName() + ".html";
        } else if (this.eObject instanceof EPackage) {
            thisPath = this.encodeEPackage((EPackage)this.eObject) + "/package-summary.html";
        }
        if (thisPath == null) {
            return null;
        }
        URI base = URI.createURI((String)this.context.getString("base-uri", "tmp://base/doc/"));
        URI target = URI.createURI((String)targetPath).resolve(base);
        URI source = URI.createURI((String)thisPath).resolve(base);
        URI relativeTarget = target.deresolve(source, true, true, true);
        return relativeTarget.toString();
    }

    protected String link(EClassifier eClassifier, EClassifier contextClassifier) {
        String path = this.path(eClassifier, contextClassifier);
        String label = this.labelProvider.apply((ENamedElement)eClassifier, eClassifier.getName());
        return Util.isBlank((String)path) ? label : "<a href=\"" + path + "\">" + label + "</a>";
    }

    protected String link(EStructuralFeature feature, EClassifier contextClassifier) {
        Object path = this.path((EClassifier)feature.getEContainingClass(), contextClassifier);
        String fragment = "#" + feature.eClass().getName() + "-" + feature.getName();
        path = Util.isBlank((String)path) ? fragment : (String)path + fragment;
        return "<a href=\"" + (String)path + "\">" + this.labelProvider.apply((ENamedElement)feature, feature.getName()) + "</a>";
    }

    protected void genericTypeArguments(EGenericType eGenericType, EClassifier contextClassifier, Consumer<String> accumulator, ProgressMonitor monitor) {
        Iterator it = eGenericType.getETypeArguments().iterator();
        if (it.hasNext()) {
            accumulator.accept("&lt;");
            while (it.hasNext()) {
                this.genericType((EGenericType)it.next(), contextClassifier, accumulator, monitor);
                if (!it.hasNext()) continue;
                accumulator.accept(",");
            }
            accumulator.accept("&gt;");
        }
    }

    public String encodeEPackage(EPackage ePackage) {
        Object ret = null;
        for (EPackage p = ePackage; p != null; p = p.getESuperPackage()) {
            String segment = this.ePackagePathComputer == null ? Hex.encodeHexString((byte[])p.getNsURI().getBytes(StandardCharsets.UTF_8)) : this.ePackagePathComputer.apply(p);
            ret = ret == null ? segment : segment + "/" + (String)ret;
        }
        return ret;
    }

    protected static void addContent(Action action, String content) {
        Text text = ContentFactory.eINSTANCE.createText();
        text.setContent(content);
        action.getContent().add((Object)text);
    }

    protected <T extends EModelElement> List<T> retainDocumentable(Collection<T> elements) {
        return elements.stream().filter(this.elementPredicate).collect(Collectors.toList());
    }
}

