/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.ecore;

import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.codec.binary.Hex;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.nasdanika.common.Context;
import org.nasdanika.common.MarkdownHelper;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.emf.EObjectAdaptable;
import org.nasdanika.emf.EmfUtil;
import org.nasdanika.html.app.impl.Util;
import org.nasdanika.html.ecore.EObjectViewActionStorable;

public class EModelElementViewActionStorable<T extends EModelElement>
extends EObjectViewActionStorable<T> {
    static final String CONTENT_KEY = "content";
    static final String APP_ACTION_KEY = "app-action";
    public static final String ICONS_BASE = "https://www.nasdanika.org/resources/images/ecore/";
    protected int descriptionTabLengthThreshold = 2500;
    protected Context context;
    private Function<EPackage, String> ePackagePathComputer;

    public EModelElementViewActionStorable(T value, Context context, Function<EPackage, String> ePackagePathComputer) {
        super(value);
        this.context = context;
        this.ePackagePathComputer = ePackagePathComputer;
    }

    public Map<String, Map<String, Object>> store(URL base, ProgressMonitor progressMonitor) throws Exception {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("icon", ICONS_BASE + ((EModelElement)this.eObject).eClass().getName() + ".gif");
        String markdown = EObjectAdaptable.getResourceContext((EObject)this.eObject).getString("documentation", EcoreUtil.getDocumentation((EModelElement)((EModelElement)this.eObject)));
        if (Util.isBlank((String)markdown)) {
            markdown = EmfUtil.getDocumentation((EModelElement)((EModelElement)this.eObject));
        }
        ArrayList<Map<String, Map<String, String>>> content = new ArrayList<Map<String, Map<String, String>>>();
        data.put(CONTENT_KEY, content);
        if (!Util.isBlank((String)markdown)) {
            content.add(EModelElementViewActionStorable.interpolatedMarkdown(markdown));
            data.put("tooltip", ((MarkdownHelper)this.context.computingContext().get(MarkdownHelper.class, (Object)MarkdownHelper.INSTANCE)).firstPlainTextSentence(markdown));
        }
        return Collections.singletonMap(APP_ACTION_KEY, data);
    }

    protected Map<String, Map<String, Object>> put(Map<String, Map<String, Object>> data, String key, Object value) {
        data.get(APP_ACTION_KEY).put(key, value);
        return data;
    }

    protected static Map<String, Map<String, String>> interpolatedMarkdown(String markdown) {
        return Collections.singletonMap("exec-styled-markdown", Collections.singletonMap("exec-interpolator", markdown));
    }

    protected static void addContent(Map<String, Map<String, Object>> data, Object ... content) {
        Collection dc = (Collection)data.get(APP_ACTION_KEY).get(CONTENT_KEY);
        for (Object ce : content) {
            dc.add(ce);
        }
    }

    protected String getEModelElementFirstDocSentence(EModelElement modelElement) {
        String markdown = EObjectAdaptable.getResourceContext((EObject)modelElement).getString("documentation", EcoreUtil.getDocumentation((EModelElement)modelElement));
        if (Util.isBlank((String)markdown)) {
            markdown = EmfUtil.getDocumentation((EModelElement)modelElement);
        }
        return Util.isBlank((String)markdown) ? null : ((MarkdownHelper)this.context.computingContext().get(MarkdownHelper.class, (Object)MarkdownHelper.INSTANCE)).firstPlainTextSentence(markdown);
    }

    protected Collection<EClass> getReferrers(EClass eClass) {
        TreeIterator acit;
        Resource eResource = eClass.eResource();
        if (eResource == null) {
            EPackage ePackage = eClass.getEPackage();
            if (ePackage == null) {
                return Collections.emptySet();
            }
            acit = ePackage.eAllContents();
        } else {
            ResourceSet resourceSet = eResource.getResourceSet();
            acit = resourceSet == null ? eResource.getAllContents() : resourceSet.getAllContents();
        }
        HashSet<EClass> ret = new HashSet<EClass>();
        acit.forEachRemaining(obj -> {
            if (obj instanceof EReference && ((EReference)obj).getEReferenceType() == eClass) {
                ret.add(((EReference)obj).getEContainingClass());
            }
        });
        return ret;
    }

    protected Collection<EClass> getUses(EClassifier eClassifier) {
        TreeIterator acit;
        Resource eResource = eClassifier.eResource();
        if (eResource == null) {
            EPackage ePackage = eClassifier.getEPackage();
            if (ePackage == null) {
                return Collections.emptySet();
            }
            acit = ePackage.eAllContents();
        } else {
            ResourceSet resourceSet = eResource.getResourceSet();
            acit = resourceSet == null ? eResource.getAllContents() : resourceSet.getAllContents();
        }
        HashSet<EClass> ret = new HashSet<EClass>();
        acit.forEachRemaining(obj -> {
            if (obj instanceof EClass && EmfUtil.collectTypeDependencies((EClass)((EClass)obj)).contains(eClassifier)) {
                ret.add((EClass)obj);
            }
        });
        return ret;
    }

    protected static String cardinality(ETypedElement typedElement) {
        int upperBound;
        int lowerBound = typedElement.getLowerBound();
        String cardinality = lowerBound == (upperBound = typedElement.getUpperBound()) ? String.valueOf(lowerBound) : lowerBound + ".." + (upperBound == -1 ? "*" : String.valueOf(upperBound));
        if (typedElement instanceof EReference && ((EReference)typedElement).isContainment()) {
            cardinality = "<B>" + cardinality + "</B>";
        }
        return cardinality;
    }

    protected String computeLabel(EGenericType genericType, ProgressMonitor monitor) throws Exception {
        EObject container = genericType.eContainer();
        EClassifier rawType = genericType.getERawType();
        String rawTypeText = rawType.getName();
        if (container == null || !container.eIsSet(genericType.eContainingFeature())) {
            return rawTypeText;
        }
        StringBuilder label = new StringBuilder();
        if (genericType.getEClassifier() != null) {
            label.append(rawTypeText);
            if (!genericType.getETypeArguments().isEmpty()) {
                label.append("&lt;");
                Iterator i = genericType.getETypeArguments().iterator();
                while (i.hasNext()) {
                    EGenericType typeArgument = (EGenericType)i.next();
                    label.append(this.computeLabel(typeArgument, monitor));
                    if (!i.hasNext()) continue;
                    label.append(", ");
                }
                label.append("&gt;");
            }
        } else {
            ETypeParameter typeParameter = genericType.getETypeParameter();
            String name = typeParameter != null ? typeParameter.getName() : "?";
            label.append(name);
            if (genericType.getELowerBound() != null) {
                label.append(" super ");
                label.append(this.computeLabel(genericType.getELowerBound(), monitor));
            } else if (genericType.getEUpperBound() != null) {
                label.append(" extends ");
                label.append(this.computeLabel(genericType.getEUpperBound(), monitor));
            }
        }
        return label.toString();
    }

    protected String typeParameters(EClassifier eClassifier) {
        if (eClassifier.getETypeParameters().isEmpty()) {
            return "";
        }
        StringBuilder typeParameters = new StringBuilder();
        for (ETypeParameter typeParameter : eClassifier.getETypeParameters()) {
            if (typeParameters.length() > 0) {
                typeParameters.append(",");
            }
            typeParameters.append(this.genericName(typeParameter));
        }
        return "&lt;" + typeParameters + "&gt;";
    }

    protected String genericName(ETypeParameter typeParameter) {
        StringBuilder ret = new StringBuilder(typeParameter.getName());
        for (EGenericType bound : typeParameter.getEBounds()) {
            if (bound.getEUpperBound() != null) {
                ret.append(" extends ").append(this.genericName(bound.getEUpperBound()));
            }
            if (bound.getELowerBound() == null) continue;
            ret.append(" super ").append(this.genericName(bound.getELowerBound()));
        }
        return ret.toString();
    }

    protected String genericName(EGenericType eGenericType) {
        StringBuilder ret = new StringBuilder();
        if (eGenericType.getETypeParameter() != null) {
            ret.append(eGenericType.getETypeParameter().getName());
        } else if (eGenericType.getEClassifier() != null) {
            ret.append(eGenericType.getEClassifier().getName());
        }
        ret.append(this.genericTypeArguments(eGenericType));
        return ret.toString();
    }

    protected String genericTypeArguments(EGenericType eGenericType) {
        StringBuilder ret = new StringBuilder();
        Iterator it = eGenericType.getETypeArguments().iterator();
        if (it.hasNext()) {
            ret.append("<");
            while (it.hasNext()) {
                ret.append(this.genericName((EGenericType)it.next()));
                if (!it.hasNext()) continue;
                ret.append(",");
            }
            ret.append(">");
        }
        return ret.toString();
    }

    protected void genericType(EGenericType eGenericType, List<Object> accumulator, ProgressMonitor monitor) throws Exception {
        if (eGenericType.getETypeParameter() != null) {
            accumulator.add(eGenericType.getETypeParameter().getName());
        } else if (eGenericType.getEClassifier() != null) {
            accumulator.add(this.link(eGenericType.getEClassifier()));
            this.genericTypeArguments(eGenericType, accumulator, monitor);
        } else {
            accumulator.add(Character.valueOf('?'));
            if (eGenericType.getELowerBound() != null) {
                accumulator.add(" super ");
                this.genericType(eGenericType.getELowerBound(), accumulator, monitor);
            } else if (eGenericType.getEUpperBound() != null) {
                accumulator.add(" extends ");
                this.genericType(eGenericType.getEUpperBound(), accumulator, monitor);
            }
        }
    }

    protected String path(EClassifier eClassifier) {
        Resource targetResource = eClassifier.eResource();
        if (targetResource == null) {
            return null;
        }
        ResourceSet targetResourceSet = targetResource.getResourceSet();
        if (targetResourceSet != ((EModelElement)this.eObject).eResource().getResourceSet()) {
            return null;
        }
        String targetEPackagePath = this.encodeEPackage(eClassifier.getEPackage());
        if (Util.isBlank((String)targetEPackagePath)) {
            return null;
        }
        String targetPath = targetEPackagePath + "/" + eClassifier.getName() + ".html";
        String thisPath = null;
        EClassifier contextClassifier = null;
        if (this.eObject instanceof EClassifier) {
            contextClassifier = (EClassifier)this.eObject;
        } else if (((EModelElement)this.eObject).eContainer() instanceof EClassifier) {
            contextClassifier = (EClassifier)((EModelElement)this.eObject).eContainer();
        }
        if (contextClassifier != null) {
            thisPath = this.encodeEPackage(contextClassifier.getEPackage()) + "/" + contextClassifier.getName() + ".html";
        } else if (this.eObject instanceof EPackage) {
            thisPath = this.encodeEPackage((EPackage)this.eObject) + "/package-summary.html";
        }
        if (thisPath == null) {
            return null;
        }
        URI base = URI.createURI((String)this.context.getString("base-uri", "tmp://base/doc/"));
        URI target = URI.createURI((String)targetPath).resolve(base);
        URI source = URI.createURI((String)thisPath).resolve(base);
        URI relativeTarget = target.deresolve(source, true, true, true);
        return relativeTarget.toString();
    }

    protected String link(EClassifier eClassifier) {
        String path = this.path(eClassifier);
        return Util.isBlank((String)path) ? eClassifier.getName() : "<a href=\"" + path + "\">" + eClassifier.getName() + "</a>";
    }

    protected void genericTypeArguments(EGenericType eGenericType, List<Object> accumulator, ProgressMonitor monitor) throws Exception {
        Iterator it = eGenericType.getETypeArguments().iterator();
        if (it.hasNext()) {
            accumulator.add("&lt;");
            while (it.hasNext()) {
                this.genericType((EGenericType)it.next(), accumulator, monitor);
                if (!it.hasNext()) continue;
                accumulator.add(",");
            }
            accumulator.add("&gt;");
        }
    }

    public String encodeEPackage(EPackage ePackage) {
        StringBuilder ret = new StringBuilder();
        for (EPackage p = ePackage; p != null; p = p.getESuperPackage()) {
            if (ret.length() > 0) {
                ret.append("/");
            }
            ret.append(this.ePackagePathComputer == null ? Hex.encodeHexString((byte[])ePackage.getNsURI().getBytes(StandardCharsets.UTF_8)) : this.ePackagePathComputer.apply(ePackage));
        }
        return ret.toString();
    }
}

