/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.ecore;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.nasdanika.common.Context;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.html.Fragment;
import org.nasdanika.html.HTMLFactory;
import org.nasdanika.html.Tag;
import org.nasdanika.html.TagName;
import org.nasdanika.html.app.SectionStyle;
import org.nasdanika.html.ecore.EClassifierViewActionStorable;

public class EEnumViewActionStorable
extends EClassifierViewActionStorable<EEnum> {
    public EEnumViewActionStorable(EEnum value, Context context, Function<EPackage, String> ePackagePathComputer) {
        super(value, context, ePackagePathComputer);
    }

    @Override
    public Map<String, Map<String, Object>> store(URL base, ProgressMonitor progressMonitor) throws Exception {
        Object data = super.store(base, progressMonitor);
        this.put((Map<String, Map<String, Object>>)data, "section-style", SectionStyle.DEFAULT.name().toLowerCase());
        ArrayList<Map<String, Map<String, Object>>> children = new ArrayList<Map<String, Map<String, Object>>>();
        children.add(this.createLiteralsAction(base, progressMonitor));
        Map<String, Map<String, Object>> usesAction = this.createUsesAction(base, progressMonitor);
        if (usesAction != null) {
            children.add(usesAction);
        }
        this.put((Map<String, Map<String, Object>>)data, "children", children);
        return data;
    }

    protected Map<String, Map<String, Object>> createLiteralsAction(URL base, ProgressMonitor progressMonitor) throws Exception {
        LinkedHashMap<String, Object> literalsData = new LinkedHashMap<String, Object>();
        literalsData.put("section-style", SectionStyle.TABLE.name().toLowerCase());
        literalsData.put("text", "Literals");
        literalsData.put("role", "section");
        ArrayList<Object> children = new ArrayList<Object>();
        for (EEnumLiteral literal : ((EEnum)this.eObject).getELiterals()) {
            children.add(this.adaptChild((EObject)literal).store(base, progressMonitor));
        }
        literalsData.put("children", children);
        return Collections.singletonMap("app-action", literalsData);
    }

    protected Map<String, Map<String, Object>> createUsesAction(URL base, ProgressMonitor progressMonitor) throws Exception {
        Collection uses = this.getUses().stream().sorted((a, b) -> a.getName().compareTo(b.getName())).collect(Collectors.toList());
        if (uses.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, String> usesData = new LinkedHashMap<String, String>();
        usesData.put("text", "Uses");
        usesData.put("role", "section");
        HTMLFactory htmlFactory = (HTMLFactory)this.context.get(HTMLFactory.class);
        Fragment gstf = htmlFactory.fragment(new Object[]{TagName.h3.create(new Object[]{"Uses"})});
        Tag list = TagName.ul.create(new Object[0]);
        gstf.content(new Object[]{list});
        for (EClass use : uses) {
            list.content(new Object[]{TagName.li.create(new Object[]{this.link((EClassifier)use)})});
        }
        usesData.put("content", gstf.toString());
        return Collections.singletonMap("app-action", usesData);
    }
}

