/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.model.bootstrap.gen;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.nasdanika.common.Context;
import org.nasdanika.common.Function;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.html.HTMLElement;
import org.nasdanika.html.RowContainer;
import org.nasdanika.html.bootstrap.RowContainer;
import org.nasdanika.html.model.bootstrap.TableCell;
import org.nasdanika.html.model.bootstrap.gen.BootstrapElementConsumerFactoryAdapter;

public class TableCellConsumerFactoryAdapter
extends BootstrapElementConsumerFactoryAdapter<TableCell, RowContainer.Row> {
    public TableCellConsumerFactoryAdapter(TableCell tableCell, AdapterFactory adapterFactory) {
        super(tableCell, adapterFactory);
    }

    @Override
    protected Function<HTMLElement<?>, HTMLElement<?>> createConfigureFunction(Context context) throws Exception {
        return this.getWrapper(context).then(this.createTableCellFunction(context)).then(this.toHTMLElement(context)).then(super.createConfigureFunction(context));
    }

    protected Function<RowContainer.Row, RowContainer.Row.Cell> createTableCellFunction(Context context) {
        return new Function<RowContainer.Row, RowContainer.Row.Cell>(){

            public double size() {
                return 1.0;
            }

            public String name() {
                return "Table cell";
            }

            public RowContainer.Row.Cell execute(RowContainer.Row row, ProgressMonitor progressMonitor) throws Exception {
                int rowSpan;
                TableCell semanticElement = (TableCell)TableCellConsumerFactoryAdapter.this.getTarget();
                RowContainer.Row.Cell ret = semanticElement.isHeader() ? row.header(new Object[0]) : row.cell(new Object[0]);
                int colSpan = semanticElement.getColSpan();
                if (colSpan > 0) {
                    ((RowContainer.Row.Cell)ret.toHTMLElement()).colspan(colSpan);
                }
                if ((rowSpan = semanticElement.getRowSpan()) > 0) {
                    ((RowContainer.Row.Cell)ret.toHTMLElement()).rowspan(rowSpan);
                }
                ret.color(semanticElement.getColor());
                ret.backgroundColor(semanticElement.getColor());
                return ret;
            }
        };
    }
}

