/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.model.bootstrap.gen;

import java.util.List;
import org.nasdanika.common.BiSupplier;
import org.nasdanika.common.Context;
import org.nasdanika.common.Function;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.common.SupplierFactory;
import org.nasdanika.common.persistence.ConfigurationException;
import org.nasdanika.html.HTMLFactory;
import org.nasdanika.html.HTMLPage;
import org.nasdanika.html.bootstrap.BootstrapFactory;
import org.nasdanika.html.model.bootstrap.Page;

public class PageSupplierFactoryAdapter
extends org.nasdanika.html.model.html.gen.PageSupplierFactoryAdapter {
    public PageSupplierFactoryAdapter(Page page) {
        super((org.nasdanika.html.model.html.Page)page);
    }

    public boolean isAdapterForType(Object type) {
        return type == SupplierFactory.class;
    }

    protected Function<BiSupplier<List<Object>, List<Object>>, HTMLPage> createPageFunction(final Context context) {
        return new Function<BiSupplier<List<Object>, List<Object>>, HTMLPage>(){

            public double size() {
                return 1.0;
            }

            public String name() {
                return "Bootstrap Page";
            }

            public HTMLPage execute(BiSupplier<List<Object>, List<Object>> headAndBody, ProgressMonitor progressMonitor) throws Exception {
                BootstrapFactory factory = (BootstrapFactory)context.get(BootstrapFactory.class, (Object)BootstrapFactory.INSTANCE);
                HTMLFactory htmlFactory = factory.getHTMLFactory();
                Page semanticElement = (Page)PageSupplierFactoryAdapter.this.getTarget();
                String pageName = context.interpolateToString(semanticElement.getName());
                HTMLPage ret = htmlFactory.page();
                ret.title((Object)pageName);
                ret.lang((Object)semanticElement.getLanguage());
                if (semanticElement.isCdn()) {
                    factory.bootstrapCdnHTMLPage(ret, semanticElement.getTheme());
                } else if (semanticElement.getTheme() != null) {
                    throw new ConfigurationException("Theme cannot be specified when 'cdn' is set to 'false'");
                }
                factory.bootstrapHTMLPage(ret);
                for (String styleseet : semanticElement.getStylesheets()) {
                    ret.stylesheet((Object)styleseet);
                }
                for (String script : semanticElement.getScripts()) {
                    ret.script((Object)script);
                }
                for (Object he : (List)headAndBody.getFirst()) {
                    ret.head(new Object[]{he});
                }
                for (Object he : (List)context.get("page/head", List.class)) {
                    ret.head(new Object[]{he});
                }
                for (Object be : (List)context.get("page/body", List.class)) {
                    ret.body(new Object[]{be});
                }
                for (Object be : (List)headAndBody.getSecond()) {
                    ret.body(new Object[]{be});
                }
                return ret;
            }
        };
    }
}

