/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.model.bootstrap.gen;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.nasdanika.common.BiSupplier;
import org.nasdanika.common.Consumer;
import org.nasdanika.common.Context;
import org.nasdanika.common.FunctionFactory;
import org.nasdanika.common.MapCompoundConsumerFactory;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.common.Supplier;
import org.nasdanika.common.SupplierFactory;
import org.nasdanika.common.Util;
import org.nasdanika.common.persistence.ConfigurationException;
import org.nasdanika.common.persistence.Marked;
import org.nasdanika.emf.EObjectAdaptable;
import org.nasdanika.html.Button;
import org.nasdanika.html.HTMLElement;
import org.nasdanika.html.HTMLFactory;
import org.nasdanika.html.Tag;
import org.nasdanika.html.bootstrap.BootstrapFactory;
import org.nasdanika.html.bootstrap.Breakpoint;
import org.nasdanika.html.model.bootstrap.BootstrapElement;
import org.nasdanika.html.model.bootstrap.BootstrapPackage;
import org.nasdanika.html.model.bootstrap.Modal;
import org.nasdanika.html.model.bootstrap.gen.BootstrapElementSupplierFactoryAdapter;

public class ModalSupplierFactoryAdapter
extends BootstrapElementSupplierFactoryAdapter<Modal, org.nasdanika.html.bootstrap.Modal> {
    public ModalSupplierFactoryAdapter(Modal modal, AdapterFactory adapterFactory) {
        super(modal, adapterFactory);
    }

    protected Supplier<BiSupplier<Map<EStructuralFeature, HTMLElement<?>>, org.nasdanika.html.bootstrap.Modal>> createModalSupplier(final Context context) {
        return new Supplier<BiSupplier<Map<EStructuralFeature, HTMLElement<?>>, org.nasdanika.html.bootstrap.Modal>>(){

            public double size() {
                return 1.0;
            }

            public String name() {
                return "Modal";
            }

            public BiSupplier<Map<EStructuralFeature, HTMLElement<?>>, org.nasdanika.html.bootstrap.Modal> execute(ProgressMonitor progressMonitor) throws Exception {
                BootstrapFactory bootstrapFactory = (BootstrapFactory)context.get(BootstrapFactory.class, (Object)BootstrapFactory.INSTANCE);
                final org.nasdanika.html.bootstrap.Modal modal = bootstrapFactory.modal();
                Modal semanticElement = (Modal)ModalSupplierFactoryAdapter.this.getTarget();
                modal.centered(semanticElement.isCentered());
                modal.scrollable(semanticElement.isScrollable());
                String size = semanticElement.getSize();
                if (!Util.isBlank((String)size)) {
                    switch (size) {
                        case "small": {
                            modal.size(Breakpoint.SMALL);
                            break;
                        }
                        case "large": {
                            modal.size(Breakpoint.LARGE);
                            break;
                        }
                        case "extra-large": {
                            modal.size(Breakpoint.EXTRA_LARGE);
                            break;
                        }
                        default: {
                            throw new ConfigurationException("Unsupported modal size: " + size, (Marked)EObjectAdaptable.adaptTo((EObject)semanticElement, Marked.class));
                        }
                    }
                }
                final LinkedHashMap<EReference, HTMLElement> parts = new LinkedHashMap<EReference, HTMLElement>();
                if (semanticElement.getHeader() != null) {
                    parts.put(BootstrapPackage.Literals.MODAL__HEADER, modal.getHeader().toHTMLElement());
                }
                if (semanticElement.getBody() != null) {
                    parts.put(BootstrapPackage.Literals.MODAL__BODY, modal.getBody().toHTMLElement());
                }
                if (semanticElement.getFooter() != null) {
                    parts.put(BootstrapPackage.Literals.MODAL__FOOTER, modal.getFooter().toHTMLElement());
                }
                return new BiSupplier<Map<EStructuralFeature, HTMLElement<?>>, org.nasdanika.html.bootstrap.Modal>(){

                    public Map<EStructuralFeature, HTMLElement<?>> getFirst() {
                        return parts;
                    }

                    public org.nasdanika.html.bootstrap.Modal getSecond() {
                        return modal;
                    }
                };
            }
        };
    }

    @Override
    protected Supplier<org.nasdanika.html.bootstrap.Modal> createBootstrapElementSupplier(final Context context) throws Exception {
        BootstrapElement footer;
        BootstrapElement body;
        MapCompoundConsumerFactory partsFactory = new MapCompoundConsumerFactory("Parts");
        Modal semanticElement = (Modal)this.getTarget();
        BootstrapElement header = semanticElement.getHeader();
        if (header != null) {
            partsFactory.put((Object)BootstrapPackage.Literals.MODAL__HEADER, EObjectAdaptable.adaptToConsumerFactoryNonNull((EObject)header, HTMLElement.class));
        }
        if ((body = semanticElement.getBody()) != null) {
            partsFactory.put((Object)BootstrapPackage.Literals.MODAL__BODY, EObjectAdaptable.adaptToConsumerFactoryNonNull((EObject)body, HTMLElement.class));
        }
        if ((footer = semanticElement.getFooter()) != null) {
            partsFactory.put((Object)BootstrapPackage.Literals.MODAL__FOOTER, EObjectAdaptable.adaptToConsumerFactoryNonNull((EObject)footer, HTMLElement.class));
        }
        SupplierFactory modalSupplierFactory = this::createModalSupplier;
        FunctionFactory partsFunctionFactory = partsFactory.asBiSupplierFunctionFactory();
        Consumer<org.nasdanika.html.bootstrap.Modal> dismisserBinder = new Consumer<org.nasdanika.html.bootstrap.Modal>(){

            public double size() {
                return 1.0;
            }

            public String name() {
                return "Binding dismisser";
            }

            public void execute(org.nasdanika.html.bootstrap.Modal modal, ProgressMonitor progressMonitor) throws Exception {
                Button dismisser = (Button)((HTMLFactory)context.get(HTMLFactory.class, (Object)HTMLFactory.INSTANCE)).button(new Object[]{"x"}).addClass(new Object[]{"close"});
                ((Tag)modal.getHeader().toHTMLElement()).content(new Object[]{dismisser});
                modal.bindDismisser((HTMLElement)dismisser);
            }
        };
        Supplier modalSupplier = (Supplier)modalSupplierFactory.then(partsFunctionFactory).create((Object)context);
        if (semanticElement.isDismisser() && header != null) {
            return modalSupplier.then(dismisserBinder.asFunction());
        }
        return modalSupplier;
    }
}

