/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.model.bootstrap.gen;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.nasdanika.common.ConsumerFactory;
import org.nasdanika.common.Context;
import org.nasdanika.common.Function;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.common.Supplier;
import org.nasdanika.emf.EObjectAdaptable;
import org.nasdanika.html.HTMLElement;
import org.nasdanika.html.model.bootstrap.Appearance;
import org.nasdanika.html.model.bootstrap.BootstrapElement;
import org.nasdanika.html.model.html.gen.HtmlElementSupplierFactoryAdapter;

public abstract class BootstrapElementSupplierFactoryAdapter<M extends BootstrapElement, T extends org.nasdanika.html.bootstrap.BootstrapElement<?, ?>>
extends HtmlElementSupplierFactoryAdapter<M, HTMLElement<?>> {
    public BootstrapElementSupplierFactoryAdapter(M bootstrapElement, AdapterFactory adapterFactory) {
        super(bootstrapElement, adapterFactory);
    }

    protected Function<HTMLElement<?>, HTMLElement<?>> createConfigureFunction(Context context) throws Exception {
        Appearance appearance = ((BootstrapElement)this.getTarget()).getAppearance();
        if (appearance == null) {
            return super.createConfigureFunction(context);
        }
        ConsumerFactory appearanceConsumerFactory = EObjectAdaptable.adaptToConsumerFactoryNonNull((EObject)appearance, HTMLElement.class);
        return super.createConfigureFunction(context).then((Function)appearanceConsumerFactory.asFunctionFactory().create((Object)context));
    }

    protected Supplier<HTMLElement<?>> createHTMLElementSupplier(Context context) throws Exception {
        return this.createBootstrapElementSupplier(context).then(new Function<T, HTMLElement<?>>(){

            public double size() {
                return 1.0;
            }

            public String name() {
                return "Bootstrap element to HTML element";
            }

            public HTMLElement<?> execute(T bootstrapElement, ProgressMonitor progressMonitor) throws Exception {
                return bootstrapElement.toHTMLElement();
            }
        });
    }

    protected Supplier<T> createBootstrapElementSupplier(Context context) throws Exception {
        throw new UnsupportedOperationException("Override this method or createHTMLElementSupplier()");
    }

    protected Function<HTMLElement<?>, T> getWrapper(Context context) {
        return new Function<HTMLElement<?>, T>(){

            public double size() {
                return 1.0;
            }

            public String name() {
                return "Retrieving wrapping bootstrap element";
            }

            public T execute(HTMLElement<?> htmlElement, ProgressMonitor progressMonitor) throws Exception {
                return (org.nasdanika.html.bootstrap.BootstrapElement)htmlElement.getData(org.nasdanika.html.bootstrap.BootstrapElement.class);
            }
        };
    }
}

