/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.model.bootstrap.gen;

import java.util.Collection;
import java.util.List;
import org.nasdanika.common.BiSupplier;
import org.nasdanika.common.Context;
import org.nasdanika.common.Function;
import org.nasdanika.common.ListCompoundSupplierFactory;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.common.Util;
import org.nasdanika.emf.EObjectAdaptable;
import org.nasdanika.html.Button;
import org.nasdanika.html.HTMLElement;
import org.nasdanika.html.HTMLFactory;
import org.nasdanika.html.Tag;
import org.nasdanika.html.TagName;
import org.nasdanika.html.model.bootstrap.Carousel;
import org.nasdanika.html.model.bootstrap.gen.DivSupplierFactoryAdapter;

public class CarouselSupplierFactoryAdapter
extends DivSupplierFactoryAdapter<Carousel> {
    public CarouselSupplierFactoryAdapter(Carousel carousel) {
        super(carousel);
    }

    @Override
    protected Function<Tag, Tag> createConfigureFunction(Context context) throws Exception {
        Function<BiSupplier<Tag, List<Object>>, Tag> carouselFunction = new Function<BiSupplier<Tag, List<Object>>, Tag>(){

            public double size() {
                return 1.0;
            }

            public String name() {
                return "Carousel";
            }

            public Tag execute(BiSupplier<Tag, List<Object>> input, ProgressMonitor progressMonitor) throws Exception {
                Tag tag = (Tag)input.getFirst();
                tag.addClass(new Object[]{"carousel", "slide"});
                Carousel semanticElement = (Carousel)CarouselSupplierFactoryAdapter.this.getTarget();
                if (semanticElement.isRide()) {
                    tag.attribute("data-ride", (Object)"carousel");
                }
                if (!Util.isBlank((String)semanticElement.getInterval())) {
                    tag.attribute("data-interval", (Object)semanticElement.getInterval());
                }
                List slides = (List)input.getSecond();
                HTMLFactory htmlFactory = tag.getFactory();
                Object id = tag.getId();
                if (id == null) {
                    id = htmlFactory.nextId();
                    tag.id(id);
                }
                Tag indicatorsList = null;
                if (semanticElement.isIndicator()) {
                    indicatorsList = (Tag)htmlFactory.tag(TagName.ol, new Object[0]).addClass(new Object[]{"carousel-indicators"});
                    tag.accept((Object)indicatorsList);
                }
                Tag carouselInner = (Tag)htmlFactory.div(new Object[0]).addClass(new Object[]{"carousel-inner"});
                tag.accept((Object)carouselInner);
                int index = 0;
                for (Object slide : slides) {
                    carouselInner.accept(slide);
                    Tag indicator = null;
                    if (indicatorsList != null) {
                        indicator = (Tag)((Tag)htmlFactory.tag(TagName.li, new Object[0]).attribute("data-target", (Object)("#" + id))).attribute("data-slide-to", (Object)index);
                        indicatorsList.accept((Object)indicator);
                    }
                    if (index == 0) {
                        ((HTMLElement)slide).addClass(new Object[]{"active"});
                        indicator.addClass(new Object[]{"active"});
                    }
                    ++index;
                }
                if (semanticElement.isControls()) {
                    Button prevButton = (Button)((Button)((Button)((Button)htmlFactory.button(new Object[0]).addClass(new Object[]{"carousel-control-prev", "border-0"})).attribute("type", (Object)"button")).attribute("data-target", (Object)("#" + id))).attribute("data-slide", (Object)"prev");
                    prevButton.accept((Object)((Tag)htmlFactory.span(new Object[0]).addClass(new Object[]{"carousel-control-prev-icon"})).attribute("aria-hidden", (Object)"true"));
                    prevButton.accept((Object)htmlFactory.span(new Object[]{"Previous"}).addClass(new Object[]{"sr-only"}));
                    tag.accept((Object)prevButton);
                    Button nextButton = (Button)((Button)((Button)((Button)htmlFactory.button(new Object[0]).addClass(new Object[]{"carousel-control-next", "border-0"})).attribute("type", (Object)"button")).attribute("data-target", (Object)("#" + id))).attribute("data-slide", (Object)"next");
                    nextButton.accept((Object)((Tag)htmlFactory.span(new Object[0]).addClass(new Object[]{"carousel-control-next-icon"})).attribute("aria-hidden", (Object)"true"));
                    nextButton.accept((Object)htmlFactory.span(new Object[]{"Next"}).addClass(new Object[]{"sr-only"}));
                    tag.accept((Object)nextButton);
                }
                if (semanticElement.isCrossFade()) {
                    tag.addClass(new Object[]{"carousel-fade"});
                }
                return tag;
            }
        };
        ListCompoundSupplierFactory slidesFactory = new ListCompoundSupplierFactory("Slides", (Collection)EObjectAdaptable.adaptToSupplierFactoryNonNull((Collection)((Carousel)this.getTarget()).getSlides(), Object.class));
        return super.createConfigureFunction(context).then(slidesFactory.create(context).asFunction()).then((Function)carouselFunction);
    }
}

