/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.model.bootstrap.gen;

import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.nasdanika.common.ConsumerFactory;
import org.nasdanika.common.Context;
import org.nasdanika.common.Function;
import org.nasdanika.common.FunctionFactory;
import org.nasdanika.common.ListCompoundSupplierFactory;
import org.nasdanika.common.MapCompoundSupplierFactory;
import org.nasdanika.common.SupplierFactory;
import org.nasdanika.emf.EObjectAdaptable;
import org.nasdanika.html.HTMLElement;
import org.nasdanika.html.bootstrap.BootstrapElement;
import org.nasdanika.html.bootstrap.BootstrapFactory;
import org.nasdanika.html.bootstrap.Breakpoint;
import org.nasdanika.html.bootstrap.Color;
import org.nasdanika.html.bootstrap.Placement;
import org.nasdanika.html.bootstrap.Size;
import org.nasdanika.html.bootstrap.Text;
import org.nasdanika.html.model.bootstrap.Appearance;
import org.nasdanika.html.model.bootstrap.Border;
import org.nasdanika.html.model.bootstrap.Float;
import org.nasdanika.html.model.bootstrap.Spacing;
import org.nasdanika.html.model.bootstrap.Text;
import org.nasdanika.html.model.html.HtmlPackage;
import org.nasdanika.html.model.html.gen.HtmlElementAdapter;

public class AppearanceConsumerFactoryAdapter
extends AdapterImpl
implements ConsumerFactory<HTMLElement<?>> {
    private Consumer<HTMLElement<?>> backgroundBuilder = htmlElement -> {
        Color background = this.getTarget().getBackground();
        if (background != null) {
            BootstrapElement bootstrapElement = BootstrapFactory.INSTANCE.wrap(htmlElement);
            bootstrapElement.background(background);
        }
    };
    private Consumer<HTMLElement<?>> borderBuilder = htmlElement -> {
        BootstrapElement bootstrapElement = BootstrapFactory.INSTANCE.wrap(htmlElement);
        for (Border border : this.getTarget().getBorder()) {
            Color color = border.getColor();
            if (border.isBottom() || border.isLeft() || border.isRight() || border.isTop()) {
                if (border.isBottom()) {
                    bootstrapElement.border(color, new Placement[]{Placement.BOTTOM});
                }
                if (border.isTop()) {
                    bootstrapElement.border(color, new Placement[]{Placement.TOP});
                }
                if (border.isLeft()) {
                    bootstrapElement.border(color, new Placement[]{Placement.LEFT});
                }
                if (!border.isRight()) continue;
                bootstrapElement.border(color, new Placement[]{Placement.RIGHT});
                continue;
            }
            bootstrapElement.border(color, new Placement[0]);
        }
        Color bgColor = this.getTarget().getBackground();
        if (bgColor != null) {
            bootstrapElement.background(bgColor);
        }
    };
    private Consumer<HTMLElement<?>> spacingBuilder = htmlElement -> {
        Breakpoint breakpoint;
        Size size;
        BootstrapElement bootstrapElement = BootstrapFactory.INSTANCE.wrap(htmlElement);
        for (Spacing margin : this.getTarget().getMargin()) {
            size = margin.getSize();
            breakpoint = margin.getBreakpoint();
            if (breakpoint == null) {
                breakpoint = Breakpoint.DEFAULT;
            }
            if (margin.isBottom() || margin.isLeft() || margin.isRight() || margin.isTop() || margin.isX() || margin.isY()) {
                if (margin.isBottom()) {
                    bootstrapElement.margin().bottom(breakpoint, size);
                }
                if (margin.isTop()) {
                    bootstrapElement.margin().top(breakpoint, size);
                }
                if (margin.isLeft()) {
                    bootstrapElement.margin().left(breakpoint, size);
                }
                if (margin.isRight()) {
                    bootstrapElement.margin().right(breakpoint, size);
                }
                if (margin.isX()) {
                    bootstrapElement.margin().x(breakpoint, size);
                }
                if (!margin.isY()) continue;
                bootstrapElement.margin().y(breakpoint, size);
                continue;
            }
            bootstrapElement.margin().all(breakpoint, size);
        }
        for (Spacing padding : this.getTarget().getPadding()) {
            size = padding.getSize();
            breakpoint = padding.getBreakpoint();
            if (breakpoint == null) {
                breakpoint = Breakpoint.DEFAULT;
            }
            if (padding.isBottom() || padding.isLeft() || padding.isRight() || padding.isTop() || padding.isX() || padding.isY()) {
                if (padding.isBottom()) {
                    bootstrapElement.padding().bottom(breakpoint, size);
                }
                if (padding.isTop()) {
                    bootstrapElement.padding().top(breakpoint, size);
                }
                if (padding.isLeft()) {
                    bootstrapElement.padding().left(breakpoint, size);
                }
                if (padding.isRight()) {
                    bootstrapElement.padding().right(breakpoint, size);
                }
                if (padding.isX()) {
                    bootstrapElement.padding().x(breakpoint, size);
                }
                if (!padding.isY()) continue;
                bootstrapElement.padding().y(breakpoint, size);
                continue;
            }
            bootstrapElement.padding().all(breakpoint, size);
        }
    };
    private Consumer<HTMLElement<?>> textBuilder = htmlElement -> {
        BootstrapElement bootstrapElement = BootstrapFactory.INSTANCE.wrap(htmlElement);
        Text text = this.getTarget().getText();
        if (text != null) {
            Text.Weight weight;
            Text.Transform transform;
            Text.Alignment alignment;
            org.nasdanika.html.bootstrap.Text bsText = bootstrapElement.text();
            Color color = text.getColor();
            if (color != null) {
                bsText.color(color);
            }
            if ((alignment = text.getAlignment()) != null) {
                bsText.alignment(alignment);
            }
            if ((transform = text.getTransform()) != null) {
                bsText.transform(transform);
            }
            if ((weight = text.getWeight()) != null) {
                bsText.weight(weight);
            }
            bsText.monospace(text.isMonospace());
            bsText.italic(text.isItalic());
            bsText.nowrap(text.isNowrap());
            bsText.truncate(text.isTruncate());
        }
    };
    private Consumer<HTMLElement<?>> floatBuilder = htmlElement -> {
        BootstrapElement bootstrapElement = BootstrapFactory.INSTANCE.wrap(htmlElement);
        block10: for (Float _float : this.getTarget().getFloat()) {
            org.nasdanika.html.bootstrap.Float bsFloat = bootstrapElement._float();
            Breakpoint breakpoint = _float.getBreakpoint();
            if (breakpoint == null) {
                breakpoint = Breakpoint.DEFAULT;
            }
            switch (_float.getSide()) {
                case "left": {
                    bsFloat.left(breakpoint);
                    continue block10;
                }
                case "right": {
                    bsFloat.right(breakpoint);
                    continue block10;
                }
                case "none": {
                    bsFloat.none(breakpoint);
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Invalid float side: " + _float.getSide() + ", shall be left, right, or none");
        }
    };

    public AppearanceConsumerFactoryAdapter(Appearance target) {
        this.setTarget((Notifier)target);
    }

    public Appearance getTarget() {
        return (Appearance)super.getTarget();
    }

    public org.nasdanika.common.Consumer<HTMLElement<?>> create(Context context) throws Exception {
        MapCompoundSupplierFactory attributesFactory = new MapCompoundSupplierFactory("Attributes");
        for (Map.Entry ae : this.getTarget().getAttributes()) {
            EObject value = (EObject)ae.getValue();
            attributesFactory.put((Object)((String)ae.getKey()), EObjectAdaptable.adaptToSupplierFactoryNonNull((EObject)value, Object.class));
        }
        ListCompoundSupplierFactory contentFactory = new ListCompoundSupplierFactory("Content", new SupplierFactory[0]);
        MapCompoundSupplierFactory configurationFactory = new MapCompoundSupplierFactory("Attributes and Content");
        configurationFactory.put((Object)HtmlPackage.Literals.HTML_ELEMENT__ATTRIBUTES, (SupplierFactory)attributesFactory);
        configurationFactory.put((Object)HtmlPackage.Literals.HTML_ELEMENT__CONTENT, (SupplierFactory)contentFactory);
        FunctionFactory configurationFunctionFactory = configurationFactory.asFunctionFactory();
        FunctionFactory applyAttributesAndContentFunctionFactory = HtmlElementAdapter::createApplyAttributesAndContentFunction;
        return ((Function)configurationFunctionFactory.then(applyAttributesAndContentFunctionFactory).create((Object)context)).then(org.nasdanika.common.Consumer.fromConsumer(this.backgroundBuilder, (String)"Background", (double)1.0).asFunction()).then(org.nasdanika.common.Consumer.fromConsumer(this.borderBuilder, (String)"Border", (double)1.0).asFunction()).then(org.nasdanika.common.Consumer.fromConsumer(this.spacingBuilder, (String)"Spacing", (double)1.0).asFunction()).then(org.nasdanika.common.Consumer.fromConsumer(this.textBuilder, (String)"Text", (double)1.0).asFunction()).then(org.nasdanika.common.Consumer.fromConsumer(this.floatBuilder, (String)"Float", (double)1.0));
    }
}

