/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.model.app.graph.emf;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.nasdanika.common.Diagnostic;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.common.Status;
import org.nasdanika.common.Transformer;
import org.nasdanika.common.Util;
import org.nasdanika.graph.Connection;
import org.nasdanika.graph.Element;
import org.nasdanika.graph.emf.EObjectGraphFactory;
import org.nasdanika.graph.emf.EObjectNode;
import org.nasdanika.graph.processor.NopEndpointProcessorConfigFactory;
import org.nasdanika.graph.processor.ProcessorInfo;
import org.nasdanika.graph.processor.emf.EObjectNodeProcessorReflectiveFactory;
import org.nasdanika.html.model.app.Label;
import org.nasdanika.html.model.app.Link;
import org.nasdanika.html.model.app.graph.WidgetFactory;
import org.nasdanika.html.model.app.graph.emf.EObjectReflectiveProcessorFactoryProvider;

public class ActionGenerator<F> {
    protected Collection<? extends EObject> sources;
    protected F nodeProcessorFactory;
    protected Collection<? extends EObject> references;
    protected Function<? super EObject, URI> uriResolver;

    public ActionGenerator(Collection<? extends EObject> sources, F nodeProcessorFactory, Collection<? extends EObject> references, Function<? super EObject, URI> uriResolver) {
        this.sources = sources;
        this.nodeProcessorFactory = nodeProcessorFactory;
        this.references = references;
        this.uriResolver = uriResolver;
    }

    public Map<EObject, Collection<Label>> generateActionModel(Consumer<Diagnostic> diagnosticConsumer, ProgressMonitor progressMonitor) {
        Transformer graphFactory = new Transformer(new Object[]{this.createGraphFactory()});
        Map graph = graphFactory.transform(this.sources, false, progressMonitor);
        Object configFactory = this.createConfigFactory();
        Transformer processorConfigTransformer = new Transformer(new Object[]{configFactory});
        Map configs = processorConfigTransformer.transform(graph.values(), false, progressMonitor);
        EObjectNodeProcessorReflectiveFactory<Object, Object> reflectiveFactory = this.createReflectiveFactory();
        EObjectReflectiveProcessorFactoryProvider eObjectReflectiveProcessorFactoryProvider = this.createReflectiveFactoryProvider(reflectiveFactory);
        Map registry = eObjectReflectiveProcessorFactoryProvider.getFactory(new Object[0]).createProcessors(configs.values(), false, progressMonitor);
        if (this.references != null) {
            for (EObject eObject : this.references) {
                URI uRI = this.uriResolver.apply((EObject)eObject);
                if (uRI == null) continue;
                for (Map.Entry re : registry.entrySet()) {
                    ProcessorInfo info;
                    Object processor;
                    EObjectNode eObjNode;
                    EObject target;
                    Element element = (Element)re.getKey();
                    if (!(element instanceof EObjectNode) || (target = (EObject)(eObjNode = (EObjectNode)element).get()) != eObject || !((processor = (info = (ProcessorInfo)re.getValue()).getProcessor()) instanceof WidgetFactory)) continue;
                    WidgetFactory widgetFactoryNodeProcessor = (WidgetFactory)processor;
                    widgetFactoryNodeProcessor.resolve(uRI, progressMonitor);
                }
            }
        }
        record SourceProcessorRecord(EObject source, URI uri, WidgetFactory widgetFactory) {
        }
        ArrayList<SourceProcessorRecord> sourceProcessorRecords = new ArrayList<SourceProcessorRecord>();
        for (EObject eObject : this.sources) {
            URI sourceURI = this.uriResolver.apply((EObject)eObject);
            for (Map.Entry re : registry.entrySet()) {
                ProcessorInfo info;
                Object processor;
                EObjectNode eObjNode;
                EObject target;
                Element element = (Element)re.getKey();
                if (!(element instanceof EObjectNode) || (target = (EObject)(eObjNode = (EObjectNode)element).get()) != eObject || !((processor = (info = (ProcessorInfo)re.getValue()).getProcessor()) instanceof WidgetFactory)) continue;
                WidgetFactory widgetFactoryNodeProcessor = (WidgetFactory)processor;
                if (sourceURI != null) {
                    widgetFactoryNodeProcessor.resolve(sourceURI, progressMonitor);
                }
                sourceProcessorRecords.add(new SourceProcessorRecord(eObject, sourceURI, widgetFactoryNodeProcessor));
            }
        }
        LinkedHashMap<EObject, Collection<Label>> linkedHashMap = new LinkedHashMap<EObject, Collection<Label>>();
        for (SourceProcessorRecord sourceProcessorRecord : sourceProcessorRecords) {
            Collection labels = (Collection)sourceProcessorRecord.widgetFactory().createLabelsSupplier().call(progressMonitor, diagnosticConsumer, new Status[0]);
            for (Label label : labels) {
                Link link;
                String location;
                if (!(label instanceof Link) || Util.isBlank((String)(location = (link = (Link)label).getLocation()))) continue;
                URI uri = URI.createURI((String)location);
                if (sourceProcessorRecord.uri() == null || uri.isRelative()) continue;
                link.setLocation("${base-uri}" + uri.deresolve(sourceProcessorRecord.uri(), true, true, true).toString());
            }
            linkedHashMap.put(sourceProcessorRecord.source(), labels);
        }
        return linkedHashMap;
    }

    protected EObjectReflectiveProcessorFactoryProvider createReflectiveFactoryProvider(Object reflectiveFactory) {
        return new EObjectReflectiveProcessorFactoryProvider(reflectiveFactory);
    }

    protected EObjectNodeProcessorReflectiveFactory<Object, Object> createReflectiveFactory() {
        return new EObjectNodeProcessorReflectiveFactory(new Object[]{this.nodeProcessorFactory});
    }

    protected Object createConfigFactory() {
        return new NopEndpointProcessorConfigFactory<Object>(){

            protected boolean isPassThrough(Connection connection) {
                return false;
            }
        };
    }

    protected Object createGraphFactory() {
        return new EObjectGraphFactory();
    }

    public void generateActionModel(Consumer<Diagnostic> diagnosticConsumer, URI actionModelResourceURI, ProgressMonitor progressMonitor) throws IOException {
        Map<EObject, Collection<Label>> labelMap = this.generateActionModel(diagnosticConsumer, progressMonitor);
        ActionGenerator.saveLabelMap(labelMap, actionModelResourceURI);
    }

    public static void saveLabelMap(Map<EObject, Collection<Label>> labelMap, URI actionModelResoureURI) throws IOException {
        ResourceSetImpl actionModelsResourceSet = new ResourceSetImpl();
        actionModelsResourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        Resource actionModelResource = actionModelsResourceSet.createResource(actionModelResoureURI);
        labelMap.values().stream().flatMap(Collection::stream).forEach(arg_0 -> actionModelResource.getContents().add(arg_0));
        actionModelResource.save(null);
    }

    public void generateActionModel(Consumer<Diagnostic> diagnosticConsumer, File actionModelFile, ProgressMonitor progressMonitor) throws IOException {
        this.generateActionModel(diagnosticConsumer, URI.createFileURI((String)actionModelFile.getCanonicalFile().getAbsolutePath()), progressMonitor);
    }
}

