/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.model.app.graph.emf;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.nasdanika.common.CollectionCompoundConsumer;
import org.nasdanika.common.Context;
import org.nasdanika.common.ExecutionException;
import org.nasdanika.common.MapCompoundSupplier;
import org.nasdanika.common.MarkdownHelper;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.common.Status;
import org.nasdanika.common.Supplier;
import org.nasdanika.common.SupplierFactory;
import org.nasdanika.common.Util;
import org.nasdanika.exec.content.ContentFactory;
import org.nasdanika.exec.content.Text;
import org.nasdanika.graph.Connection;
import org.nasdanika.graph.emf.EClassConnection;
import org.nasdanika.graph.emf.EObjectNode;
import org.nasdanika.graph.emf.EOperationConnection;
import org.nasdanika.graph.emf.EReferenceConnection;
import org.nasdanika.graph.processor.ChildProcessors;
import org.nasdanika.graph.processor.IncomingEndpoint;
import org.nasdanika.graph.processor.IncomingHandler;
import org.nasdanika.graph.processor.NodeProcessorConfig;
import org.nasdanika.graph.processor.OutgoingEndpoint;
import org.nasdanika.graph.processor.OutgoingHandler;
import org.nasdanika.graph.processor.ParentProcessor;
import org.nasdanika.graph.processor.ProcessorElement;
import org.nasdanika.graph.processor.ProcessorInfo;
import org.nasdanika.html.Tag;
import org.nasdanika.html.model.app.Action;
import org.nasdanika.html.model.app.AppFactory;
import org.nasdanika.html.model.app.Label;
import org.nasdanika.html.model.app.Link;
import org.nasdanika.html.model.app.gen.AppAdapterFactory;
import org.nasdanika.html.model.app.graph.WidgetFactory;
import org.nasdanika.html.model.app.graph.emf.ConnectionProcessor;
import org.nasdanika.html.model.app.graph.emf.IncomingOperationBuilder;
import org.nasdanika.html.model.app.graph.emf.IncomingReferenceBuilder;
import org.nasdanika.html.model.app.graph.emf.OutgoingOperationBuilder;
import org.nasdanika.html.model.app.graph.emf.OutgoingReferenceBuilder;
import org.nasdanika.html.model.bootstrap.BootstrapElement;
import org.nasdanika.html.model.bootstrap.BootstrapFactory;
import org.nasdanika.html.model.bootstrap.Modal;
import org.nasdanika.html.model.html.HtmlFactory;
import org.nasdanika.ncore.ModelElement;
import org.nasdanika.ncore.NamedElement;
import org.nasdanika.ncore.util.SemanticInfo;

public class EObjectNodeProcessor<T extends EObject>
implements WidgetFactory {
    private static final String HELP_DECORATOR_ICON = "far fa-question-circle";
    private static final String HELP_DECORATOR_STYLE = "vertical-align:super;font-size:x-small;margin-left:0.2em";
    private static AtomicInteger counter = new AtomicInteger();
    private int id = counter.incrementAndGet();
    public static WidgetFactory.Selector<EObject> TARGET_SELECTOR = (widgetFactory, base, progressMonitor) -> ((EObjectNodeProcessor)widgetFactory).getTarget();
    protected Function<ProgressMonitor, Action> prototypeProvider;
    protected NodeProcessorConfig<WidgetFactory, WidgetFactory> config;
    protected Context context;
    protected URI uri;
    protected Map<EObjectNode, ProcessorInfo<Object>> childProcessors;
    protected ConnectionProcessor parentProcessor;
    protected EObjectNode node;
    protected Map<EReferenceConnection, WidgetFactory> incomingReferenceEndpoints = new LinkedHashMap<EReferenceConnection, WidgetFactory>();
    protected Map<EReferenceConnection, WidgetFactory> outgoingReferenceEndpoints = new LinkedHashMap<EReferenceConnection, WidgetFactory>();
    protected Map<EOperationConnection, WidgetFactory> incomingOperationEndpoints = new LinkedHashMap<EOperationConnection, WidgetFactory>();
    protected Map<EOperationConnection, WidgetFactory> outgoingOperationEndpoints = new LinkedHashMap<EOperationConnection, WidgetFactory>();
    private WidgetFactory eClassWidgetFactory;

    public int getId() {
        return this.id;
    }

    public EObjectNodeProcessor(NodeProcessorConfig<WidgetFactory, WidgetFactory> config, Context context, Function<ProgressMonitor, Action> prototypeProvider) {
        this.config = config;
        this.context = context;
        this.prototypeProvider = prototypeProvider;
        this.uri = URI.createURI((String)"index.html");
    }

    @ChildProcessors
    public void setChildProcessors(Map<EObjectNode, ProcessorInfo<Object>> childProcessors) {
        this.childProcessors = childProcessors;
    }

    @ParentProcessor
    public void setParentProcessor(ConnectionProcessor parentProcessor) {
        this.parentProcessor = parentProcessor;
    }

    @ProcessorElement
    public void setNode(EObjectNode node) {
        this.node = node;
    }

    public T getTarget() {
        return (T)((EObject)this.node.get());
    }

    public NodeProcessorConfig<WidgetFactory, WidgetFactory> getConfig() {
        return this.config;
    }

    @IncomingEndpoint
    public void setIncomingRefernceEndpoint(EReferenceConnection connection, WidgetFactory endpoint) {
        this.incomingReferenceEndpoints.put(connection, endpoint);
    }

    @OutgoingEndpoint
    public void setOutgoingRefernceEndpoint(EReferenceConnection connection, WidgetFactory endpoint) {
        this.outgoingReferenceEndpoints.put(connection, endpoint);
    }

    @IncomingEndpoint
    public void setIncominOperationgEndpoint(EOperationConnection connection, WidgetFactory endpoint) {
        this.incomingOperationEndpoints.put(connection, endpoint);
    }

    @OutgoingEndpoint
    public void setOutgoingOperationEndpoint(EOperationConnection connection, WidgetFactory endpoint) {
        this.outgoingOperationEndpoints.put(connection, endpoint);
    }

    @IncomingHandler
    public WidgetFactory getIncomingHandler(Connection connection) {
        return this;
    }

    @OutgoingHandler
    public WidgetFactory getOutgoingHandler(Connection connection) {
        return this;
    }

    protected Collection<Label> createLabels(ProgressMonitor progressMonitor) {
        return Collections.singleton(this.createAction(progressMonitor));
    }

    protected Label createAction(ProgressMonitor progressMonitor) {
        Action action = this.createAction((EObject)this.getTarget(), progressMonitor);
        if (action.getDecorator() == null && this.eClassWidgetFactory != null) {
            Label helpDecorator = this.eClassWidgetFactory.createHelpDecorator(progressMonitor);
            action.setDecorator(helpDecorator);
        }
        return action;
    }

    protected Supplier<Collection<Label>> doCreateLabelsSupplier() {
        return new Supplier<Collection<Label>>(){

            public double size() {
                return 1.0;
            }

            public String name() {
                return "Labels supplier for " + EObjectNodeProcessor.this.getTarget();
            }

            public Collection<Label> execute(ProgressMonitor progressMonitor) {
                return EObjectNodeProcessor.this.createLabels(progressMonitor);
            }
        };
    }

    protected int compareIncomingReferences(EReference a, EReference b) {
        return a.getName().compareTo(b.getName());
    }

    protected int compareOutgoingReferences(EReference a, EReference b) {
        return a.getName().compareTo(b.getName());
    }

    protected int compareIncomingOperations(EOperation aOp, List<Object> aArgs, EOperation bOp, List<Object> bArgs) {
        return aOp.getName().compareTo(bOp.getName());
    }

    protected int compareOutgoingOperations(EOperation aOp, List<Object> aArgs, EOperation bOp, List<Object> bArgs) {
        return aOp.getName().compareTo(bOp.getName());
    }

    protected List<org.nasdanika.common.Consumer<Collection<Label>>> getReferenceLabelBuilders() {
        ArrayList<org.nasdanika.common.Consumer<Collection<Label>>> ret = new ArrayList<org.nasdanika.common.Consumer<Collection<Label>>>();
        Map groupedOutgoingReferenceEndpoints = Util.groupBy(this.outgoingReferenceEndpoints.entrySet(), e -> ((EReferenceConnection)e.getKey()).getReference());
        groupedOutgoingReferenceEndpoints.entrySet().stream().sorted((a, b) -> this.compareOutgoingReferences((EReference)a.getKey(), (EReference)b.getKey())).map(e -> this.createOutgoingReferenceLabelConsumer((EReference)e.getKey(), (List)e.getValue())).filter(Objects::nonNull).forEach(ret::add);
        Map groupedIncomingReferenceEndpoints = Util.groupBy(this.incomingReferenceEndpoints.entrySet(), e -> ((EReferenceConnection)e.getKey()).getReference());
        groupedIncomingReferenceEndpoints.entrySet().stream().sorted((a, b) -> this.compareIncomingReferences((EReference)a.getKey(), (EReference)b.getKey())).map(e -> this.createIncomingReferenceLabelConsumer((EReference)e.getKey(), (List)e.getValue())).filter(Objects::nonNull).forEach(ret::add);
        return ret;
    }

    protected List<org.nasdanika.common.Consumer<Collection<Label>>> getOperationLabelBuilders() {
        record Binding(EOperation operation, List<Object> arguments) {
        }
        ArrayList<org.nasdanika.common.Consumer<Collection<Label>>> ret = new ArrayList<org.nasdanika.common.Consumer<Collection<Label>>>();
        Map groupedOutgoingOperationEndpoints = Util.groupBy(this.outgoingOperationEndpoints.entrySet(), e -> new Binding(((EOperationConnection)e.getKey()).getOperation(), ((EOperationConnection)e.getKey()).getArguments()));
        groupedOutgoingOperationEndpoints.entrySet().stream().sorted((a, b) -> this.compareOutgoingOperations(((Binding)a.getKey()).operation(), ((Binding)a.getKey()).arguments(), ((Binding)b.getKey()).operation(), ((Binding)b.getKey()).arguments())).map(e -> this.createOutgoingOperationLabelConsumer(((Binding)e.getKey()).operation(), ((Binding)e.getKey()).arguments(), (List)e.getValue())).filter(Objects::nonNull).forEach(ret::add);
        Map groupedIncomingOperationEndpoints = Util.groupBy(this.incomingOperationEndpoints.entrySet(), e -> new Binding(((EOperationConnection)e.getKey()).getOperation(), ((EOperationConnection)e.getKey()).getArguments()));
        groupedIncomingOperationEndpoints.entrySet().stream().sorted((a, b) -> this.compareIncomingOperations(((Binding)a.getKey()).operation(), ((Binding)a.getKey()).arguments(), ((Binding)b.getKey()).operation(), ((Binding)b.getKey()).arguments())).map(e -> this.createIncomingOperationLabelConsumer(((Binding)e.getKey()).operation(), ((Binding)e.getKey()).arguments(), (List)e.getValue())).filter(Objects::nonNull).forEach(ret::add);
        return ret;
    }

    protected boolean isCallIncomingReferenceLabelsSuppliers(EReference eReference) {
        return false;
    }

    protected boolean isCallOutgoingReferenceLabelsSuppliers(EReference eReference) {
        return eReference != null && eReference.isContainment();
    }

    protected boolean isCallIncomingOperationLabelsSuppliers(EOperation eOperation, List<Object> arguments) {
        return false;
    }

    protected boolean isCallOutgoingOperationLabelsSuppliers(EOperation eOperation, List<Object> arguments) {
        return false;
    }

    protected org.nasdanika.common.Consumer<Collection<Label>> createIncomingReferenceLabelConsumer(EReference eReference, List<Map.Entry<EReferenceConnection, WidgetFactory>> referenceIncomingEndpoints) {
        MapCompoundSupplier endpointLabelsSupplier = new MapCompoundSupplier("Incoming reference endpoints supplier");
        if (this.isCallIncomingReferenceLabelsSuppliers(eReference)) {
            for (Map.Entry<EReferenceConnection, WidgetFactory> e : referenceIncomingEndpoints) {
                endpointLabelsSupplier.put((Object)e.getKey(), e.getValue().createLabelsSupplier());
            }
        }
        org.nasdanika.common.Consumer<Supplier.FunctionResult<Collection<Label>, Map<EReferenceConnection, Collection<Label>>>> referenceLabelBuilder = this.createIncomingReferenceLabelBuilder(eReference, referenceIncomingEndpoints);
        org.nasdanika.common.Function endpointLabelsFunction = endpointLabelsSupplier.asFunction();
        return endpointLabelsFunction.then(referenceLabelBuilder);
    }

    protected org.nasdanika.common.Consumer<Supplier.FunctionResult<Collection<Label>, Map<EReferenceConnection, Collection<Label>>>> createIncomingReferenceLabelBuilder(final EReference eReference, final List<Map.Entry<EReferenceConnection, WidgetFactory>> referenceIncomingEndpoints) {
        return new org.nasdanika.common.Consumer<Supplier.FunctionResult<Collection<Label>, Map<EReferenceConnection, Collection<Label>>>>(){

            public double size() {
                return 1.0;
            }

            public String name() {
                return "Incoming reference label builder";
            }

            public void execute(Supplier.FunctionResult<Collection<Label>, Map<EReferenceConnection, Collection<Label>>> arg, ProgressMonitor progressMonitor) {
                EObjectNodeProcessor.this.buildIncomingReference(eReference, referenceIncomingEndpoints, (Collection)arg.argument(), (Map)arg.result(), progressMonitor);
            }
        };
    }

    protected void buildIncomingReference(EReference eReference, List<Map.Entry<EReferenceConnection, WidgetFactory>> referenceIncomingEndpoints, Collection<Label> labels, Map<EReferenceConnection, Collection<Label>> incomingLabels, ProgressMonitor progressMonitor) {
        for (Method method : this.getClass().getMethods()) {
            IncomingReferenceBuilder irb = method.getAnnotation(IncomingReferenceBuilder.class);
            if (irb == null || eReference.getFeatureID() != irb.referenceID() || eReference.getEContainingClass().getClassifierID() != irb.classID() || !eReference.getEContainingClass().getEPackage().getNsURI().equals(irb.nsURI())) continue;
            if (!(method.getParameterCount() == 5 && method.getParameterTypes()[0].isInstance(eReference) && method.getParameterTypes()[1].isInstance(referenceIncomingEndpoints) && method.getParameterTypes()[2].isInstance(labels) && method.getParameterTypes()[3].isInstance(incomingLabels) && method.getParameterTypes()[4].isAssignableFrom(ProgressMonitor.class))) {
                throw new IllegalArgumentException("Incoming reference builder method shall have 5 parameters compatible with: EReference eReference, List<Entry<EReferenceConnection, WidgetFactory>> referenceIncomingEndpoints, Collection<Label> labels, Map<EReferenceConnection, Collection<Label>> incomingLabels, ProgressMonitor progressMonitor: " + method);
            }
            try {
                method.invoke((Object)this, eReference, referenceIncomingEndpoints, labels, incomingLabels, progressMonitor);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new ExecutionException((Throwable)e);
            }
        }
    }

    protected org.nasdanika.common.Consumer<Collection<Label>> createIncomingOperationLabelConsumer(EOperation eOperation, List<Object> arguments, List<Map.Entry<EOperationConnection, WidgetFactory>> operationIncomingEndpoints) {
        MapCompoundSupplier endpointLabelsSupplier = new MapCompoundSupplier("Incoming operation endpoints supplier");
        if (this.isCallIncomingOperationLabelsSuppliers(eOperation, arguments)) {
            for (Map.Entry<EOperationConnection, WidgetFactory> e : operationIncomingEndpoints) {
                endpointLabelsSupplier.put((Object)e.getKey(), e.getValue().createLabelsSupplier());
            }
        }
        org.nasdanika.common.Consumer<Supplier.FunctionResult<Collection<Label>, Map<EOperationConnection, Collection<Label>>>> operationLabelBuilder = this.createIncomingOperationLabelBuilder(eOperation, arguments, operationIncomingEndpoints);
        org.nasdanika.common.Function endpointLabelsFunction = endpointLabelsSupplier.asFunction();
        return endpointLabelsFunction.then(operationLabelBuilder);
    }

    protected org.nasdanika.common.Consumer<Supplier.FunctionResult<Collection<Label>, Map<EOperationConnection, Collection<Label>>>> createIncomingOperationLabelBuilder(final EOperation eOperation, final List<Object> arguments, final List<Map.Entry<EOperationConnection, WidgetFactory>> operationIncomingEndpoints) {
        return new org.nasdanika.common.Consumer<Supplier.FunctionResult<Collection<Label>, Map<EOperationConnection, Collection<Label>>>>(){

            public double size() {
                return 1.0;
            }

            public String name() {
                return "Incoming operation label builder";
            }

            public void execute(Supplier.FunctionResult<Collection<Label>, Map<EOperationConnection, Collection<Label>>> arg, ProgressMonitor progressMonitor) {
                EObjectNodeProcessor.this.buildIncomingOperation(eOperation, arguments, operationIncomingEndpoints, (Collection)arg.argument(), (Map)arg.result(), progressMonitor);
            }
        };
    }

    protected void buildIncomingOperation(EOperation eOperation, List<Object> arguments, List<Map.Entry<EOperationConnection, WidgetFactory>> operationIncomingEndpoints, Collection<Label> labels, Map<EOperationConnection, Collection<Label>> incomingLabels, ProgressMonitor progressMonitor) {
        for (Method method : this.getClass().getMethods()) {
            IncomingOperationBuilder iob = method.getAnnotation(IncomingOperationBuilder.class);
            if (iob == null || eOperation.getOperationID() != iob.operationID() || eOperation.getEContainingClass().getClassifierID() != iob.classID() || !eOperation.getEContainingClass().getEPackage().getNsURI().equals(iob.nsURI())) continue;
            if (!(method.getParameterCount() == 6 && method.getParameterTypes()[0].isInstance(eOperation) && method.getParameterTypes()[1].isInstance(arguments) && method.getParameterTypes()[3].isInstance(operationIncomingEndpoints) && method.getParameterTypes()[4].isInstance(labels) && method.getParameterTypes()[5].isInstance(incomingLabels) && method.getParameterTypes()[6].isAssignableFrom(ProgressMonitor.class))) {
                throw new IllegalArgumentException("Incoming operation builder method shall have 6 parameters compatible with: EOperation eOperation, List<Object> arguments, List<Entry<EOperationConnection, WidgetFactory>> operationIncomingEndpoints, Collection<Label> labels, Map<EOperationConnection, Collection<Label>> incomingLabels, ProgressMonitor progressMonitor: " + method);
            }
            try {
                method.invoke((Object)this, eOperation, arguments, operationIncomingEndpoints, labels, incomingLabels, progressMonitor);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new ExecutionException((Throwable)e);
            }
        }
    }

    protected org.nasdanika.common.Consumer<Collection<Label>> createOutgoingOperationLabelConsumer(EOperation eOperation, List<Object> arguments, List<Map.Entry<EOperationConnection, WidgetFactory>> operationOutgoingEndpoints) {
        MapCompoundSupplier endpointLabelsSupplier = new MapCompoundSupplier("Outgoing operation endpoints supplier");
        if (this.isCallOutgoingOperationLabelsSuppliers(eOperation, arguments)) {
            for (Map.Entry<EOperationConnection, WidgetFactory> e : operationOutgoingEndpoints) {
                endpointLabelsSupplier.put((Object)e.getKey(), e.getValue().createLabelsSupplier());
            }
        }
        org.nasdanika.common.Consumer<Supplier.FunctionResult<Collection<Label>, Map<EOperationConnection, Collection<Label>>>> operationLabelBuilder = this.createOutgoingOperationLabelBuilder(eOperation, arguments, operationOutgoingEndpoints);
        org.nasdanika.common.Function endpointLabelsFunction = endpointLabelsSupplier.asFunction();
        return endpointLabelsFunction.then(operationLabelBuilder);
    }

    protected org.nasdanika.common.Consumer<Supplier.FunctionResult<Collection<Label>, Map<EOperationConnection, Collection<Label>>>> createOutgoingOperationLabelBuilder(final EOperation eOperation, final List<Object> arguments, final List<Map.Entry<EOperationConnection, WidgetFactory>> operationOutgoingEndpoints) {
        return new org.nasdanika.common.Consumer<Supplier.FunctionResult<Collection<Label>, Map<EOperationConnection, Collection<Label>>>>(){

            public double size() {
                return 1.0;
            }

            public String name() {
                return "Outgoing operation label builder";
            }

            public void execute(Supplier.FunctionResult<Collection<Label>, Map<EOperationConnection, Collection<Label>>> arg, ProgressMonitor progressMonitor) {
                EObjectNodeProcessor.this.buildIncomingOperation(eOperation, arguments, operationOutgoingEndpoints, (Collection)arg.argument(), (Map)arg.result(), progressMonitor);
            }
        };
    }

    protected void buildOutgoingOperation(EOperation eOperation, List<Object> arguments, List<Map.Entry<EOperationConnection, WidgetFactory>> operationOutgoingEndpoints, Collection<Label> labels, Map<EOperationConnection, Collection<Label>> outgoingLabels, ProgressMonitor progressMonitor) {
        for (Method method : this.getClass().getMethods()) {
            OutgoingOperationBuilder oob = method.getAnnotation(OutgoingOperationBuilder.class);
            if (oob == null || eOperation.getOperationID() != oob.value()) continue;
            if (!(method.getParameterCount() == 6 && method.getParameterTypes()[0].isInstance(eOperation) && method.getParameterTypes()[1].isInstance(arguments) && method.getParameterTypes()[3].isInstance(operationOutgoingEndpoints) && method.getParameterTypes()[4].isInstance(labels) && method.getParameterTypes()[5].isInstance(outgoingLabels) && method.getParameterTypes()[6].isAssignableFrom(ProgressMonitor.class))) {
                throw new IllegalArgumentException("Outgoing operation builder method shall have 6 parameters compatible with: EOperation eOperation, List<Object> arguments, List<Entry<EOperationConnection, WidgetFactory>> operationOutgoingEndpoints, Collection<Label> labels, Map<EOperationConnection, Collection<Label>> outgoingLabels, ProgressMonitor progressMonitor: " + method);
            }
            try {
                method.invoke((Object)this, eOperation, arguments, operationOutgoingEndpoints, labels, outgoingLabels, progressMonitor);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new ExecutionException((Throwable)e);
            }
        }
    }

    protected org.nasdanika.common.Consumer<Collection<Label>> createOutgoingReferenceLabelConsumer(EReference eReference, List<Map.Entry<EReferenceConnection, WidgetFactory>> referenceOutgoingEndpoints) {
        MapCompoundSupplier endpointLabelsSupplier = new MapCompoundSupplier("Outgoing endpoints supplier");
        if (this.isCallOutgoingReferenceLabelsSuppliers(eReference)) {
            for (Map.Entry<EReferenceConnection, WidgetFactory> e : referenceOutgoingEndpoints) {
                endpointLabelsSupplier.put((Object)e.getKey(), e.getValue().createLabelsSupplier());
            }
        }
        org.nasdanika.common.Consumer<Supplier.FunctionResult<Collection<Label>, Map<EReferenceConnection, Collection<Label>>>> referenceLabelBuilder = this.createOutgoingReferenceLabelBuilder(eReference, referenceOutgoingEndpoints);
        org.nasdanika.common.Function endpointLabelsFunction = endpointLabelsSupplier.asFunction();
        return endpointLabelsFunction.then(referenceLabelBuilder);
    }

    protected org.nasdanika.common.Consumer<Supplier.FunctionResult<Collection<Label>, Map<EReferenceConnection, Collection<Label>>>> createOutgoingReferenceLabelBuilder(final EReference eReference, final List<Map.Entry<EReferenceConnection, WidgetFactory>> referenceOutgoingEndpoints) {
        return new org.nasdanika.common.Consumer<Supplier.FunctionResult<Collection<Label>, Map<EReferenceConnection, Collection<Label>>>>(){

            public double size() {
                return 1.0;
            }

            public String name() {
                return "Outgoing reference label builder";
            }

            public void execute(Supplier.FunctionResult<Collection<Label>, Map<EReferenceConnection, Collection<Label>>> arg, ProgressMonitor progressMonitor) {
                EObjectNodeProcessor.this.buildOutgoingReference(eReference, referenceOutgoingEndpoints, (Collection)arg.argument(), (Map)arg.result(), progressMonitor);
            }
        };
    }

    protected void buildOutgoingReference(EReference eReference, List<Map.Entry<EReferenceConnection, WidgetFactory>> referenceOutgoingEndpoints, Collection<Label> labels, Map<EReferenceConnection, Collection<Label>> outgoingLabels, ProgressMonitor progressMonitor) {
        for (Method method : this.getClass().getMethods()) {
            OutgoingReferenceBuilder orb = method.getAnnotation(OutgoingReferenceBuilder.class);
            if (orb == null || eReference.getFeatureID() != orb.value()) continue;
            if (!(method.getParameterCount() == 5 && method.getParameterTypes()[0].isInstance(eReference) && method.getParameterTypes()[1].isInstance(referenceOutgoingEndpoints) && method.getParameterTypes()[2].isInstance(labels) && method.getParameterTypes()[3].isInstance(outgoingLabels) && method.getParameterTypes()[4].isAssignableFrom(ProgressMonitor.class))) {
                throw new IllegalArgumentException("Outgoing reference builder method shall have 5 parameters compatible with: EReference eReference, List<Entry<EReferenceConnection, WidgetFactory>> referenceOutgoingEndpoints, Collection<Label> labels, Map<EReferenceConnection, Collection<Label>> outgoingLabels, ProgressMonitor progressMonitor: " + method);
            }
            try {
                method.invoke((Object)this, eReference, referenceOutgoingEndpoints, labels, outgoingLabels, progressMonitor);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new ExecutionException((Throwable)e);
            }
        }
        this.addReferenceChildren(eReference, labels, outgoingLabels, progressMonitor);
    }

    protected void addReferenceChildren(EReference eReference, Collection<Label> labels, Map<EReferenceConnection, Collection<Label>> outgoingLabels, ProgressMonitor progressMonitor) {
        for (Label tLabel : labels) {
            Label refLabel = this.createLabel((EObject)eReference, progressMonitor);
            for (Map.Entry<EReferenceConnection, Collection<Label>> re : outgoingLabels.entrySet()) {
                refLabel.getChildren().addAll(re.getValue());
            }
            if (refLabel.getChildren().isEmpty()) continue;
            tLabel.getChildren().add((Object)refLabel);
        }
    }

    @OutgoingEndpoint
    public final void setEClassEndpoint(EClassConnection connection, WidgetFactory eClassWidgetFactory) {
        this.eClassWidgetFactory = eClassWidgetFactory;
    }

    protected Action createAction(EObject eObject, ProgressMonitor progressMonitor) {
        Action action = this.newAction(eObject, progressMonitor);
        this.configureLabel(eObject, (Label)action, progressMonitor);
        return action;
    }

    protected Action newAction(EObject eObject, ProgressMonitor progressMonitor) {
        Action prototype;
        if (this.prototypeProvider != null && (prototype = this.prototypeProvider.apply(progressMonitor)) != null) {
            return prototype;
        }
        return AppFactory.eINSTANCE.createAction();
    }

    protected Link createLink(EObject eObject, String path, ProgressMonitor progressMonitor) {
        Link link = AppFactory.eINSTANCE.createLink();
        this.configureLabel(eObject, (Label)link, progressMonitor);
        if (Util.isBlank((String)path)) {
            link.setLocation(this.uri.toString());
        } else {
            link.setLocation(URI.createURI((String)path).resolve(this.uri).toString());
        }
        return link;
    }

    protected Label createLabel(EObject eObject, ProgressMonitor progressMonitor) {
        Label label = AppFactory.eINSTANCE.createLabel();
        this.configureLabel(eObject, label, progressMonitor);
        return label;
    }

    protected void configureLabel(EObject eObject, Label label, ProgressMonitor progressMonitor) {
        if (eObject instanceof NamedElement && Util.isBlank((String)label.getText())) {
            label.setText(StringEscapeUtils.escapeHtml4((String)((NamedElement)eObject).getName()));
        }
        if (label instanceof Link && this.uri != null) {
            ((Link)label).setLocation(this.uri.toString());
        }
        new SemanticInfo(eObject).annotate((ModelElement)label);
    }

    protected String render(Object object, ProgressMonitor progressMonitor) {
        if (object instanceof EObject) {
            Adapter adapter = AppAdapterFactory.INSTANCE.adapt((Notifier)((EObject)object), SupplierFactory.Provider.class);
            if (adapter instanceof SupplierFactory.Provider) {
                SupplierFactory supplierFactory = ((SupplierFactory.Provider)adapter).getFactory(Tag.class);
                Supplier supplier = (Supplier)supplierFactory.create((Object)this.context);
                Tag tag = (Tag)supplier.call(progressMonitor, null, new Status[]{Status.FAIL, Status.ERROR});
                return tag.toString();
            }
        } else if (object instanceof Iterable) {
            StringBuilder ret = new StringBuilder();
            ((Iterable)object).forEach(e -> ret.append(this.render(e, progressMonitor)));
            return ret.toString();
        }
        if (object instanceof Stream) {
            return ((Stream)object).map(e -> this.render(e, progressMonitor)).collect(Collectors.joining());
        }
        return object == null ? "" : object.toString();
    }

    @Override
    public void resolve(URI base, ProgressMonitor progressMonitor) {
        this.uri = this.uri.resolve(base);
        for (WidgetFactory oe : this.outgoingReferenceEndpoints.values()) {
            oe.resolve(this.uri, progressMonitor);
        }
        for (WidgetFactory ie : this.incomingReferenceEndpoints.values()) {
            ie.resolve(this.uri, progressMonitor);
        }
    }

    @Override
    public String createWidgetString(Object selector, URI base, ProgressMonitor progressMonitor) {
        return this.render(this.createWidget(selector, base, progressMonitor), progressMonitor);
    }

    @Override
    public String createLinkString(URI base, ProgressMonitor progressMonitor) {
        return this.render(this.createLink(base, progressMonitor), progressMonitor);
    }

    @Override
    public Object createLink(URI base, ProgressMonitor progressMonitor) {
        Link link = this.createLink((EObject)this.getTarget(), null, progressMonitor);
        link.rebase(null, base);
        return link;
    }

    protected void configureHelpModal(Modal helpModal) {
    }

    public static Label createHelpDecorator(String tooltip, String location, String title, String icon, Collection<EObject> contents, Consumer<Modal> modalConfigurator) {
        if ((contents == null || contents.isEmpty()) && Util.isBlank((String)location)) {
            if (Util.isBlank((String)tooltip)) {
                return null;
            }
            Label helpDecorator = AppFactory.eINSTANCE.createLabel();
            helpDecorator.setIcon(HELP_DECORATOR_ICON);
            helpDecorator.getAttributes().put((Object)"style", (Object)EObjectNodeProcessor.createText(HELP_DECORATOR_STYLE));
            helpDecorator.setTooltip(tooltip);
            return helpDecorator;
        }
        Link helpDecorator = AppFactory.eINSTANCE.createLink();
        helpDecorator.setIcon(HELP_DECORATOR_ICON);
        helpDecorator.getAttributes().put((Object)"style", (Object)EObjectNodeProcessor.createText(HELP_DECORATOR_STYLE));
        helpDecorator.setTooltip(tooltip);
        if (contents == null || contents.isEmpty()) {
            helpDecorator.setLocation(location);
        } else {
            Modal helpModal = BootstrapFactory.eINSTANCE.createModal();
            if (!Util.isBlank((String)title)) {
                BootstrapElement header = BootstrapFactory.eINSTANCE.createBootstrapElement();
                org.nasdanika.html.model.html.Tag h2 = HtmlFactory.eINSTANCE.createTag();
                h2.setName("H2");
                header.getContent().add((Object)h2);
                if (Util.isBlank((String)location)) {
                    Label tLabel = AppFactory.eINSTANCE.createLabel();
                    tLabel.setText(title);
                    tLabel.setIcon(icon);
                    h2.getContent().add((Object)tLabel);
                } else {
                    Link typeLink = AppFactory.eINSTANCE.createLink();
                    typeLink.setText(title);
                    typeLink.setIcon(icon);
                    typeLink.setLocation(location);
                    h2.getContent().add((Object)typeLink);
                }
                helpModal.setHeader(header);
            }
            BootstrapElement body = BootstrapFactory.eINSTANCE.createBootstrapElement();
            body.getContent().addAll(contents);
            helpModal.setBody(body);
            if (modalConfigurator != null) {
                modalConfigurator.accept(helpModal);
            }
            helpDecorator.setModal(helpModal);
        }
        return helpDecorator;
    }

    public static Label createHelpDecorator(String tooltip, String location, String title, String icon, String contents, Consumer<Modal> modalConfigurator) {
        return EObjectNodeProcessor.createHelpDecorator(tooltip, location, title, icon, Util.isBlank((String)contents) ? Collections.emptyList() : Collections.singleton(EObjectNodeProcessor.createText(contents)), modalConfigurator);
    }

    public Label createMarkdownHelpDecorator(String tooltip, String location, String title, String icon, String markdown, Consumer<Modal> modalConfigurator) {
        return EObjectNodeProcessor.createHelpDecorator(tooltip, location, title, icon, ((MarkdownHelper)this.context.get(MarkdownHelper.class, (Object)MarkdownHelper.INSTANCE)).markdownToHtml(markdown), modalConfigurator);
    }

    protected Collection<EObject> createHelpContents(URI base, ProgressMonitor progressMonitor) {
        return Collections.emptyList();
    }

    @Override
    public Label createHelpDecorator(URI base, ProgressMonitor progressMonitor) {
        Link link = this.createLink((EObject)this.getTarget(), null, progressMonitor);
        link.rebase(null, base);
        Collection<EObject> helpContents = this.createHelpContents(base, progressMonitor);
        return EObjectNodeProcessor.createHelpDecorator(link.getTooltip(), link.getLocation(), link.getText(), link.getIcon(), helpContents, this::configureHelpModal);
    }

    @Override
    public Supplier<Collection<Label>> createLabelsSupplier() {
        List<org.nasdanika.common.Consumer<Collection<Label>>> referenceLabelBuilders = this.getReferenceLabelBuilders();
        List<org.nasdanika.common.Consumer<Collection<Label>>> operationLabelBuilders = this.getOperationLabelBuilders();
        if (referenceLabelBuilders == null && operationLabelBuilders == null || referenceLabelBuilders.isEmpty() && operationLabelBuilders.isEmpty()) {
            return this.doCreateLabelsSupplier();
        }
        CollectionCompoundConsumer collectionCompoundConsumer = new CollectionCompoundConsumer("Reference Label Builder", new org.nasdanika.common.Consumer[0]);
        referenceLabelBuilders.forEach(arg_0 -> ((CollectionCompoundConsumer)collectionCompoundConsumer).add(arg_0));
        operationLabelBuilders.forEach(arg_0 -> ((CollectionCompoundConsumer)collectionCompoundConsumer).add(arg_0));
        return this.doCreateLabelsSupplier().then(collectionCompoundConsumer.asFunction());
    }

    @Override
    public String createLabelString(ProgressMonitor progressMonitor) {
        return this.render(this.createLabel(progressMonitor), progressMonitor);
    }

    @Override
    public Object createLabel(ProgressMonitor progressMonitor) {
        return this.createLabel((EObject)this.getTarget(), progressMonitor);
    }

    protected static void addContent(Action action, String content) {
        Text text = ContentFactory.eINSTANCE.createText();
        text.setContent(content);
        action.getContent().add((Object)text);
    }

    public static Text createText(String content) {
        Text text = ContentFactory.eINSTANCE.createText();
        text.setContent(content);
        return text;
    }
}

