/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.model.app.graph.emf;

import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.common.Supplier;
import org.nasdanika.graph.emf.EOperationConnection;
import org.nasdanika.graph.emf.EReferenceConnection;
import org.nasdanika.graph.emf.QualifiedConnection;
import org.nasdanika.graph.processor.ConnectionProcessorConfig;
import org.nasdanika.html.model.app.Label;
import org.nasdanika.html.model.app.Link;
import org.nasdanika.html.model.app.graph.WidgetFactory;

public class ConnectionProcessor {
    protected URI sourceURI;
    protected URI targetURI;
    protected ConnectionProcessorConfig<WidgetFactory, WidgetFactory> config;

    public ConnectionProcessor(ConnectionProcessorConfig<WidgetFactory, WidgetFactory> config) {
        this.config = config;
        config.getSourceEndpoint().thenAccept(se -> config.setTargetHandler((Object)this.createTargetHandler((WidgetFactory)se)));
        config.getTargetEndpoint().thenAccept(te -> config.setSourceHandler((Object)this.createSourceHandler((WidgetFactory)te)));
    }

    protected WidgetFactory createTargetHandler(final WidgetFactory sourceEndpoint) {
        return new WidgetFactory(){

            @Override
            public void resolve(URI base, ProgressMonitor progressMonitor) {
                ConnectionProcessor.this.targetURI = base;
            }

            private URI resolveBase(URI base) {
                if (base == null) {
                    return ConnectionProcessor.this.targetURI;
                }
                if (base.isRelative() && ConnectionProcessor.this.targetURI != null && !ConnectionProcessor.this.targetURI.isRelative()) {
                    return base.resolve(ConnectionProcessor.this.targetURI);
                }
                return base;
            }

            @Override
            public String createWidgetString(Object selector, URI base, ProgressMonitor progressMonitor) {
                if (selector instanceof WidgetFactory.Selector) {
                    return (String)this.createWidget((WidgetFactory.Selector)selector, base, progressMonitor);
                }
                return sourceEndpoint.createWidgetString(selector, this.resolveBase(base), progressMonitor);
            }

            @Override
            public Object createWidget(Object selector, URI base, ProgressMonitor progressMonitor) {
                if (selector instanceof WidgetFactory.Selector) {
                    return this.createWidget((WidgetFactory.Selector)selector, base, progressMonitor);
                }
                return sourceEndpoint.createWidget(selector, this.resolveBase(base), progressMonitor);
            }

            @Override
            public <T> T createWidget(WidgetFactory.Selector<T> selector, URI base, ProgressMonitor progressMonitor) {
                if (selector instanceof WidgetFactory.ConnectionSelector) {
                    return selector.createWidget(this, this.resolveBase(base), progressMonitor);
                }
                return sourceEndpoint.createWidget(selector, this.resolveBase(base), progressMonitor);
            }

            @Override
            public String createLinkString(URI base, ProgressMonitor progressMonitor) {
                return sourceEndpoint.createLinkString(this.resolveBase(base), progressMonitor);
            }

            @Override
            public Object createLink(URI base, ProgressMonitor progressMonitor) {
                return sourceEndpoint.createLink(this.resolveBase(base), progressMonitor);
            }

            @Override
            public Supplier<Collection<Label>> createLabelsSupplier() {
                return sourceEndpoint.createLabelsSupplier().then(labels -> {
                    for (Label label : labels) {
                        if (!(label instanceof Link)) continue;
                        ((Link)label).rebase(ConnectionProcessor.this.targetURI, ConnectionProcessor.this.sourceURI);
                    }
                    return labels;
                });
            }

            @Override
            public String createLabelString(ProgressMonitor progressMonitor) {
                return sourceEndpoint.createLabelString(progressMonitor);
            }

            @Override
            public Object createLabel(ProgressMonitor progressMonitor) {
                return sourceEndpoint.createLabel(progressMonitor);
            }
        };
    }

    protected WidgetFactory createSourceHandler(final WidgetFactory targetEndpoint) {
        return new WidgetFactory(){

            @Override
            public void resolve(URI base, ProgressMonitor progressMonitor) {
                ConnectionProcessor.this.sourceURI = base;
                QualifiedConnection conn = (QualifiedConnection)ConnectionProcessor.this.config.getElement();
                String path = conn.getPath();
                if (conn instanceof EReferenceConnection) {
                    EReference eRef = ((EReferenceConnection)conn).getReference();
                    if (eRef.isContainment()) {
                        String uriStr = "references/" + eRef.getName() + "/";
                        if (path != null) {
                            uriStr = uriStr + path + "/";
                        }
                        URI refURI = URI.createURI((String)uriStr);
                        targetEndpoint.resolve(refURI.resolve(base), progressMonitor);
                    }
                } else if (conn instanceof EOperationConnection) {
                    EOperation eOp = ((EOperationConnection)conn).getOperation();
                    String uriStr = "operations/" + eOp.getName() + "/";
                    if (path != null) {
                        uriStr = uriStr + path + "/";
                    }
                    URI refURI = URI.createURI((String)uriStr);
                    targetEndpoint.resolve(refURI.resolve(base), progressMonitor);
                }
            }

            private URI resolveBase(URI base) {
                if (base == null) {
                    return ConnectionProcessor.this.sourceURI;
                }
                if (base.isRelative() && ConnectionProcessor.this.sourceURI != null && !ConnectionProcessor.this.sourceURI.isRelative()) {
                    return base.resolve(ConnectionProcessor.this.sourceURI);
                }
                return base;
            }

            @Override
            public String createWidgetString(Object selector, URI base, ProgressMonitor progressMonitor) {
                if (selector instanceof WidgetFactory.Selector) {
                    return (String)this.createWidget((WidgetFactory.Selector)selector, base, progressMonitor);
                }
                return targetEndpoint.createWidgetString(selector, this.resolveBase(base), progressMonitor);
            }

            @Override
            public Object createWidget(Object selector, URI base, ProgressMonitor progressMonitor) {
                if (selector instanceof WidgetFactory.Selector) {
                    return this.createWidget((WidgetFactory.Selector)selector, base, progressMonitor);
                }
                return targetEndpoint.createWidget(selector, this.resolveBase(base), progressMonitor);
            }

            @Override
            public <T> T createWidget(WidgetFactory.Selector<T> selector, URI base, ProgressMonitor progressMonitor) {
                if (selector instanceof WidgetFactory.ConnectionSelector) {
                    return selector.createWidget(this, this.resolveBase(base), progressMonitor);
                }
                return targetEndpoint.createWidget(selector, this.resolveBase(base), progressMonitor);
            }

            @Override
            public String createLinkString(URI base, ProgressMonitor progressMonitor) {
                return targetEndpoint.createLinkString(this.resolveBase(base), progressMonitor);
            }

            @Override
            public Object createLink(URI base, ProgressMonitor progressMonitor) {
                return targetEndpoint.createLink(this.resolveBase(base), progressMonitor);
            }

            @Override
            public Supplier<Collection<Label>> createLabelsSupplier() {
                return targetEndpoint.createLabelsSupplier().then(labels -> {
                    for (Label label : labels) {
                        if (!(label instanceof Link)) continue;
                        ((Link)label).rebase(ConnectionProcessor.this.targetURI, ConnectionProcessor.this.sourceURI);
                    }
                    return labels;
                });
            }

            @Override
            public String createLabelString(ProgressMonitor progressMonitor) {
                return targetEndpoint.createLabelString(progressMonitor);
            }

            @Override
            public Object createLabel(ProgressMonitor progressMonitor) {
                return targetEndpoint.createLabel(progressMonitor);
            }
        };
    }
}

