/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.injector.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;

class AnnotationUtil {
    AnnotationUtil() {
    }

    static boolean isSingleton(Annotation annotation) {
        return annotation.annotationType().getCanonicalName().endsWith(".Singleton");
    }

    static boolean isInject(Annotation annotation) {
        return annotation.annotationType().getCanonicalName().endsWith(".Inject");
    }

    static boolean hasInjectAnnotation(Constructor<?> constructor) {
        Annotation[] annotations;
        for (Annotation a : annotations = constructor.getDeclaredAnnotations()) {
            if (!AnnotationUtil.isInject(a)) continue;
            return true;
        }
        return false;
    }

    static boolean hasInjectAnnotation(Field field) {
        Annotation[] annotations;
        for (Annotation a : annotations = field.getDeclaredAnnotations()) {
            if (!AnnotationUtil.isInject(a)) continue;
            return true;
        }
        return false;
    }
}

