/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.injector;

import java.util.HashMap;
import javax.inject.Provider;
import org.nanoj.injector.Injector;
import org.nanoj.injector.InjectorConfiguration;
import org.nanoj.injector.aop.InterceptorProvider;
import org.nanoj.injector.impl.InjectorImpl;

public class InjectorFactory {
    public static final Injector createInjector(String name, InjectorConfiguration configuration) {
        HashMap<Class<?>, Class<?>> implementationsClasses = configuration.getImplementationClasses();
        HashMap<Class<?>, Provider<?>> implementationProviders = configuration.getImplementationProviders();
        String[] implementationsConventions = configuration.getImplementationConventions();
        InterceptorProvider[] interceptorProviders = configuration.getInterceptorProviders();
        InjectorImpl injector = new InjectorImpl(name, implementationsClasses, implementationsConventions, implementationProviders, interceptorProviders);
        return injector;
    }

    public static final Injector createInjector(String name) {
        InjectorConfiguration configuration = new InjectorConfiguration();
        configuration.defineImplementationConvention("${package}.${class}Impl");
        configuration.defineImplementationConvention("${package}.impl.${class}Impl");
        return InjectorFactory.createInjector(name, configuration);
    }
}

