/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.injector;

import java.util.HashMap;
import java.util.LinkedList;
import javax.inject.Provider;
import org.nanoj.injector.aop.InterceptorProvider;
import org.nanoj.injector.tools.ClassTools;

public class InjectorConfiguration {
    private static final String[] VOID_STRING_ARRAY = new String[0];
    private static final InterceptorProvider[] VOID_INTERCEPTOR_PROVIDER_ARRAY = new InterceptorProvider[0];
    private final HashMap<Class<?>, Class<?>> _hmImplementationClasses = new HashMap(128);
    private final HashMap<Class<?>, Provider<?>> _hmImplementationProviders = new HashMap(128);
    private final LinkedList<String> _implementationConventions = new LinkedList();
    private final LinkedList<InterceptorProvider> _interceptorProviders = new LinkedList();

    public <T> void defineImplementationClass(Class<T> abstractClass, Class<? extends T> implementationClass) {
        if (!abstractClass.isAssignableFrom(implementationClass)) {
            throw new IllegalArgumentException(implementationClass.getCanonicalName() + " is not an immplementation of " + abstractClass.getCanonicalName());
        }
        if (implementationClass.isInterface()) {
            throw new IllegalArgumentException(implementationClass.getCanonicalName() + " must be a concrete class (not an interface) ");
        }
        if (ClassTools.isAbstract(implementationClass)) {
            throw new IllegalArgumentException(implementationClass.getCanonicalName() + " must be a concrete class (not an abstract class) ");
        }
        this._hmImplementationClasses.put(abstractClass, implementationClass);
    }

    protected HashMap<Class<?>, Class<?>> getImplementationClasses() {
        return this._hmImplementationClasses;
    }

    public void defineImplementationConvention(String pattern) {
        this._implementationConventions.add(pattern);
    }

    protected String[] getImplementationConventions() {
        return this._implementationConventions.toArray(VOID_STRING_ARRAY);
    }

    public <T> void defineImplementationProvider(Class<T> abstractClass, Provider<T> provider) {
        this._hmImplementationProviders.put(abstractClass, provider);
    }

    protected HashMap<Class<?>, Provider<?>> getImplementationProviders() {
        return this._hmImplementationProviders;
    }

    public void defineInterceptorProvider(InterceptorProvider interceptorProvider) {
        if (null == interceptorProvider) {
            throw new IllegalArgumentException("InterceptorProvider is null");
        }
        this._interceptorProviders.add(interceptorProvider);
    }

    protected InterceptorProvider[] getInterceptorProviders() {
        return this._interceptorProviders.toArray(VOID_INTERCEPTOR_PROVIDER_ARRAY);
    }
}

