/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.util.tson;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedList;

public class ParserUtil {
    private static void log(String msg) {
    }

    private static Method findMethodByName(Class<?> beanClass, String sMethodName) {
        Method[] methods = beanClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!sMethodName.equals(m.getName())) continue;
            return m;
        }
        return null;
    }

    private static void invokeSetterMethod(Method method, Object oBean, Object oValue) {
        Object[] args = new Object[]{oValue};
        try {
            method.invoke(oBean, args);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("invokeSetterMethod : IllegalArgumentException ", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("invokeSetterMethod : IllegalAccessException ", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("invokeSetterMethod : InvocationTargetException ", e);
        }
    }

    private static Object convertParam(Object oValue, Class<?> cType, String sFieldName) {
        String sTypeName = cType.getName();
        ParserUtil.log("convertParam : type name = '" + sTypeName + "'");
        if (oValue == null) {
            if (cType.isPrimitive()) {
                throw new RuntimeException("Cannot set null value : primitive type '" + sTypeName + "'");
            }
            return null;
        }
        if (oValue instanceof String) {
            if ("java.lang.String".equals(sTypeName)) {
                return oValue;
            }
            throw new RuntimeException("Cannot set string in field '" + sFieldName + "' ");
        }
        if (oValue instanceof Boolean) {
            if ("java.lang.Boolean".equals(sTypeName) || "boolean".equals(sTypeName)) {
                return oValue;
            }
            throw new RuntimeException("Cannot set boolean in field '" + sFieldName + "' ");
        }
        if (oValue instanceof Date) {
            Date date = (Date)oValue;
            if ("java.util.Date".equals(sTypeName)) {
                return date;
            }
            if ("java.sql.Date".equals(sTypeName)) {
                return new java.sql.Date(date.getTime());
            }
            if ("java.sql.Time".equals(sTypeName)) {
                return new Time(date.getTime());
            }
            if ("java.sql.Timestamp".equals(sTypeName)) {
                return new Timestamp(date.getTime());
            }
            throw new RuntimeException("Cannot set date in field '" + sFieldName + "' ");
        }
        if (oValue instanceof Number) {
            Number number = (Number)oValue;
            if ("int".equals(sTypeName) || "java.lang.Integer".equals(sTypeName)) {
                return new Integer(number.intValue());
            }
            if ("long".equals(sTypeName) || "java.lang.Long".equals(sTypeName)) {
                return new Long(number.longValue());
            }
            if ("short".equals(sTypeName) || "java.lang.Short".equals(sTypeName)) {
                return new Short(number.shortValue());
            }
            if ("byte".equals(sTypeName) || "java.lang.Byte".equals(sTypeName)) {
                return new Byte(number.byteValue());
            }
            if ("float".equals(sTypeName) || "java.lang.Float".equals(sTypeName)) {
                return new Float(number.floatValue());
            }
            if ("double".equals(sTypeName) || "java.lang.Double".equals(sTypeName)) {
                return new Double(number.doubleValue());
            }
            throw new RuntimeException("Cannot set number in field '" + sFieldName + "' ");
        }
        if (oValue instanceof LinkedList) {
            LinkedList list = (LinkedList)oValue;
            if ("java.util.List".equals(sTypeName)) {
                return list;
            }
            if ("java.util.Collection".equals(sTypeName)) {
                return list;
            }
            if ("java.util.LinkedList".equals(sTypeName)) {
                return list;
            }
            if (cType.isArray()) {
                throw new RuntimeException("Array type " + sTypeName + " not yet supported");
            }
        }
        return oValue;
    }

    public static void setFieldValue(Object oBean, String sFieldName, Object oValue) {
        Class<?>[] paramTypes;
        if (oBean == null) {
            throw new RuntimeException("setFieldValue : bean instance is null ");
        }
        if (sFieldName == null) {
            throw new RuntimeException("setFieldValue : field name is null ");
        }
        String sFieldName2 = sFieldName.trim();
        char cFirstChar = sFieldName2.charAt(0);
        if (Character.isLowerCase(cFirstChar)) {
            String s1 = sFieldName2.substring(0, 1);
            String s2 = sFieldName2.substring(1);
            sFieldName2 = s1.toUpperCase() + s2;
        }
        Class<?> beanClass = oBean.getClass();
        String sSetterMethodName = "set" + sFieldName2;
        Method setterMethod = null;
        setterMethod = ParserUtil.findMethodByName(beanClass, sSetterMethodName);
        if (setterMethod != null && (paramTypes = setterMethod.getParameterTypes()).length == 1) {
            Object oNewValue = ParserUtil.convertParam(oValue, paramTypes[0], sFieldName);
            ParserUtil.invokeSetterMethod(setterMethod, oBean, oNewValue);
            return;
        }
        throw new RuntimeException("Unknown field '" + sFieldName + "' : no " + sSetterMethodName + "(arg) in class = " + beanClass.getName());
    }
}

