/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.util.tinydb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import org.nanoj.util.tinydb.TinyTable;

public class TinyDatabase {
    private static final String DICTIONARY_FILE = "database.dict";
    private static TinyDatabase currentDatabase = null;
    private String databaseFolder = null;
    private String dictionaryFile = null;
    private Hashtable<String, TinyTable> htDatabaseTables = null;

    public TinyDatabase(String sFolder) {
        if (sFolder == null) {
            throw new RuntimeException("Database constructor : folder is null ");
        }
        this.databaseFolder = sFolder.endsWith("/") || sFolder.endsWith("\\") ? sFolder : sFolder + "/";
        this.dictionaryFile = this.databaseFolder + DICTIONARY_FILE;
        this.loadDictionary();
    }

    public String getDatabaseFolder() {
        return this.databaseFolder;
    }

    public static TinyDatabase getCurrentDatabase() {
        return currentDatabase;
    }

    private void loadDictionary() {
        try {
            FileInputStream fis = new FileInputStream(this.dictionaryFile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            this.htDatabaseTables = (Hashtable)ois.readObject();
            ois.close();
            fis.close();
        }
        catch (FileNotFoundException e) {
            this.htDatabaseTables = new Hashtable();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load dictionary : IOException", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot load dictionary : ClassNotFoundException", e);
        }
    }

    private void saveDictionary() {
        try {
            FileOutputStream fos = new FileOutputStream(this.dictionaryFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.htDatabaseTables);
            oos.close();
            fos.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Cannot save dictionary : FileNotFoundException", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot save dictionary : IOException", e);
        }
    }

    private void checkDictionary(String method) {
        if (this.htDatabaseTables == null) {
            throw new RuntimeException(method + " : Database not initialized (dictionary is null)");
        }
    }

    public void loadAllTables() {
        this.checkDictionary("loadAllTables");
        Enumeration<String> e = this.htDatabaseTables.keys();
        while (e.hasMoreElements()) {
            String tableName = e.nextElement();
            TinyTable table = this.htDatabaseTables.get(tableName);
            table.loadTable();
        }
    }

    public void saveAllTables() {
        this.checkDictionary("saveAllTables");
        for (TinyTable table : this.htDatabaseTables.values()) {
            table.saveTable();
        }
    }

    public String[] getTableNames() {
        this.checkDictionary("getTableNames");
        Set<String> keys = this.htDatabaseTables.keySet();
        return (String[])keys.toArray();
    }

    public TinyTable getTable(String sTableName) {
        return this.getTable(sTableName, true);
    }

    public TinyTable getTable(String sTableName, boolean mustExist) {
        this.checkDictionary("getTable(" + sTableName + ")");
        if (sTableName == null) {
            throw new RuntimeException("getTable : table name is null");
        }
        TinyTable o = this.htDatabaseTables.get(sTableName);
        if (o != null) {
            if (o instanceof TinyTable) {
                TinyTable table = o;
                if (!table.isLoaded()) {
                    table.loadTable();
                }
                return table;
            }
            throw new RuntimeException("getTable : database corrupted : unexpected type for table '" + sTableName + "' ( " + o.getClass().getName() + " )");
        }
        if (mustExist) {
            throw new RuntimeException("getTable : table '" + sTableName + "' unknown !");
        }
        return null;
    }

    public TinyTable createTable(String sTableName, Class<?> keyClass, Class<?> recordClass) {
        File file;
        String fileName;
        this.checkDictionary("createTable(" + sTableName + ")");
        if (sTableName == null) {
            throw new RuntimeException("createTable : table name is null");
        }
        if (recordClass == null) {
            throw new RuntimeException("createTable : record class is null");
        }
        TinyTable table = this.getTable(sTableName, false);
        if (table != null && (fileName = table.getTableFile()) != null && (file = new File(fileName)).exists()) {
            throw new RuntimeException("createTable : table '" + sTableName + "' already exists");
        }
        String sTableFile = this.buildTableFileName(sTableName);
        table = new TinyTable(sTableName, keyClass, recordClass, sTableFile);
        this.htDatabaseTables.put(sTableName, table);
        this.saveDictionary();
        return table;
    }

    public boolean dropTable(String sTableName) {
        this.checkDictionary("dropTable(" + sTableName + ")");
        if (sTableName == null) {
            throw new RuntimeException("createTable : table name is null");
        }
        TinyTable table = this.getTable(sTableName, false);
        if (table != null) {
            String fileName = table.getTableFile();
            this.deleteFile(fileName);
            this.htDatabaseTables.remove(sTableName);
            this.saveDictionary();
            return true;
        }
        String fileName = this.buildTableFileName(sTableName);
        return this.deleteFile(fileName);
    }

    private String buildTableFileName(String sTableName) {
        return this.databaseFolder + sTableName + ".table";
    }

    private boolean deleteFile(String fileName) {
        File file;
        if (fileName != null && (file = new File(fileName)).exists()) {
            return file.delete();
        }
        return false;
    }
}

