/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.util.serial;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class FileSerializer {
    private String _sFilePath = null;

    public FileSerializer(String sFileName) {
        if (null == sFileName) {
            throw new IllegalArgumentException("File name is null");
        }
        this._sFilePath = sFileName;
    }

    public void write(Object obj) throws Exception {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        if (this._sFilePath == null) {
            throw new Exception("File path is null");
        }
        try {
            fos = new FileOutputStream(this._sFilePath);
        }
        catch (FileNotFoundException e1) {
            throw new Exception("Cannot create FileOutputStream", e1);
        }
        try {
            oos = new ObjectOutputStream(fos);
        }
        catch (IOException e2) {
            fos.close();
            throw new Exception("Cannot create ObjectOutputStream", e2);
        }
        try {
            oos.writeObject(obj);
            oos.close();
            fos.close();
        }
        catch (IOException e3) {
            throw new Exception("ObjectOutputStream cannot write object ", e3);
        }
    }

    public Object read() throws Exception {
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        Object obj = null;
        if (this._sFilePath == null) {
            throw new Exception("File path is null");
        }
        try {
            fis = new FileInputStream(this._sFilePath);
        }
        catch (FileNotFoundException e1) {
            throw new Exception("Cannot create FileInputStream", e1);
        }
        try {
            ois = new ObjectInputStream(fis);
        }
        catch (IOException e2) {
            fis.close();
            throw new Exception("Cannot create ObjectInputStream", e2);
        }
        try {
            obj = ois.readObject();
            ois.close();
            fis.close();
        }
        catch (IOException e3) {
            throw new Exception("ObjectOutputStream cannot read object (IOException)", e3);
        }
        catch (ClassNotFoundException e4) {
            ois.close();
            throw new Exception("ObjectOutputStream cannot read object (ClassNotFoundException)", e4);
        }
        return obj;
    }
}

