/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.util.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class HttpClientResponse {
    private static final byte[] VOID_BYTE_ARRAY = new byte[0];
    protected static final boolean STORE_RESPONSE_BODY = true;
    protected static final boolean DO_NOT_STORE_RESPONSE_BODY = true;
    private int statusCode = 0;
    private String statusMessage = "";
    private int contentLength = 0;
    private String contentType = "";
    private String contentEncoding = "";
    private Map<String, List<String>> headerFields = null;
    private byte[] bodyContent = new byte[0];

    protected HttpClientResponse(HttpURLConnection connection) throws Exception {
        try {
            this.statusCode = connection.getResponseCode();
            this.statusMessage = connection.getResponseMessage();
            this.contentType = connection.getContentType();
            this.contentLength = connection.getContentLength();
            this.contentEncoding = connection.getContentEncoding();
            this.bodyContent = this.readResponseBody(connection);
        }
        catch (IOException e) {
            throw new Exception("Cannot create HttpResponse (IOException)", e);
        }
        this.headerFields = connection.getHeaderFields();
    }

    private byte[] readResponseBody(HttpURLConnection connection) {
        byte[] buffer = new byte[1024];
        int totalLength = 0;
        byte[] responseBody = VOID_BYTE_ARRAY;
        try {
            int len = 0;
            InputStream is = connection.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            while ((len = is.read(buffer)) > 0) {
                baos.write(buffer, 0, len);
                totalLength += len;
            }
            baos.close();
            responseBody = baos.toByteArray();
        }
        catch (IOException e) {
            responseBody = VOID_BYTE_ARRAY;
        }
        return responseBody;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public byte[] getBodyContent() {
        return this.bodyContent;
    }

    public Collection<String> getHeader(String name) {
        List<String> fields = this.headerFields.get(name);
        return fields;
    }

    public Map<String, List<String>> getHeaderMap() {
        return this.headerFields;
    }
}

