/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.util.beanwriter;

import java.io.IOException;
import java.io.Writer;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import org.nanoj.util.DateUtil;
import org.nanoj.util.beanwriter.BeanTranslator;
import org.nanoj.util.beanwriter.util.XmlUtil;

public class XmlBeanTranslator
implements BeanTranslator {
    private static final String END_OF_LINE = "\n";
    private static final String ROOT_TAG = "root";
    private static final String NULL_TAG = "null";
    private String rootTag = "root";
    private String nullTag = "null";
    private int currentLevel = 0;
    private boolean formattedOutput = false;
    private boolean writeNullAttribute = true;

    public XmlBeanTranslator() {
        this.formattedOutput = false;
        this.rootTag = ROOT_TAG;
    }

    public XmlBeanTranslator(boolean formattedOutput) {
        this.formattedOutput = formattedOutput;
        this.rootTag = ROOT_TAG;
    }

    public XmlBeanTranslator(boolean formattedOutput, String rootTag) {
        this.formattedOutput = formattedOutput;
        this.rootTag = rootTag;
    }

    public void setNullTag(String nullTag) {
        this.nullTag = nullTag;
    }

    public void setWriteNullAttribute(boolean flag) {
        this.writeNullAttribute = flag;
    }

    @Override
    public void open(Writer output) {
        this.currentLevel = 0;
        this.write(output, "<" + this.rootTag + ">");
    }

    @Override
    public void close(Writer output) {
        this.currentLevel = 0;
        this.write(output, END_OF_LINE);
        this.write(output, "</" + this.rootTag + ">");
        this.write(output, END_OF_LINE);
    }

    @Override
    public void openSubObjects(Writer output, Object bean, String name) {
        this.write(output, " >");
    }

    @Override
    public void closeSubObjects(Writer output, Object bean, String name) {
    }

    @Override
    public void openObject(Writer output, Object bean, String name) {
        this.writeNewLine(output);
        String sTagName = this.getTagName(bean, name);
        this.write(output, "<" + sTagName + " ");
        ++this.currentLevel;
    }

    @Override
    public void closeObject(Writer output, Object bean, String name, int subObjectsCount) {
        --this.currentLevel;
        if (subObjectsCount > 0) {
            this.writeNewLine(output);
            String sTagName = this.getTagName(bean, name);
            this.write(output, "</" + sTagName + ">");
        } else {
            this.write(output, "/>");
        }
    }

    @Override
    public void writeComment(Writer output, String comment) {
        this.writeNewLine(output);
        this.write(output, "<!-- " + comment + " -->");
    }

    @Override
    public void writeNullValue(Writer output, String name, Object parent) {
        if (parent != null) {
            if (this.isArrayOrCollection(parent)) {
                this.writeNullTag(output);
            } else if (this.writeNullAttribute) {
                this.write(output, name + "=\"\" ");
            }
        } else {
            this.writeNullTag(output);
        }
    }

    private void writeNullTag(Writer output) {
        if (this.nullTag != null) {
            this.writeNewLine(output);
            this.write(output, "<" + this.nullTag + "/>");
        }
    }

    @Override
    public void writeValue(Writer output, Object obj, String name, Object parent) {
        String sTagName = this.getTagName(obj, name);
        String sValue = null;
        if (obj instanceof String) {
            sValue = XmlUtil.xmlString((String)obj);
        } else if (obj instanceof Number) {
            sValue = ((Number)obj).toString();
        } else if (obj instanceof Boolean) {
            sValue = ((Boolean)obj).toString();
        } else if (obj instanceof java.sql.Date) {
            sValue = ((java.sql.Date)obj).toString();
        } else if (obj instanceof Time) {
            sValue = ((Time)obj).toString();
        } else if (obj instanceof Timestamp) {
            sValue = ((Timestamp)obj).toString();
        } else if (obj instanceof Date) {
            Date date = (Date)obj;
            sValue = DateUtil.dateTimeISO(date);
        } else if (obj instanceof Character) {
            Character c = (Character)obj;
            sValue = c.toString();
        }
        if (parent != null && !this.isArrayOrCollection(parent)) {
            this.write(output, name + "=\"" + sValue + "\" ");
        } else {
            this.writeNewLine(output);
            this.write(output, "<" + sTagName + " value=\"" + sValue + "\" />");
        }
    }

    @Override
    public void writeSubElementValue(Writer output, Object value, String name, Object parent) {
        this.writeNewLine(output);
        if (value != null) {
            this.write(output, "<" + name + "><![CDATA[");
            this.write(output, value.toString());
            this.write(output, "]]></" + name + ">");
        } else {
            this.write(output, "<" + name + "/>");
        }
    }

    private String getTagName(Object obj, String name) {
        if (name != null) {
            return name;
        }
        if (obj != null) {
            return obj.getClass().getSimpleName();
        }
        return NULL_TAG;
    }

    private void write(Writer writer, String s) {
        try {
            writer.write(s);
        }
        catch (IOException ex) {
            throw new RuntimeException("IOException", ex);
        }
    }

    private boolean isArrayOrCollection(Object o) {
        if (null == o) {
            return false;
        }
        if (o.getClass().isArray()) {
            return true;
        }
        return o instanceof Collection;
    }

    @Override
    public void openArray(Writer output, Object[] array, String name, Object parent) {
        this.writeNewLine(output);
        this.write(output, "<" + (name != null ? name : "array") + ">");
        ++this.currentLevel;
    }

    @Override
    public void closeArray(Writer output, Object[] array, String name, Object parent) {
        --this.currentLevel;
        this.writeNewLine(output);
        this.write(output, "</" + (name != null ? name : "array") + ">");
    }

    @Override
    public void openCollection(Writer output, Collection<?> collection, String name, Object parent) {
        this.writeNewLine(output);
        this.write(output, "<" + (name != null ? name : "collection") + ">");
        ++this.currentLevel;
    }

    @Override
    public void closeCollection(Writer output, Collection<?> collection, String name, Object parent) {
        --this.currentLevel;
        this.writeNewLine(output);
        this.write(output, "</" + (name != null ? name : "collection") + ">");
    }

    private void writeNewLine(Writer output) {
        if (this.formattedOutput) {
            this.write(output, END_OF_LINE);
            for (int i = 0; i <= this.currentLevel; ++i) {
                this.write(output, "  ");
            }
        }
    }
}

