/**
 *  Copyright (C) 2013-2016 Laurent GUERIN - NanoJ project org. ( http://www.nanoj.org/ )
 *
 *  Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *          http://www.gnu.org/licenses/lgpl.html
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.nanoj.util.tson;

public class Attribute {

	public String name = null ;
	
	/**
	 * The attribute's value can be <br>
	 * . a basic value ( string, number, date, boolean, ... ) <br>
	 *     Java types : String, Boolean, BigDecimal, BigInteger <br>
	 * . an entity : in this case the value class can be any kind of object ) <br>
	 *     Java type : any kind of Java class <br>
	 * . a collection of entities : in this case the value class is a 'LinkedList' <br>
	 *     Java type : LinkedList ( to keep the order ) <br>
	 * . a null value <br>
	 */
	public Object value = null ;
}
