/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.util.tinydb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;

public class TinyTable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Hashtable<Object, Object> htRecords = null;
    private String tableName = null;
    private Class<?> recordClass = null;
    private Class<?> keyClass = null;
    private String tableFile = null;

    protected TinyTable(String tableName, Class<?> keyClass, Class<?> recordClass, String tableFile) {
        if (tableName == null) {
            throw new RuntimeException("Constructor : table name is null");
        }
        if (keyClass == null) {
            throw new RuntimeException("Constructor : key class is null");
        }
        if (recordClass == null) {
            throw new RuntimeException("Constructor : record class is null");
        }
        if (tableFile == null) {
            throw new RuntimeException("Constructor : table file is null");
        }
        this.tableName = tableName;
        this.keyClass = keyClass;
        this.recordClass = recordClass;
        this.tableFile = tableFile;
        this.htRecords = new Hashtable();
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableFile() {
        return this.tableFile;
    }

    public Class<?> getKeyClass() {
        return this.keyClass;
    }

    public Class<?> getRecordClass() {
        return this.recordClass;
    }

    public boolean isLoaded() {
        return this.htRecords != null;
    }

    public synchronized Hashtable<Object, Object> loadTable() {
        Hashtable<Object, Object> ht = null;
        try {
            FileInputStream fis = new FileInputStream(this.tableFile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            this.htRecords = (Hashtable)ois.readObject();
            ois.close();
            fis.close();
        }
        catch (FileNotFoundException e) {
            this.htRecords = new Hashtable();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load : IOException", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot load : ClassNotFoundException", e);
        }
        return ht;
    }

    public synchronized void saveTable() {
        try {
            FileOutputStream fos = new FileOutputStream(this.tableFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.htRecords);
            oos.close();
            fos.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Cannot save : FileNotFoundException", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot save : IOException", e);
        }
    }

    private Object copy(Object record) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(record);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            return ois.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot copy record " + record.getClass() + " via serialization ");
        }
    }

    public Object findRecord(Object key) {
        this.check("find", key);
        Object record = this.htRecords.get(key);
        if (record != null) {
            return this.copy(record);
        }
        return null;
    }

    public void insertOrUpdateRecord(Object key, Object record) {
        this.check("insert or update", key, record);
        Object key2 = this.copy(key);
        Object record2 = this.copy(record);
        this.htRecords.put(key2, record2);
    }

    public void insertRecord(Object key, Object record) {
        this.check("insert", key, record);
        if (this.htRecords.get(key) != null) {
            throw new RuntimeException("Cannot insert record (" + this.recordClass + ") : duplicate key");
        }
        Object key2 = this.copy(key);
        Object record2 = this.copy(record);
        this.htRecords.put(key2, record2);
    }

    public boolean updateRecord(Object key, Object record) {
        this.check("update", key, record);
        if (this.htRecords.get(key) != null) {
            Object key2 = this.copy(key);
            Object record2 = this.copy(record);
            this.htRecords.put(key2, record2);
            return true;
        }
        return false;
    }

    public boolean deleteRecord(Object key) {
        this.check("delete", key);
        Object o = this.htRecords.remove(key);
        return o != null;
    }

    private void check(String operation, Object key) {
        if (this.htRecords == null) {
            throw new RuntimeException("Cannot " + operation + " record : table not loaded");
        }
        if (key == null) {
            throw new RuntimeException("Cannot " + operation + " record : key is null");
        }
        if (!this.keyClass.isInstance(key)) {
            throw new RuntimeException("Cannot " + operation + " record : key is not an instance of " + this.keyClass);
        }
    }

    private void check(String operation, Object key, Object record) {
        this.check(operation, key);
        if (record == null) {
            throw new RuntimeException("Cannot " + operation + " record : record is null");
        }
        if (!this.recordClass.isInstance(record)) {
            throw new RuntimeException("Cannot " + operation + " record : record is not an instance of " + this.recordClass);
        }
    }
}

