/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.util.introspection;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class BeanGetter {
    private static final String ERROR_INVOKE_GETTER = "Cannot invoke getter ";
    String propertyName = "";
    Method method = null;
    boolean xmlElement = false;

    public BeanGetter(Method method, String propertyName) {
        Annotation[] annotations;
        this.propertyName = propertyName;
        this.method = method;
        for (Annotation a : annotations = method.getAnnotations()) {
            Class<? extends Annotation> c = a.annotationType();
            if (!c.getName().endsWith("XmlElement")) continue;
            this.xmlElement = true;
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    public boolean isSubElement() {
        return this.xmlElement;
    }

    public Object invoke(Object bean) {
        String sMethodName = this.method.getName();
        Object retValue = null;
        try {
            retValue = this.method.invoke(bean, (Object[])null);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(ERROR_INVOKE_GETTER + sMethodName, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(ERROR_INVOKE_GETTER + sMethodName, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(ERROR_INVOKE_GETTER + sMethodName, e);
        }
        return retValue;
    }
}

