/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.util.beanwriter;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Date;
import org.nanoj.util.beanwriter.BeanTranslator;
import org.nanoj.util.introspection.BeanGetter;
import org.nanoj.util.introspection.BeanIntrospector;

public class BeanWriter {
    private Writer output = null;
    private BeanTranslator writer = null;

    public BeanWriter(Writer outputWriter, BeanTranslator beanWriter) {
        this.output = outputWriter;
        this.writer = beanWriter;
    }

    public void open() {
        this.writer.open(this.output);
    }

    public void close() {
        this.writer.close(this.output);
        try {
            this.output.flush();
            this.output.close();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException : cannot close output.", e);
        }
    }

    public void writeObject(Object bean) {
        this.writeLevel(bean, null, null);
    }

    public void writeObject(Object bean, String name) {
        this.writeLevel(bean, name, null);
    }

    public void writeComment(String comment) {
        this.writer.writeComment(this.output, comment);
    }

    private void writeLevel(Object bean, String name, Object parent) {
        if (bean != null) {
            if (this.isBasicType(bean)) {
                this.writer.writeValue(this.output, bean, name, parent);
            } else if (this.isArray(bean)) {
                Object[] array = this.getArrayOfObjects(bean);
                this.writer.openArray(this.output, array, name, parent);
                for (Object o : array) {
                    this.writeLevel(o, null, bean);
                }
                this.writer.closeArray(this.output, array, name, parent);
            } else if (this.isCollection(bean)) {
                Collection collection = (Collection)bean;
                this.writer.openCollection(this.output, collection, name, parent);
                for (Object o : collection) {
                    this.writeLevel(o, null, bean);
                }
                this.writer.closeCollection(this.output, collection, name, parent);
            } else {
                Object childObject;
                Class<?> returnType;
                BeanGetter[] getters;
                this.writer.openObject(this.output, bean, name);
                int subObjectsCount = 0;
                for (BeanGetter getter : getters = BeanIntrospector.getGetters(bean)) {
                    if (getter.isSubElement()) {
                        ++subObjectsCount;
                        continue;
                    }
                    returnType = getter.getReturnType();
                    if (this.isBasicType(returnType)) {
                        childObject = getter.invoke(bean);
                        if (childObject != null) {
                            this.writeLevel(childObject, getter.getPropertyName(), bean);
                            continue;
                        }
                        this.writer.writeNullValue(this.output, getter.getPropertyName(), bean);
                        continue;
                    }
                    ++subObjectsCount;
                }
                if (subObjectsCount > 0) {
                    this.writer.openSubObjects(this.output, bean, name);
                    for (BeanGetter getter : getters) {
                        returnType = getter.getReturnType();
                        if (!this.isBasicType(returnType)) {
                            childObject = getter.invoke(bean);
                            if (childObject != null) {
                                this.writeLevel(childObject, getter.getPropertyName(), bean);
                                continue;
                            }
                            this.writer.writeNullValue(this.output, getter.getPropertyName(), bean);
                            continue;
                        }
                        if (!getter.isSubElement()) continue;
                        Object value = getter.invoke(bean);
                        this.writer.writeSubElementValue(this.output, value, getter.getPropertyName(), bean);
                    }
                    this.writer.closeSubObjects(this.output, bean, name);
                }
                this.writer.closeObject(this.output, bean, name, subObjectsCount);
            }
        } else {
            this.writer.writeNullValue(this.output, name, parent);
        }
    }

    private boolean isBasicType(Object bean) {
        if (bean instanceof String) {
            return true;
        }
        if (bean instanceof Number) {
            return true;
        }
        if (bean instanceof Boolean) {
            return true;
        }
        if (bean instanceof Date) {
            return true;
        }
        return bean instanceof Character;
    }

    private boolean isCollection(Object bean) {
        return bean instanceof Collection;
    }

    private boolean isArray(Object bean) {
        return bean.getClass().isArray();
    }

    private Object[] getArrayOfObjects(Object array) {
        Class<?> itemType = array.getClass().getComponentType();
        if (itemType.isPrimitive()) {
            int arraylength = Array.getLength(array);
            Object[] arrayOfObjects = new Object[arraylength];
            for (int i = 0; i < arraylength; ++i) {
                arrayOfObjects[i] = Array.get(array, i);
            }
            return arrayOfObjects;
        }
        return (Object[])array;
    }

    private boolean isBasicType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        if (String.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return true;
        }
        return Date.class.isAssignableFrom(clazz);
    }
}

