/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.util.beanmapper;

import java.util.LinkedList;

public class PropertyErrorCollector {
    public static final int NULL_VALUE_FOR_PRIMITIVE_TYPE = 1;
    private LinkedList<String> errors = null;

    private void checkErrorsListReady() {
        if (null == this.errors) {
            this.errors = new LinkedList();
        }
    }

    public void addError(String propertyName, String errorMessage) {
        this.checkErrorsListReady();
        this.errors.add(errorMessage + " (property '" + propertyName + "')");
    }

    public void addError(String propertyName, int errorType) {
        this.checkErrorsListReady();
        String sMessage = "Error";
        switch (errorType) {
            case 1: {
                sMessage = "Cannot set a null value for a primitive type";
            }
        }
        this.errors.add(sMessage + " (property '" + propertyName + "')");
    }

    public int errorsCount() {
        return this.errors != null ? this.errors.size() : 0;
    }

    public LinkedList<String> getErrors() {
        return this.errors;
    }
}

