/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.util.beanmapper;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Properties;
import org.nanoj.util.beanmapper.BeanProperties;
import org.nanoj.util.beanmapper.PropertyErrorCollector;
import org.nanoj.util.beanmapper.TypeConvertor;
import org.nanoj.util.introspection.BeanGetter;
import org.nanoj.util.introspection.BeanIntrospector;
import org.nanoj.util.introspection.BeanSetter;

public class BeanMapper {
    private TypeConvertor typeConvertor = TypeConvertor.getInstance();
    private PropertyErrorCollector errorCollector = null;

    private void log(String msg) {
    }

    public BeanMapper() {
        this.errorCollector = new PropertyErrorCollector();
    }

    public BeanMapper(PropertyErrorCollector errorCollector) {
        this.errorCollector = errorCollector;
    }

    public PropertyErrorCollector getErrors() {
        return this.errorCollector;
    }

    public <T> T getTypedValue(Class<T> expectedType, String stringValue) {
        return (T)this.convertStringToObject(expectedType, stringValue);
    }

    private Object convertStringToObject(Class<?> expectedType, String stringValue) {
        String typeName = expectedType.getSimpleName();
        String longTypeName = expectedType.getCanonicalName();
        this.log("convertValue(" + typeName + ", '" + stringValue + "')");
        if ("String".equals(typeName)) {
            return stringValue;
        }
        if ("int".equals(typeName) || "Integer".equals(typeName)) {
            return this.typeConvertor.toIntegerObject(stringValue);
        }
        if ("double".equals(typeName) || "Double".equals(typeName)) {
            return this.typeConvertor.toDoubleObject(stringValue);
        }
        if ("float".equals(typeName) || "Float".equals(typeName)) {
            return this.typeConvertor.toFloatObject(stringValue);
        }
        if ("long".equals(typeName) || "Long".equals(typeName)) {
            return this.typeConvertor.toLongObject(stringValue);
        }
        if ("short".equals(typeName) || "Short".equals(typeName)) {
            return this.typeConvertor.toShortObject(stringValue);
        }
        if ("byte".equals(typeName) || "Byte".equals(typeName)) {
            return this.typeConvertor.toByteObject(stringValue);
        }
        if ("boolean".equals(typeName) || "Boolean".equals(typeName)) {
            return this.typeConvertor.toBooleanObject(stringValue);
        }
        if ("BigDecimal".equals(typeName)) {
            return this.typeConvertor.toBigDecimalObject(stringValue);
        }
        if ("BigInteger".equals(typeName)) {
            return this.typeConvertor.toBigIntegerObject(stringValue);
        }
        if ("java.util.Date".equals(longTypeName)) {
            return this.typeConvertor.toUtilDateObject(stringValue);
        }
        if ("java.sql.Date".equals(longTypeName)) {
            return this.typeConvertor.toSqlDateObject(stringValue);
        }
        if ("java.sql.Time".equals(longTypeName)) {
            return this.typeConvertor.toSqlTimeObject(stringValue);
        }
        if ("java.sql.Timestamp".equals(longTypeName)) {
            return this.typeConvertor.toSqlTimestampObject(stringValue);
        }
        throw new RuntimeException("Unknown type '" + longTypeName + "'", null);
    }

    private String convertObjectToString(Object value) {
        String typeName = value.getClass().getSimpleName();
        String longTypeName = value.getClass().getCanonicalName();
        this.log("convertValue(" + value + ")  type = " + typeName);
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Integer) {
            return this.typeConvertor.toString((Integer)value);
        }
        if (value instanceof Double) {
            return this.typeConvertor.toString((Double)value);
        }
        if (value instanceof Float) {
            return this.typeConvertor.toString((Float)value);
        }
        if (value instanceof Long) {
            return this.typeConvertor.toString((Long)value);
        }
        if (value instanceof Short) {
            return this.typeConvertor.toString((Short)value);
        }
        if (value instanceof Byte) {
            return this.typeConvertor.toString((Byte)value);
        }
        if (value instanceof Boolean) {
            return this.typeConvertor.toString((Boolean)value);
        }
        if (value instanceof BigDecimal) {
            return this.typeConvertor.toString((BigDecimal)value);
        }
        if (value instanceof BigInteger) {
            return this.typeConvertor.toString((BigInteger)value);
        }
        if (value instanceof java.util.Date) {
            return this.typeConvertor.toString((java.util.Date)value);
        }
        if (value instanceof Date) {
            return this.typeConvertor.toString((Date)value);
        }
        if (value instanceof Time) {
            return this.typeConvertor.toString((Time)value);
        }
        if (value instanceof Timestamp) {
            return this.typeConvertor.toString((Timestamp)value);
        }
        throw new RuntimeException("Unknown type '" + longTypeName + "'", null);
    }

    public final void mapToBean(Map<String, String> map, Object bean) {
        if (null == map) {
            throw new IllegalArgumentException("map is null");
        }
        this.mapToBean(new BeanProperties(map), bean);
    }

    public final void mapToBean(Properties properties, Object bean) {
        if (null == properties) {
            throw new IllegalArgumentException("properties is null");
        }
        this.mapToBean(new BeanProperties(properties), bean);
    }

    private final void mapToBean(BeanProperties beanProperties, Object bean) {
        BeanSetter[] setters;
        if (null == bean) {
            throw new IllegalArgumentException("bean is null");
        }
        for (BeanSetter setter : setters = BeanIntrospector.getSetters(bean)) {
            String propertyName = setter.getPropertyName();
            String propertyValue = beanProperties.get(propertyName);
            if (propertyValue == null) continue;
            Class<String> setterParamType = setter.getPropertyType();
            if (setterParamType.isAssignableFrom(String.class)) {
                setter.invoke(bean, propertyValue);
                continue;
            }
            Object convertedValue = this.convertStringToObject(setterParamType, propertyValue);
            if (setterParamType.isPrimitive() && null == convertedValue) {
                this.errorCollector.addError(propertyName, 1);
                continue;
            }
            setter.invoke(bean, convertedValue);
        }
    }

    public final void beanToMap(Object bean, Properties properties) {
        if (null == properties) {
            throw new IllegalArgumentException("properties is null");
        }
        BeanProperties beanProperties = new BeanProperties(properties);
        this.beanToMap(bean, beanProperties);
    }

    public final void beanToMap(Object bean, Map<String, String> map) {
        if (null == map) {
            throw new IllegalArgumentException("map is null");
        }
        BeanProperties beanProperties = new BeanProperties(map);
        this.beanToMap(bean, beanProperties);
    }

    private final void beanToMap(Object bean, BeanProperties beanProperties) {
        BeanGetter[] getters;
        if (null == bean) {
            throw new IllegalArgumentException("bean is null");
        }
        for (BeanGetter getter : getters = BeanIntrospector.getGetters(bean)) {
            Object ret = getter.invoke(bean);
            String propertyName = getter.getPropertyName();
            if (ret != null) {
                String sValue = this.convertObjectToString(ret);
                beanProperties.set(propertyName, sValue);
                continue;
            }
            beanProperties.set(propertyName, "");
        }
    }
}

